/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import soot.util.Chain;

public class HashChain
extends AbstractCollection
implements Chain {
    private HashMap map = new HashMap();
    private Object firstItem = null;
    private Object lastItem = null;
    private long stateCount = 0L;

    public void clear() {
        ++this.stateCount;
        this.lastItem = null;
        this.firstItem = null;
        this.map.clear();
    }

    public void swapWith(Object out, Object in) {
        this.insertBefore(in, out);
        this.remove(out);
    }

    public boolean add(Object item) {
        this.addLast(item);
        return true;
    }

    public static List toList(Chain c) {
        Iterator it = c.iterator();
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public boolean follows(Object someObject, Object someReferenceObject) {
        Iterator it = this.iterator(someObject);
        while (it.hasNext()) {
            if (it.next() != someReferenceObject) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.map.containsKey(it.next())) continue;
            return false;
        }
        return true;
    }

    public void insertAfter(Object toInsert, Object point) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert  a null object into a Chain!");
        }
        if (this.map.containsKey(toInsert)) {
            throw new RuntimeException("Chain already contains object.");
        }
        ++this.stateCount;
        Link temp = (Link)this.map.get(point);
        Link newLink = temp.insertAfter(toInsert);
        this.map.put(toInsert, newLink);
    }

    public void insertAfter(List toInsert, Object point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        Object previousPoint = point;
        for (Object o : toInsert) {
            this.insertAfter(o, previousPoint);
            previousPoint = o;
        }
    }

    public void insertBefore(Object toInsert, Object point) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert a null object into a Chain!");
        }
        if (this.map.containsKey(toInsert)) {
            throw new RuntimeException("Chain already contains object.");
        }
        ++this.stateCount;
        Link temp = (Link)this.map.get(point);
        Link newLink = temp.insertBefore(toInsert);
        this.map.put(toInsert, newLink);
    }

    public void insertBefore(List toInsert, Object point) {
        if (toInsert == null) {
            throw new RuntimeException("Warning! You tried to insert a null list into a Chain!");
        }
        for (Object o : toInsert) {
            this.insertBefore(o, point);
        }
    }

    public static HashChain listToHashChain(List list) {
        HashChain c = new HashChain();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            c.addLast(it.next());
        }
        return c;
    }

    public boolean remove(Object item) {
        if (item == null) {
            throw new RuntimeException("Bad idea! You tried to remove  a null object from a Chain!");
        }
        ++this.stateCount;
        Link link = (Link)this.map.get(item);
        link.unlinkSelf();
        this.map.remove(item);
        return true;
    }

    public void addFirst(Object item) {
        Link newLink;
        if (item == null) {
            throw new RuntimeException("Bad idea!  You tried to insert a null object into a Chain!");
        }
        ++this.stateCount;
        if (this.map.containsKey(item)) {
            throw new RuntimeException("Chain already contains object.");
        }
        if (this.firstItem != null) {
            Link temp = (Link)this.map.get(this.firstItem);
            newLink = temp.insertBefore(item);
        } else {
            newLink = new Link(item);
            this.firstItem = this.lastItem = item;
        }
        this.map.put(item, newLink);
    }

    public void addLast(Object item) {
        Link newLink;
        if (item == null) {
            throw new RuntimeException("Bad idea! You tried to insert  a null object into a Chain!");
        }
        ++this.stateCount;
        if (this.map.containsKey(item)) {
            throw new RuntimeException("Chain already contains object: " + item);
        }
        if (this.lastItem != null) {
            Link temp = (Link)this.map.get(this.lastItem);
            newLink = temp.insertAfter(item);
        } else {
            newLink = new Link(item);
            this.firstItem = this.lastItem = item;
        }
        this.map.put(item, newLink);
    }

    public void removeFirst() {
        ++this.stateCount;
        Object item = this.firstItem;
        ((Link)this.map.get(this.firstItem)).unlinkSelf();
        this.map.remove(item);
    }

    public void removeLast() {
        ++this.stateCount;
        Object item = this.lastItem;
        ((Link)this.map.get(this.lastItem)).unlinkSelf();
        this.map.remove(item);
    }

    public Object getFirst() {
        if (this.firstItem == null) {
            throw new NoSuchElementException();
        }
        return this.firstItem;
    }

    public Object getLast() {
        if (this.lastItem == null) {
            throw new NoSuchElementException();
        }
        return this.lastItem;
    }

    public Object getSuccOf(Object point) throws NoSuchElementException {
        Link link = (Link)this.map.get(point);
        try {
            link = link.getNext();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException();
        }
        if (link == null) {
            return null;
        }
        return link.getItem();
    }

    public Object getPredOf(Object point) throws NoSuchElementException {
        Link link = (Link)this.map.get(point);
        if (point == null) {
            throw new RuntimeException("trying to hash null value.");
        }
        try {
            link = link.getPrevious();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException();
        }
        if (link == null) {
            return null;
        }
        return link.getItem();
    }

    public Iterator snapshotIterator() {
        ArrayList l = new ArrayList(this.map.size());
        l.addAll(this);
        return l.iterator();
    }

    public Iterator snapshotIterator(Object item) {
        ArrayList l = new ArrayList(this.map.size());
        LinkIterator it = new LinkIterator(item);
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l.iterator();
    }

    public Iterator iterator() {
        return new LinkIterator(this.firstItem);
    }

    public Iterator iterator(Object item) {
        return new LinkIterator(item);
    }

    public Iterator iterator(Object head, Object tail) {
        return new LinkIterator(head, tail);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = this.iterator();
        boolean b = false;
        strBuf.append("[");
        while (it.hasNext()) {
            if (!b) {
                b = true;
            } else {
                strBuf.append(", ");
            }
            strBuf.append(it.next().toString());
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    class LinkIterator
    implements Iterator {
        private Link currentLink;
        boolean state;
        boolean stop;
        private Object destination;
        private long iteratorStateCount;

        public LinkIterator(Object item) {
            this.currentLink = new Link(null);
            this.currentLink.setNext((Link)HashChain.this.map.get(item));
            this.state = false;
            this.stop = false;
            this.destination = null;
            this.iteratorStateCount = HashChain.this.stateCount;
        }

        public LinkIterator(Object from, Object to) {
            this(from);
            this.destination = to;
        }

        public boolean hasNext() {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.currentLink.getNext() == null) {
                return false;
            }
            return !this.stop;
        }

        public Object next() throws NoSuchElementException {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            Link temp = this.currentLink.getNext();
            if (temp == null || this.stop) {
                throw new NoSuchElementException(temp + " " + this.stop);
            }
            this.currentLink = temp;
            if (this.destination != null && this.destination == this.currentLink.getItem()) {
                this.stop = true;
            }
            this.state = true;
            return this.currentLink.getItem();
        }

        public void remove() throws IllegalStateException {
            if (HashChain.this.stateCount != this.iteratorStateCount) {
                throw new ConcurrentModificationException();
            }
            HashChain.this.stateCount++;
            ++this.iteratorStateCount;
            if (!this.state) {
                throw new IllegalStateException();
            }
            this.currentLink.unlinkSelf();
            HashChain.this.map.remove(this.currentLink.getItem());
            this.state = false;
        }

        public String toString() {
            if (this.currentLink == null) {
                return "Current object under iterator is null" + super.toString();
            }
            return this.currentLink.toString();
        }
    }

    class Link
    implements Serializable {
        private Link nextLink;
        private Link previousLink;
        private Object item;
        private int index;

        public Link(Object item) {
            this.item = item;
            this.previousLink = null;
            this.nextLink = null;
        }

        public Link getNext() {
            return this.nextLink;
        }

        public Link getPrevious() {
            return this.previousLink;
        }

        public void setNext(Link link) {
            this.nextLink = link;
        }

        public void setPrevious(Link link) {
            this.previousLink = link;
        }

        public void unlinkSelf() {
            this.bind(this.previousLink, this.nextLink);
        }

        public Link insertAfter(Object item) {
            Link newLink = new Link(item);
            this.bind(newLink, this.nextLink);
            this.bind(this, newLink);
            return newLink;
        }

        public Link insertBefore(Object item) {
            Link newLink = new Link(item);
            this.bind(this.previousLink, newLink);
            this.bind(newLink, this);
            return newLink;
        }

        private void bind(Link a, Link b) {
            if (a == null) {
                if (b != null) {
                    HashChain.this.firstItem = b.getItem();
                } else {
                    HashChain.this.firstItem = null;
                }
            } else {
                a.setNext(b);
            }
            if (b == null) {
                if (a != null) {
                    HashChain.this.lastItem = a.getItem();
                } else {
                    HashChain.this.lastItem = null;
                }
            } else {
                b.setPrevious(a);
            }
        }

        public Object getItem() {
            return this.item;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return "Link item is null" + super.toString();
        }
    }
}

