/*
 * Decompiled with CFR 0.152.
 */
package soot.tools;

import java.util.Hashtable;
import java.util.Iterator;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphNode;

public class CFGViewer {
    public static final int UNITGRAPH = 0;
    public static final int BLOCKGRAPH = 1;
    public static final int ARRAYBLOCK = 2;
    public int graphtype = 0;
    public String clsname;
    public String methname;
    public boolean isBrief = false;
    private int meth_count = 0;
    public boolean onepage = true;
    public static boolean shimple = false;
    public static boolean viaShimple = false;
    public static boolean complete = false;
    private int nodecount = 0;

    public static void main(String[] args) {
        new CFGViewer().run(args);
    }

    public void run(String[] args) {
        if (args.length == 0) {
            this.usage();
            return;
        }
        this.parse_options(args);
        SootClass cls = Scene.v().loadClassAndSupport(this.clsname);
        cls.setApplicationClass();
        Iterator methodIt = cls.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod meth = (SootMethod)methodIt.next();
            if (this.methname != null && !this.methname.equals(meth.getName()) || !meth.isConcrete()) continue;
            Body body = meth.retrieveActiveBody();
            if (shimple || viaShimple) {
                body = Shimple.v().newBody(body);
            }
            if (viaShimple && !shimple) {
                body = Shimple.v().newJimpleBody((ShimpleBody)body);
            }
            this.print_cfg(body);
        }
    }

    private void usage() {
        G.v().out.println("Usage:");
        G.v().out.println("   java soot.util.CFGViewer [options] class[:method]");
        G.v().out.println("   options:");
        G.v().out.println("       --unit|block|array : produces the unit(default)/block graph.");
        G.v().out.println("       --brief : uses the unit/block index as the label.");
        G.v().out.println("       --soot-classpath PATHs : specifies the soot class pathes.");
        G.v().out.println("       --multipages : produces the dot file sets multi pages (8.5x11).");
        G.v().out.println("                      By default, the graph is in one page.");
    }

    private void parse_options(String[] args) {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            if (args[i].equals("--unit")) {
                this.graphtype = 0;
                continue;
            }
            if (args[i].equals("--block")) {
                this.graphtype = 1;
                continue;
            }
            if (args[i].equals("--array")) {
                this.graphtype = 2;
                continue;
            }
            if (args[i].equals("--brief")) {
                this.isBrief = true;
                continue;
            }
            if (args[i].equals("--soot-classpath")) {
                Scene.v().setSootClassPath(args[++i]);
                continue;
            }
            if (args[i].equals("--multipages")) {
                this.onepage = false;
                continue;
            }
            if (args[i].equals("--shimple")) {
                shimple = true;
                continue;
            }
            if (args[i].equals("--via-shimple")) {
                viaShimple = true;
                continue;
            }
            if (args[i].equals("--complete")) {
                complete = true;
                continue;
            }
            int smpos = args[i].indexOf(58);
            if (smpos == -1) {
                this.clsname = args[i];
                continue;
            }
            this.clsname = args[i].substring(0, smpos);
            this.methname = args[i].substring(smpos + 1);
        }
    }

    protected void print_cfg(Body body) {
        SootMethod method = body.getMethod();
        SootClass sclass = method.getDeclaringClass();
        DirectedGraph graph = null;
        switch (this.graphtype) {
            case 0: {
                graph = new UnitGraph(body, complete);
                break;
            }
            case 1: {
                if (complete) {
                    graph = new BlockGraph(body, 0);
                    break;
                }
                graph = new BlockGraph(body, 1);
                break;
            }
            case 2: {
                graph = new BlockGraph(body, 99);
            }
        }
        String methodname = method.getName() + "-" + this.meth_count++;
        String graphname = sclass.getName() + ":" + method.getName();
        this.toDotFile(methodname, graph, graphname);
    }

    public void toDotFile(String methodname, DirectedGraph graph, String graphname) {
        this.nodecount = 0;
        Hashtable nodeindex = new Hashtable(graph.size());
        DotGraph canvas = new DotGraph(methodname);
        if (!this.onepage) {
            canvas.setPageSize(8.5, 11.0);
        }
        if (this.isBrief) {
            canvas.setNodeShape("circle");
        } else {
            canvas.setNodeShape("box");
        }
        canvas.setGraphLabel(graphname);
        Iterator nodesIt = graph.iterator();
        while (nodesIt.hasNext()) {
            Object node = nodesIt.next();
            for (Object succ : graph.getSuccsOf(node)) {
                canvas.drawEdge(this.makeNodeName(this.getNodeOrder(nodeindex, node)), this.makeNodeName(this.getNodeOrder(nodeindex, succ)));
            }
        }
        for (Object head : graph.getHeads()) {
            DotGraphNode headNode = canvas.getNode(this.makeNodeName(this.getNodeOrder(nodeindex, head)));
            headNode.setStyle("filled");
        }
        for (Object tail : graph.getTails()) {
            DotGraphNode tailNode = canvas.getNode(this.makeNodeName(this.getNodeOrder(nodeindex, tail)));
            tailNode.setStyle("filled");
        }
        if (!this.isBrief) {
            for (Object node : nodeindex.keySet()) {
                String nodename = this.makeNodeName(this.getNodeOrder(nodeindex, node));
                DotGraphNode dotnode = canvas.getNode(nodename);
                dotnode.setLabel(node.toString());
            }
        }
        canvas.plot();
    }

    private int getNodeOrder(Hashtable nodeindex, Object node) {
        Integer index = (Integer)nodeindex.get(node);
        if (index == null) {
            index = new Integer(this.nodecount++);
            nodeindex.put(node, index);
        }
        return index;
    }

    private String makeNodeName(int index) {
        return "N" + index;
    }
}

