/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

class SimpleLiveLocalsAnalysis
extends BackwardFlowAnalysis {
    FlowSet emptySet;
    Map unitToGenerateSet;
    Map unitToPreserveSet;

    SimpleLiveLocalsAnalysis(UnitGraph g) {
        super(g);
        Unit s;
        if (Options.v().time()) {
            Timers.v().liveSetupTimer.start();
        }
        Chain locals = g.getBody().getLocals();
        CollectionFlowUniverse localUniverse = new CollectionFlowUniverse(locals);
        this.emptySet = new ArrayPackedSet(localUniverse);
        this.unitToPreserveSet = new HashMap(g.size() * 2 + 1, 0.7f);
        Iterator unitIt = g.iterator();
        while (unitIt.hasNext()) {
            s = (Unit)unitIt.next();
            BoundedFlowSet killSet = (BoundedFlowSet)this.emptySet.clone();
            for (ValueBox box : s.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                killSet.add(box.getValue(), killSet);
            }
            killSet.complement(killSet);
            this.unitToPreserveSet.put(s, killSet);
        }
        this.unitToGenerateSet = new HashMap(g.size() * 2 + 1, 0.7f);
        unitIt = g.iterator();
        while (unitIt.hasNext()) {
            s = (Unit)unitIt.next();
            FlowSet genSet = (FlowSet)this.emptySet.clone();
            for (ValueBox box : s.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                genSet.add(box.getValue(), genSet);
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        if (Options.v().time()) {
            Timers.v().liveSetupTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.start();
        }
        this.doAnalysis();
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.end();
        }
    }

    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.intersection((FlowSet)this.unitToPreserveSet.get(unit), out);
        out.union((FlowSet)this.unitToGenerateSet.get(unit), out);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.union(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

