/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import soot.toolkits.scalar.FlowUniverse;

class ObjectIntMapper {
    private Vector intToObjects;
    private int counter;
    private Map objectToInts;

    public ObjectIntMapper() {
        this.intToObjects = new Vector();
        this.objectToInts = new HashMap();
        this.counter = 0;
    }

    public ObjectIntMapper(FlowUniverse flowUniverse) {
        this(flowUniverse.iterator(), flowUniverse.size());
    }

    public ObjectIntMapper(Collection collection) {
        this(collection.iterator(), collection.size());
    }

    private ObjectIntMapper(Iterator it, int initSize) {
        this.intToObjects = new Vector(initSize);
        this.objectToInts = new HashMap(initSize);
        this.counter = 0;
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    private int add(Object o) {
        this.objectToInts.put(o, new Integer(this.counter));
        this.intToObjects.add(o);
        return this.counter++;
    }

    public int getInt(Object o) {
        Integer i = (Integer)this.objectToInts.get(o);
        if (i != null) {
            return i;
        }
        return this.add(o);
    }

    public Object getObject(int i) {
        return this.intToObjects.get(i);
    }

    public boolean contains(Object o) {
        return this.objectToInts.containsKey(o);
    }

    public int size() {
        return this.counter;
    }
}

