/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.IntPair;
import soot.util.Chain;

class LocalDefsFlowAnalysis
extends ForwardFlowAnalysis {
    FlowSet emptySet;
    Map localToPreserveSet;
    Map localToIntPair;

    public LocalDefsFlowAnalysis(UnitGraph g) {
        super(g);
        if (Options.v().time()) {
            Timers.v().defsSetupTimer.start();
        }
        HashMap localToDefList = new HashMap(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        for (Local l : g.getBody().getLocals()) {
            localToDefList.put(l, new ArrayList());
        }
        Iterator it = g.iterator();
        while (it.hasNext()) {
            Unit s = (Unit)it.next();
            List defBoxes = s.getDefBoxes();
            if (defBoxes.isEmpty()) continue;
            if (defBoxes.size() != 1) {
                throw new RuntimeException("invalid number of def boxes");
            }
            if (!(((ValueBox)defBoxes.get(0)).getValue() instanceof Local)) continue;
            Local defLocal = (Local)((ValueBox)defBoxes.get(0)).getValue();
            List l = (List)localToDefList.get(defLocal);
            if (l == null) {
                throw new RuntimeException("local " + defLocal + " is used but not declared!");
            }
            l.add(s);
        }
        it = g.getBody().getLocals().iterator();
        LinkedList defList = new LinkedList();
        int startPos = 0;
        this.localToIntPair = new HashMap(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        while (it.hasNext()) {
            Local l = (Local)it.next();
            Iterator jt = ((List)localToDefList.get(l)).iterator();
            int endPos = startPos - 1;
            while (jt.hasNext()) {
                defList.add(jt.next());
                ++endPos;
            }
            this.localToIntPair.put(l, new IntPair(startPos, endPos));
            startPos = endPos + 1;
        }
        Object[] defs = defList.toArray();
        ArrayFlowUniverse defUniverse = new ArrayFlowUniverse(defs);
        this.emptySet = new ArrayPackedSet(defUniverse);
        HashMap<Local, Object> localToKillSet = new HashMap<Local, Object>(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        this.localToPreserveSet = new HashMap(g.getBody().getLocalCount() * 2 + 1, 0.7f);
        Chain locals = g.getBody().getLocals();
        for (Local l : locals) {
            localToKillSet.put(l, this.emptySet.clone());
        }
        for (int i = 0; i < defs.length; ++i) {
            Unit s = (Unit)defs[i];
            List defBoxes = s.getDefBoxes();
            if (defBoxes.size() != 1) {
                throw new RuntimeException("SimpleLocalDefs: invalid number of def boxes");
            }
            if (!(((ValueBox)defBoxes.get(0)).getValue() instanceof Local)) continue;
            Local defLocal = (Local)((ValueBox)defBoxes.get(0)).getValue();
            BoundedFlowSet killSet = (BoundedFlowSet)localToKillSet.get(defLocal);
            killSet.add(s, killSet);
        }
        for (Local l : locals) {
            BoundedFlowSet killSet = (BoundedFlowSet)localToKillSet.get(l);
            killSet.complement(killSet);
            this.localToPreserveSet.put(l, killSet);
        }
        if (Options.v().time()) {
            Timers.v().defsSetupTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().defsAnalysisTimer.start();
        }
        this.doAnalysis();
        if (Options.v().time()) {
            Timers.v().defsAnalysisTimer.end();
        }
    }

    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void flowThrough(Object inValue, Object d, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        Unit unit = (Unit)d;
        List defBoxes = unit.getDefBoxes();
        if (defBoxes.isEmpty()) {
            in.copy(out);
            return;
        }
        if (defBoxes.size() != 1) {
            throw new RuntimeException("SimpleLocalDefs: invalid number of def boxes");
        }
        Value value = ((ValueBox)defBoxes.get(0)).getValue();
        if (value instanceof Local) {
            Local defLocal = (Local)value;
            in.intersection((FlowSet)this.localToPreserveSet.get(defLocal), out);
            out.add(unit, out);
            return;
        }
        in.copy(out);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.union(inSet2, outSet);
    }
}

