/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Timers;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowAnalysis;

public abstract class ForwardFlowAnalysis
extends FlowAnalysis {
    public ForwardFlowAnalysis(DirectedGraph graph) {
        super(graph);
    }

    protected boolean isForward() {
        return true;
    }

    protected void doAnalysis() {
        LinkedList changedUnits = new LinkedList();
        HashSet changedUnitsSet = new HashSet();
        int numNodes = this.graph.size();
        int numComputations = 0;
        Iterator it = this.graph.iterator();
        while (it.hasNext()) {
            Object s = it.next();
            changedUnits.addLast(s);
            changedUnitsSet.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        for (Object s : this.graph.getHeads()) {
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        Object previousAfterFlow = this.newInitialFlow();
        while (!changedUnits.isEmpty()) {
            Object s = changedUnits.removeFirst();
            changedUnitsSet.remove(s);
            this.copy(this.unitToAfterFlow.get(s), previousAfterFlow);
            List preds = this.graph.getPredsOf(s);
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            if (preds.size() == 1) {
                this.copy(this.unitToAfterFlow.get(preds.get(0)), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator predIt = preds.iterator();
                this.copy(this.unitToAfterFlow.get(predIt.next()), beforeFlow);
                while (predIt.hasNext()) {
                    Object otherBranchFlow = this.unitToAfterFlow.get(predIt.next());
                    this.merge(beforeFlow, otherBranchFlow, beforeFlow);
                }
            }
            Object afterFlow = this.unitToAfterFlow.get(s);
            this.flowThrough(beforeFlow, s, afterFlow);
            ++numComputations;
            if (afterFlow.equals(previousAfterFlow)) continue;
            for (Object succ : this.graph.getSuccsOf(s)) {
                if (changedUnitsSet.contains(succ)) continue;
                changedUnits.addLast(succ);
                changedUnitsSet.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

