/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.AbstractFlowAnalysis;

public abstract class BranchedFlowAnalysis
extends AbstractFlowAnalysis {
    protected Map unitToAfterFallFlow;
    protected Map unitToAfterBranchFlow;

    public BranchedFlowAnalysis(UnitGraph graph) {
        super(graph);
        this.unitToAfterFallFlow = new HashMap(graph.size() * 2 + 1, 0.7f);
        this.unitToAfterBranchFlow = new HashMap(graph.size() * 2 + 1, 0.7f);
    }

    protected abstract void flowThrough(Object var1, Unit var2, List var3, List var4);

    public Object getFallFlowAfter(Unit s) {
        List fl = (List)this.unitToAfterFallFlow.get(s);
        if (fl.isEmpty()) {
            return this.newInitialFlow();
        }
        return fl.get(0);
    }

    public List getBranchFlowAfter(Unit s) {
        return (List)this.unitToAfterBranchFlow.get(s);
    }

    public Object getFlowBefore(Unit s) {
        return this.unitToBeforeFlow.get(s);
    }
}

