/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowAnalysis;

public abstract class BackwardFlowAnalysis
extends FlowAnalysis {
    public BackwardFlowAnalysis(DirectedGraph graph) {
        super(graph);
    }

    protected boolean isForward() {
        return false;
    }

    protected void doAnalysis() {
        LinkedList changedUnits = new LinkedList();
        HashSet changedUnitsSet = new HashSet();
        Iterator it = this.graph.iterator();
        while (it.hasNext()) {
            Object s = it.next();
            changedUnits.addFirst(s);
            changedUnitsSet.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        for (Object s : this.graph.getTails()) {
            this.unitToAfterFlow.put(s, this.entryInitialFlow());
        }
        Object previousBeforeFlow = this.newInitialFlow();
        while (!changedUnits.isEmpty()) {
            Object s = changedUnits.removeFirst();
            changedUnitsSet.remove(s);
            this.copy(this.unitToBeforeFlow.get(s), previousBeforeFlow);
            List succs = this.graph.getSuccsOf(s);
            Object afterFlow = this.unitToAfterFlow.get(s);
            if (succs.size() == 1) {
                this.copy(this.unitToBeforeFlow.get(succs.get(0)), afterFlow);
            } else if (succs.size() != 0) {
                Iterator succIt = succs.iterator();
                this.copy(this.unitToBeforeFlow.get(succIt.next()), afterFlow);
                while (succIt.hasNext()) {
                    Object otherBranchFlow = this.unitToBeforeFlow.get(succIt.next());
                    this.merge(afterFlow, otherBranchFlow, afterFlow);
                }
            }
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            this.flowThrough(afterFlow, s, beforeFlow);
            if (beforeFlow.equals(previousBeforeFlow)) continue;
            for (Object pred : this.graph.getPredsOf(s)) {
                if (changedUnitsSet.contains(pred)) continue;
                changedUnitsSet.add(pred);
                changedUnits.addLast(pred);
            }
        }
    }
}

