/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.List;
import soot.toolkits.scalar.AbstractBoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.FlowUniverse;
import soot.toolkits.scalar.ObjectIntMapper;

public class ArrayPackedSet
extends AbstractBoundedFlowSet {
    ObjectIntMapper map;
    int[] bits;

    public ArrayPackedSet(FlowUniverse universe) {
        this(new ObjectIntMapper(universe));
    }

    ArrayPackedSet(ObjectIntMapper map) {
        this(map, new int[map.size() / 32 + (map.size() % 32 != 0 ? 1 : 0)]);
    }

    ArrayPackedSet(ObjectIntMapper map, int[] bits) {
        this.map = map;
        this.bits = (int[])bits.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof ArrayPackedSet && ((ArrayPackedSet)flowSet).map == this.map;
    }

    public Object clone() {
        return new ArrayPackedSet(this.map, this.bits);
    }

    public Object emptySet() {
        return new ArrayPackedSet(this.map);
    }

    public int size() {
        int count = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            int word = this.bits[i];
            for (int j = 0; j < 32; ++j) {
                if ((word & 1 << j) == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public List toList(int low, int high) {
        int j;
        ArrayList<Object> elements = new ArrayList<Object>();
        int startWord = low / 32;
        int startBit = low % 32;
        int endWord = high / 32;
        int endBit = high % 32;
        if (low > high) {
            return elements;
        }
        int word = this.bits[startWord];
        int offset = startWord * 32;
        int lastBit = startWord != endWord ? 32 : endBit + 1;
        for (j = startBit; j < lastBit; ++j) {
            if ((word & 1 << j) == 0) continue;
            elements.add(this.map.getObject(offset + j));
        }
        if (startWord != endWord && startWord + 1 != endWord) {
            for (int i = startWord + 1; i < endWord; ++i) {
                int word2 = this.bits[i];
                int offset2 = i * 32;
                for (j = 0; j < 32; ++j) {
                    if ((word2 & 1 << j) == 0) continue;
                    elements.add(this.map.getObject(offset2 + j));
                }
            }
        }
        if (startWord != endWord) {
            word = this.bits[endWord];
            offset = endWord * 32;
            lastBit = endBit + 1;
            for (j = 0; j < lastBit; ++j) {
                if ((word & 1 << j) == 0) continue;
                elements.add(this.map.getObject(offset + j));
            }
        }
        return elements;
    }

    public List toList() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < this.bits.length; ++i) {
            int word = this.bits[i];
            int offset = i * 32;
            for (int j = 0; j < 32; ++j) {
                if ((word & 1 << j) == 0) continue;
                elements.add(this.map.getObject(offset + j));
            }
        }
        return elements;
    }

    public void add(Object obj) {
        int bitNum = this.map.getInt(obj);
        int n = bitNum / 32;
        this.bits[n] = this.bits[n] | 1 << bitNum % 32;
    }

    public void complement(FlowSet destFlow) {
        if (this.sameType(destFlow)) {
            int lastValidBitCount;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = ~this.bits[i];
            }
            if (this.bits.length >= 1 && (lastValidBitCount = this.map.size() % 32) != 0) {
                int n = this.bits.length - 1;
                dest.bits[n] = dest.bits[n] & ~(-1 << lastValidBitCount);
            }
        } else {
            super.complement(destFlow);
        }
    }

    public void remove(Object obj) {
        int bitNum = this.map.getInt(obj);
        int n = bitNum / 32;
        this.bits[n] = this.bits[n] & ~(1 << bitNum % 32);
    }

    public void union(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (!(other instanceof ArrayPackedSet) || this.bits.length != other.bits.length) {
                throw new RuntimeException("Incompatible other set for union");
            }
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i] | other.bits[i];
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    public void difference(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (!(other instanceof ArrayPackedSet) || this.bits.length != other.bits.length) {
                throw new RuntimeException("Incompatible other set for union");
            }
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i] & ~other.bits[i];
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    public void intersection(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (!(other instanceof ArrayPackedSet) || this.bits.length != other.bits.length) {
                throw new RuntimeException("Incompatible other set for union");
            }
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i] & other.bits[i];
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    public boolean contains(Object obj) {
        if (!this.map.contains(obj)) {
            return false;
        }
        int bitNum = this.map.getInt(obj);
        return (this.bits[bitNum / 32] & 1 << bitNum % 32) != 0;
    }

    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            for (int i = 0; i < this.bits.length; ++i) {
                if (this.bits[i] == other.bits[i]) continue;
                return false;
            }
            return true;
        }
        return super.equals(otherFlow);
    }

    public void copy(FlowSet destFlow) {
        if (this.sameType(destFlow)) {
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            for (int i = 0; i < this.bits.length; ++i) {
                dest.bits[i] = this.bits[i];
            }
        } else {
            super.copy(destFlow);
        }
    }
}

