/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.SootMethod;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.util.Chain;

public class UnitGraph
implements DirectedGraph {
    List heads;
    List tails;
    protected Map unitToSuccs;
    protected Map unitToPreds;
    protected SootMethod method;
    protected Body body;
    protected Chain unitChain;

    public UnitGraph(Body unitBody, boolean addExceptionEdges) {
        this(unitBody, addExceptionEdges, false);
    }

    public UnitGraph(Body unitBody, boolean addExceptionEdges, boolean dontAddEdgeFromStmtBeforeAreaOfProtectionToCatchBlock) {
        List succs;
        Unit nextUnit;
        this.body = unitBody;
        this.unitChain = this.body.getUnits();
        int size = this.unitChain.size();
        this.method = this.getBody().getMethod();
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.method.getName() + "]     Constructing UnitGraph...");
        }
        if (Options.v().time()) {
            Timers.v().graphTimer.start();
        }
        this.unitToSuccs = new HashMap(size * 2 + 1, 0.7f);
        Iterator unitIt = this.unitChain.iterator();
        Unit unit = nextUnit = unitIt.hasNext() ? (Unit)unitIt.next() : null;
        while (nextUnit != null) {
            Unit currentUnit = nextUnit;
            nextUnit = unitIt.hasNext() ? (Unit)unitIt.next() : null;
            ArrayList<Unit> successors = new ArrayList<Unit>();
            if (currentUnit.fallsThrough() && nextUnit != null) {
                successors.add(nextUnit);
            }
            if (currentUnit.branches()) {
                Iterator targetIt = currentUnit.getUnitBoxes().iterator();
                while (targetIt.hasNext()) {
                    successors.add(((UnitBox)targetIt.next()).getUnit());
                }
            }
            this.unitToSuccs.put(currentUnit, successors);
        }
        if (addExceptionEdges) {
            HashMap<Unit, LinkedList<Unit>> beginToHandler = new HashMap<Unit, LinkedList<Unit>>();
            for (Trap trap : this.body.getTraps()) {
                Unit beginUnit = trap.getBeginUnit();
                Unit handlerUnit = trap.getHandlerUnit();
                Unit endUnit = trap.getEndUnit();
                Iterator unitIt2 = this.unitChain.iterator(beginUnit);
                LinkedList<Unit> handlersStartingHere = (LinkedList<Unit>)beginToHandler.get(beginUnit);
                if (handlersStartingHere == null) {
                    handlersStartingHere = new LinkedList<Unit>();
                    beginToHandler.put(beginUnit, handlersStartingHere);
                }
                handlersStartingHere.add(handlerUnit);
                Unit u = (Unit)unitIt2.next();
                while (u != endUnit) {
                    ((List)this.unitToSuccs.get(u)).add(handlerUnit);
                    u = (Unit)unitIt2.next();
                }
            }
            if (!dontAddEdgeFromStmtBeforeAreaOfProtectionToCatchBlock) {
                for (Unit u : this.body.getUnits()) {
                    succs = (List)this.unitToSuccs.get(u);
                    ArrayList succsClone = new ArrayList();
                    succsClone.addAll(succs);
                    for (Unit succ : succsClone) {
                        List handlers = (List)beginToHandler.get(succ);
                        if (handlers == null) continue;
                        for (Unit handler : handlers) {
                            if (succs.contains(handler)) continue;
                            succs.add(handler);
                        }
                    }
                }
            }
        }
        for (Unit s : this.body.getUnits()) {
            this.unitToSuccs.put(s, Collections.unmodifiableList((List)this.unitToSuccs.get(s)));
        }
        this.unitToPreds = new HashMap(size * 2 + 1, 0.7f);
        unitIt = this.body.getUnits().iterator();
        while (unitIt.hasNext()) {
            this.unitToPreds.put(unitIt.next(), new ArrayList());
        }
        for (Unit s : this.body.getUnits()) {
            for (Unit successor : (List)this.unitToSuccs.get(s)) {
                List predList = (List)this.unitToPreds.get(successor);
                try {
                    predList.add(s);
                }
                catch (NullPointerException e) {
                    G.v().out.println(s + "successor: " + successor);
                    throw e;
                }
            }
        }
        for (Unit s : this.body.getUnits()) {
            List predList = (List)this.unitToPreds.get(s);
            this.unitToPreds.put(s, Collections.unmodifiableList(predList));
        }
        ArrayList<Unit> tailList = new ArrayList<Unit>();
        ArrayList<Unit> headList = new ArrayList<Unit>();
        for (Unit s : this.body.getUnits()) {
            List preds;
            succs = (List)this.unitToSuccs.get(s);
            if (succs.size() == 0) {
                tailList.add(s);
            }
            if ((preds = (List)this.unitToPreds.get(s)).size() != 0) continue;
            headList.add(s);
        }
        this.tails = Collections.unmodifiableList(tailList);
        this.heads = Collections.unmodifiableList(headList);
        if (Options.v().time()) {
            Timers.v().graphTimer.end();
        }
    }

    public Body getBody() {
        return this.body;
    }

    public List getExtendedBasicBlockPathBetween(Unit from, Unit to) {
        UnitGraph g = this;
        if (g.getPredsOf(to).size() > 1) {
            return null;
        }
        LinkedList<Unit> pathStack = new LinkedList<Unit>();
        LinkedList<Integer> pathStackIndex = new LinkedList<Integer>();
        pathStack.add(from);
        pathStackIndex.add(new Integer(0));
        int psiMax = g.getSuccsOf((Unit)pathStack.get(0)).size();
        int level = 0;
        while ((Integer)pathStackIndex.get(0) != psiMax) {
            List succs;
            int p = (Integer)pathStackIndex.get(level);
            if (p >= (succs = g.getSuccsOf((Unit)pathStack.get(level))).size()) {
                pathStack.remove(level);
                pathStackIndex.remove(level);
                int q = (Integer)pathStackIndex.get(--level);
                pathStackIndex.set(level, new Integer(q + 1));
                continue;
            }
            Unit betweenUnit = (Unit)succs.get(p);
            if (betweenUnit == to) {
                pathStack.add(to);
                return pathStack;
            }
            if (g.getPredsOf(betweenUnit).size() > 1) {
                pathStackIndex.set(level, new Integer(p + 1));
                continue;
            }
            ++level;
            pathStackIndex.add(new Integer(0));
            pathStack.add(betweenUnit);
        }
        return null;
    }

    public List getHeads() {
        return this.heads;
    }

    public List getTails() {
        return this.tails;
    }

    public List getPredsOf(Object s) {
        if (!this.unitToPreds.containsKey(s)) {
            throw new RuntimeException("Invalid stmt" + s);
        }
        return (List)this.unitToPreds.get(s);
    }

    public List getSuccsOf(Object s) {
        if (!this.unitToSuccs.containsKey(s)) {
            throw new RuntimeException("Invalid stmt" + s);
        }
        return (List)this.unitToSuccs.get(s);
    }

    public int size() {
        return this.unitChain.size();
    }

    public Iterator iterator() {
        return this.unitChain.iterator();
    }

    public String toString() {
        Iterator it = this.unitChain.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            Unit u = (Unit)it.next();
            ArrayList l = new ArrayList();
            l.addAll(this.getPredsOf(u));
            buf.append("// preds " + l + "\n");
            buf.append(u.toString() + '\n');
            l = new ArrayList();
            l.addAll(this.getSuccsOf(u));
            buf.append("// succs " + l + "\n");
        }
        return buf.toString();
    }
}

