/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.Stmt;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DirectedGraph;
import soot.util.Chain;

public class BlockGraph
implements DirectedGraph {
    Body mBody;
    Chain mUnits;
    List mBlocks;
    List mHeads = new ArrayList();
    List mTails = new ArrayList();
    public static final int COMPLETE = 0;
    public static final int BRIEF = 1;
    public static final int ZONED = 2;
    public static final int ARRAYREF = 99;

    public BlockGraph(Body aBody, int type) {
        Block block;
        Unit nextUnit;
        this.mBody = aBody;
        this.mUnits = aBody.getUnits();
        HashMap<Unit, ArrayList<Trap>> trapBeginUnits = new HashMap<Unit, ArrayList<Trap>>();
        ArrayList trapsInScope = null;
        Chain traps = null;
        ArrayList<Unit> handlerList = new ArrayList<Unit>();
        HashMap<Unit, List<Object>> leaders = new HashMap<Unit, List<Object>>();
        traps = this.mBody.getTraps();
        trapsInScope = new ArrayList(traps.size());
        for (Trap someTrap : traps) {
            Unit firstUnit = someTrap.getBeginUnit();
            handlerList.add(someTrap.getHandlerUnit());
            ArrayList<Trap> trapList = (ArrayList<Trap>)trapBeginUnits.get(firstUnit);
            if (trapList == null) {
                trapList = new ArrayList<Trap>(4);
                trapList.add(someTrap);
                trapBeginUnits.put(firstUnit, trapList);
            } else {
                trapList.add(someTrap);
            }
            if (type != 2) continue;
            ArrayList<Object> predList = new ArrayList<Object>();
            predList.add(this.mUnits.getPredOf(someTrap.getBeginUnit()));
            leaders.put(someTrap.getBeginUnit(), predList);
            predList = new ArrayList();
            predList.add(this.mUnits.getPredOf(someTrap.getEndUnit()));
            leaders.put(someTrap.getEndUnit(), predList);
        }
        Iterator it = this.mUnits.iterator();
        Unit unit = nextUnit = it.hasNext() ? (Unit)it.next() : null;
        while (nextUnit != null) {
            Iterator iter;
            List trapsBeginningHere;
            Unit currentUnit = nextUnit;
            Unit unit2 = nextUnit = it.hasNext() ? (Unit)it.next() : null;
            if (type == 0 && (trapsBeginningHere = (List)trapBeginUnits.get(currentUnit)) != null && (iter = trapsBeginningHere.iterator()) != null) {
                while (iter.hasNext()) {
                    trapsInScope.add(iter.next());
                }
            }
            if (currentUnit.branches()) {
                List<Unit> predecessors;
                Iterator targetIt = currentUnit.getUnitBoxes().iterator();
                if (!targetIt.hasNext()) {
                    throw new RuntimeException("error: branching instruction has no target.");
                }
                while (targetIt.hasNext()) {
                    List<Unit> predecessors2;
                    Unit target = ((UnitBox)targetIt.next()).getUnit();
                    if (!leaders.containsKey(target)) {
                        predecessors2 = new LinkedList<Unit>();
                        predecessors2.add(currentUnit);
                        Unit targetPred = (Unit)this.mUnits.getPredOf(target);
                        if (targetPred.fallsThrough()) {
                            predecessors2.add(targetPred);
                        }
                        leaders.put(target, predecessors2);
                        continue;
                    }
                    predecessors2 = (List)leaders.get(target);
                    predecessors2.add(currentUnit);
                }
                if (!leaders.containsKey(nextUnit)) {
                    predecessors = new LinkedList();
                    leaders.put(nextUnit, predecessors);
                }
                if (currentUnit.fallsThrough()) {
                    predecessors = (List)leaders.get(nextUnit);
                    predecessors.add(currentUnit);
                }
            } else if (!(currentUnit.branches() || currentUnit.fallsThrough() || nextUnit == null || leaders.containsKey(nextUnit))) {
                leaders.put(nextUnit, new LinkedList());
            }
            if (type == 99) {
                Stmt stmt = (Stmt)nextUnit;
                if (nextUnit != null && stmt.containsArrayRef() && !leaders.containsKey(nextUnit)) {
                    LinkedList<Unit> predicessors = new LinkedList<Unit>();
                    predicessors.add(currentUnit);
                    leaders.put(nextUnit, predicessors);
                }
            }
            if (type != 0) continue;
            if (trapsInScope.size() != 0) {
                for (Trap someTrap : trapsInScope) {
                    Unit targetPred;
                    List<Unit> predecessors;
                    Unit target = someTrap.getHandlerUnit();
                    if (!leaders.containsKey(target)) {
                        predecessors = new LinkedList<Unit>();
                        predecessors.add(currentUnit);
                        targetPred = (Unit)this.mUnits.getPredOf(target);
                        if (targetPred.fallsThrough()) {
                            predecessors.add(targetPred);
                        }
                        leaders.put(target, predecessors);
                    } else {
                        predecessors = (List)leaders.get(target);
                        predecessors.add(currentUnit);
                    }
                    if (nextUnit != null) {
                        if (!leaders.containsKey(nextUnit)) {
                            predecessors = new LinkedList();
                            leaders.put(nextUnit, predecessors);
                        }
                        if (currentUnit.fallsThrough() && !(predecessors = (List)leaders.get(nextUnit)).contains(currentUnit)) {
                            predecessors.add(currentUnit);
                        }
                    }
                    if (!leaders.containsKey(currentUnit)) {
                        predecessors = new LinkedList();
                        leaders.put(currentUnit, predecessors);
                    }
                    predecessors = (List)leaders.get(currentUnit);
                    targetPred = (Unit)this.mUnits.getPredOf(currentUnit);
                    if (targetPred == null || !targetPred.fallsThrough() || predecessors.contains(targetPred)) continue;
                    predecessors.add(targetPred);
                }
            }
            Iterator trapScopeIt = trapsInScope.iterator();
            while (trapScopeIt.hasNext()) {
                Trap trap = (Trap)trapScopeIt.next();
                if (trap.getEndUnit() != nextUnit) continue;
                trapScopeIt.remove();
            }
        }
        ArrayList<Block> basicBlockList = new ArrayList<Block>(16);
        int indexInMethod = 0;
        Iterator it2 = this.mUnits.iterator();
        Unit blockHead = (Unit)this.mUnits.getFirst();
        int blockLength = 1;
        boolean isHandler = false;
        if (it2.hasNext()) {
            it2.next();
        }
        while (it2.hasNext()) {
            Unit unit3 = (Unit)it2.next();
            ++blockLength;
            if (!leaders.containsKey(unit3)) continue;
            Unit blockTail = (Unit)this.mUnits.getPredOf(unit3);
            block = new Block(blockHead, blockTail, this.mBody, indexInMethod++, blockLength - 1, this);
            block.setPreds((List)leaders.get(blockHead));
            basicBlockList.add(block);
            blockHead = unit3;
            blockLength = 1;
        }
        block = new Block(blockHead, (Unit)this.mUnits.getLast(), this.mBody, indexInMethod++, blockLength, this);
        block.setPreds((List)leaders.get(blockHead));
        basicBlockList.add(block);
        it2 = basicBlockList.iterator();
        while (it2.hasNext()) {
            ArrayList<Block> newl = new ArrayList<Block>();
            Block bb = (Block)it2.next();
            List l = bb.getPreds();
            if (l != null) {
                for (Unit u : l) {
                    for (Block b2 : basicBlockList) {
                        if (u != b2.getTail() || newl.contains(b2)) continue;
                        newl.add(b2);
                    }
                }
                bb.setPreds(newl);
                continue;
            }
            bb.setPreds(new ArrayList());
        }
        for (Block b : basicBlockList) {
            ArrayList<Block> successorList = new ArrayList<Block>(4);
            for (Block maybeASuccessor : basicBlockList) {
                List predecessors = maybeASuccessor.getPreds();
                if (predecessors == null || !predecessors.contains(b)) continue;
                successorList.add(maybeASuccessor);
            }
            b.setSuccs(successorList);
        }
        this.mBlocks = basicBlockList;
        for (Block b : this.mBlocks) {
            if (b.getHead() == this.mUnits.getFirst() || type != 0 && handlerList.contains(b.getHead())) {
                this.mHeads.add(b);
            } else {
                List preds = b.getPreds();
                if (preds == null) {
                    this.mHeads.add(b);
                } else if (preds.isEmpty()) {
                    this.mHeads.add(b);
                }
            }
            List succs = b.getSuccs();
            if (succs == null) {
                this.mTails.add(b);
                continue;
            }
            if (!succs.isEmpty()) continue;
            this.mTails.add(b);
        }
        if (type == 0) {
            for (Block block2 : this.mBlocks) {
                List preds;
                Unit head = block2.getHead();
                if (!handlerList.contains(head) || (preds = block2.getPreds()) == null || preds.isEmpty()) continue;
                ArrayList predsClone = new ArrayList();
                predsClone.addAll(preds);
                for (Block trapped : predsClone) {
                    List newPreds = trapped.getPreds();
                    if (newPreds == null) continue;
                    for (Block newPred : newPreds) {
                        if (preds.contains(newPred)) continue;
                        preds.add(0, newPred);
                        List newPredSuccs = newPred.getSuccs();
                        newPredSuccs.add(newPredSuccs.size(), block2);
                    }
                }
            }
        }
    }

    public Body getBody() {
        return this.mBody;
    }

    public List getBlocks() {
        return this.mBlocks;
    }

    public String toString() {
        Iterator it = this.mBlocks.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            Block someBlock = (Block)it.next();
            buf.append(someBlock.toString() + '\n');
        }
        return buf.toString();
    }

    public List getHeads() {
        return this.mHeads;
    }

    public List getTails() {
        return this.mTails;
    }

    public List getPredsOf(Object s) {
        Block b = (Block)s;
        return b.getPreds();
    }

    public List getSuccsOf(Object s) {
        Block b = (Block)s;
        return b.getSuccs();
    }

    public int size() {
        return this.mBlocks.size();
    }

    public Iterator iterator() {
        return this.mBlocks.iterator();
    }
}

