/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import soot.G;
import soot.Unit;
import soot.UnitBox;
import soot.baf.Baf;
import soot.options.Options;
import soot.tagkit.AttributeValueException;
import soot.tagkit.Base64;
import soot.tagkit.JasminAttribute;
import soot.tagkit.Tag;

public class CodeAttribute
extends JasminAttribute {
    protected List mUnits;
    protected List mTags;
    private byte[] value;
    private String name = "CodeAtribute";

    public CodeAttribute() {
    }

    public CodeAttribute(String name) {
        this.name = name;
    }

    public CodeAttribute(String name, List units, List tags) {
        this.name = name;
        this.mUnits = units;
        this.mTags = tags;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(byte[] v) {
        this.value = v;
    }

    public byte[] getValue() throws AttributeValueException {
        if (this.value == null) {
            throw new AttributeValueException();
        }
        return this.value;
    }

    public String getJasminValue(Map instToLabel) {
        StringBuffer buf = new StringBuffer();
        if (this.mTags.size() != this.mUnits.size()) {
            throw new RuntimeException("Sizes must match!");
        }
        Iterator tagIt = this.mTags.iterator();
        Iterator unitIt = this.mUnits.iterator();
        while (tagIt.hasNext()) {
            Object unit = unitIt.next();
            Object tag = tagIt.next();
            buf.append("%" + instToLabel.get(unit) + "%" + new String(Base64.encode(((Tag)tag).getValue())));
        }
        return buf.toString();
    }

    public List getUnitBoxes() {
        ArrayList<UnitBox> unitBoxes = new ArrayList<UnitBox>(this.mUnits.size());
        Iterator it = this.mUnits.iterator();
        while (it.hasNext()) {
            unitBoxes.add(Baf.v().newInstBox((Unit)it.next()));
        }
        return unitBoxes;
    }

    public byte[] decode(String attr, Hashtable labelToPc) {
        if (Options.v().verbose()) {
            G.v().out.println("[] JasminAttribute decode...");
        }
        LinkedList<byte[]> attributeHunks = new LinkedList<byte[]>();
        int attributeSize = 0;
        StringTokenizer st = new StringTokenizer(attr, "%");
        boolean isLabel = false;
        if (attr.startsWith("%")) {
            isLabel = true;
        }
        int tablesize = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (isLabel) {
                Integer pc = (Integer)labelToPc.get(token);
                if (pc == null) {
                    throw new RuntimeException("PC is null, the token is " + token);
                }
                int pcvalue = pc;
                if (pcvalue > 65535) {
                    throw new RuntimeException("PC great than 65535, the token is " + token + " : " + pcvalue);
                }
                byte[] pcArray = new byte[2];
                pcArray[1] = (byte)(pcvalue & 0xFF);
                pcArray[0] = (byte)(pcvalue >> 8 & 0xFF);
                attributeHunks.add(pcArray);
                attributeSize += 2;
                ++tablesize;
            } else {
                byte[] hunk = Base64.decode(token.toCharArray());
                attributeSize += hunk.length;
                attributeHunks.add(hunk);
            }
            isLabel = !isLabel;
        }
        byte[] attributeValue = new byte[attributeSize += 2];
        attributeValue[0] = (byte)(tablesize >> 8 & 0xFF);
        attributeValue[1] = (byte)(tablesize & 0xFF);
        int index = 2;
        for (byte[] hunk : attributeHunks) {
            for (int i = 0; i < hunk.length; ++i) {
                attributeValue[index++] = hunk[i];
            }
        }
        if (index != attributeSize) {
            throw new RuntimeException("Index does not euqal to attrubute size :" + index + " -- " + attributeSize);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[] Jasmin.decode finished...");
        }
        return attributeValue;
    }
}

