/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.shimple.ShimpleBody;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class ShimpleLocalUses
implements LocalUses {
    protected Map localToUses;

    public ShimpleLocalUses(ShimpleBody sb) {
        if (!sb.isSSA()) {
            throw new RuntimeException("ShimpleBody is not in proper SSA form as required by ShimpleLocalUses.  You may need to rebuild it or use SimpleLocalUses instead.");
        }
        this.localToUses = new HashMap();
        for (Local local : sb.getLocals()) {
            this.localToUses.put(local, new ArrayList());
        }
        for (Unit unit : sb.getUnits()) {
            for (ValueBox box : unit.getUseBoxes()) {
                Value value = box.getValue();
                if (!(value instanceof Local)) continue;
                List useList = (List)this.localToUses.get(value);
                useList.add(new UnitValueBoxPair(unit, box));
            }
        }
    }

    public List getUsesOf(Local local) {
        List uses = (List)this.localToUses.get(local);
        if (uses == null) {
            return Collections.EMPTY_LIST;
        }
        return uses;
    }

    public List getUsesOf(Unit unit) {
        List defBoxes = unit.getDefBoxes();
        switch (defBoxes.size()) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                Value local = ((ValueBox)defBoxes.get(0)).getValue();
                if (!(local instanceof Local)) {
                    return Collections.EMPTY_LIST;
                }
                return this.getUsesOf((Local)local);
            }
        }
        G.v().out.println("Warning: Unit has multiple definition boxes?");
        ArrayList usesList = new ArrayList();
        Iterator defBoxesIt = defBoxes.iterator();
        while (defBoxesIt.hasNext()) {
            Value def = ((ValueBox)defBoxesIt.next()).getValue();
            if (!(def instanceof Local)) continue;
            usesList.addAll(this.getUsesOf((Local)def));
        }
        return usesList;
    }
}

