/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.TableSwitchStmt;
import soot.shimple.toolkits.scalar.SEvaluator;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;
import soot.toolkits.scalar.Pair;
import soot.util.Chain;

class SCPFAnalysis
extends ForwardBranchedFlowAnalysis {
    protected FlowSet emptySet = new ArraySparseSet();
    protected Map localToConstant;
    protected Map stmtToReplacement = new HashMap();
    protected List deadStmts = new ArrayList();

    public Map getResults() {
        return this.localToConstant;
    }

    public List getDeadStmts() {
        return this.deadStmts;
    }

    public Map getStmtsToReplace() {
        return this.stmtToReplacement;
    }

    public SCPFAnalysis(UnitGraph graph) {
        super(graph);
        Chain locals = graph.getBody().getLocals();
        Iterator localsIt = locals.iterator();
        this.localToConstant = new HashMap(graph.size() * 2 + 1, 0.7f);
        while (localsIt.hasNext()) {
            Local local = (Local)localsIt.next();
            this.localToConstant.put(local, SEvaluator.TopConstant.v());
        }
        this.doAnalysis();
    }

    protected boolean treatTrapHandlersAsEntries() {
        return true;
    }

    protected Object entryInitialFlow() {
        FlowSet entrySet = (FlowSet)this.emptySet.emptySet();
        entrySet.add(SEvaluator.TopConstant.v());
        return entrySet;
    }

    protected Object newInitialFlow() {
        return this.emptySet.emptySet();
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet fin1 = (FlowSet)in1;
        FlowSet fin2 = (FlowSet)in2;
        FlowSet fout = (FlowSet)out;
        fin1.union(fin2, fout);
    }

    protected void copy(Object source, Object dest) {
        FlowSet fource = (FlowSet)source;
        FlowSet fest = (FlowSet)dest;
        fource.copy(fest);
    }

    protected void flowThrough(Object in, Unit s, List fallOut, List branchOuts) {
        Constant keyC;
        Value keyV;
        GotoStmt gotoStmt;
        FlowSet fin = (FlowSet)((FlowSet)in).clone();
        if (fin.isEmpty()) {
            return;
        }
        Pair pair = this.processDefinitionStmt(s);
        if (pair != null) {
            fin.add(pair);
        }
        if (!s.branches() && s.fallsThrough()) {
            for (FlowSet fallSet : fallOut) {
                fallSet.union(fin);
            }
            return;
        }
        boolean conservative = true;
        boolean fall = false;
        boolean branch = false;
        FlowSet oneBranch = null;
        if (s instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)s;
            Value cond = ifStmt.getCondition();
            Constant constant = SEvaluator.getFuzzyConstantValueOf(cond, this.localToConstant);
            if (constant instanceof SEvaluator.BottomConstant) {
                this.deadStmts.remove(ifStmt);
                this.stmtToReplacement.remove(ifStmt);
            } else {
                if (constant instanceof SEvaluator.TopConstant) {
                    return;
                }
                conservative = false;
                IntConstant trueC = IntConstant.v(1);
                IntConstant falseC = IntConstant.v(0);
                if (constant.equals(trueC)) {
                    branch = true;
                    gotoStmt = Jimple.v().newGotoStmt(ifStmt.getTargetBox());
                    this.stmtToReplacement.put(ifStmt, gotoStmt);
                }
                if (constant.equals(falseC)) {
                    fall = true;
                    this.deadStmts.add(ifStmt);
                }
            }
        }
        if (s instanceof TableSwitchStmt) {
            TableSwitchStmt table = (TableSwitchStmt)s;
            keyV = table.getKey();
            keyC = SEvaluator.getFuzzyConstantValueOf(keyV, this.localToConstant);
            if (keyC instanceof SEvaluator.BottomConstant) {
                this.stmtToReplacement.remove(table);
            } else {
                if (keyC instanceof SEvaluator.TopConstant) {
                    return;
                }
                if (keyC instanceof IntConstant) {
                    conservative = false;
                    int key = ((IntConstant)keyC).value;
                    int low = table.getLowIndex();
                    int high = table.getHighIndex();
                    int index = key - low;
                    UnitBox branchBox = null;
                    branchBox = index < 0 || index > high ? table.getDefaultTargetBox() : table.getTargetBox(index);
                    GotoStmt gotoStmt2 = Jimple.v().newGotoStmt(branchBox);
                    this.stmtToReplacement.put(table, gotoStmt2);
                    List unitBoxes = table.getUnitBoxes();
                    int setIndex = unitBoxes.indexOf(branchBox);
                    oneBranch = (FlowSet)branchOuts.get(setIndex);
                }
            }
        }
        if (s instanceof LookupSwitchStmt) {
            LookupSwitchStmt lookup = (LookupSwitchStmt)s;
            keyV = lookup.getKey();
            keyC = SEvaluator.getFuzzyConstantValueOf(keyV, this.localToConstant);
            if (keyC instanceof SEvaluator.BottomConstant) {
                this.stmtToReplacement.remove(lookup);
            } else {
                if (keyC instanceof SEvaluator.TopConstant) {
                    return;
                }
                if (keyC instanceof IntConstant) {
                    conservative = false;
                    int index = lookup.getLookupValues().indexOf(keyC);
                    UnitBox branchBox = null;
                    branchBox = index == -1 ? lookup.getDefaultTargetBox() : lookup.getTargetBox(index);
                    gotoStmt = Jimple.v().newGotoStmt(branchBox);
                    this.stmtToReplacement.put(lookup, gotoStmt);
                    List unitBoxes = lookup.getUnitBoxes();
                    int setIndex = unitBoxes.indexOf(branchBox);
                    oneBranch = (FlowSet)branchOuts.get(setIndex);
                }
            }
        }
        if (conservative) {
            fall = s.fallsThrough();
            branch = s.branches();
        }
        if (fall) {
            for (FlowSet fallSet : fallOut) {
                fallSet.union(fin);
            }
        }
        if (branch) {
            for (FlowSet branchSet : branchOuts) {
                branchSet.union(fin);
            }
        }
        if (oneBranch != null) {
            oneBranch.union(fin);
        }
    }

    protected Pair processDefinitionStmt(Unit u) {
        if (!(u instanceof DefinitionStmt)) {
            return null;
        }
        DefinitionStmt dStmt = (DefinitionStmt)u;
        Value value = dStmt.getLeftOp();
        if (!(value instanceof Local)) {
            return null;
        }
        Local local = (Local)value;
        Value rightOp = dStmt.getRightOp();
        Constant constant = SEvaluator.getFuzzyConstantValueOf(rightOp, this.localToConstant);
        if (!this.merge(local, constant)) {
            return null;
        }
        return new Pair(u, this.localToConstant.get(local));
    }

    protected boolean merge(Local local, Constant constant) {
        Constant current = (Constant)this.localToConstant.get(local);
        if (current instanceof SEvaluator.BottomConstant) {
            return false;
        }
        if (current instanceof SEvaluator.TopConstant) {
            this.localToConstant.put(local, constant);
            return true;
        }
        if (current.equals(constant)) {
            return false;
        }
        this.localToConstant.put(local, SEvaluator.BottomConstant.v());
        return true;
    }
}

