/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.ValueBox;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.Chain;

class GuaranteedDefsAnalysis
extends ForwardFlowAnalysis {
    FlowSet emptySet;
    Map unitToGenerateSet;
    Map unitToPreserveSet;

    GuaranteedDefsAnalysis(UnitGraph graph) {
        super(graph);
        Unit s;
        Chain locals = graph.getBody().getLocals();
        CollectionFlowUniverse localUniverse = new CollectionFlowUniverse(locals);
        this.emptySet = new ArrayPackedSet(localUniverse);
        this.unitToPreserveSet = new HashMap(graph.size() * 2 + 1, 0.7f);
        Iterator unitIt = graph.iterator();
        while (unitIt.hasNext()) {
            s = (Unit)unitIt.next();
            BoundedFlowSet killSet = (BoundedFlowSet)this.emptySet.clone();
            for (ValueBox box : s.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                killSet.add(box.getValue(), killSet);
            }
            killSet.complement(killSet);
            this.unitToPreserveSet.put(s, killSet);
        }
        this.unitToGenerateSet = new HashMap(graph.size() * 2 + 1, 0.7f);
        unitIt = graph.iterator();
        while (unitIt.hasNext()) {
            s = (Unit)unitIt.next();
            FlowSet genSet = (FlowSet)this.emptySet.clone();
            for (ValueBox box : s.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                genSet.add(box.getValue(), genSet);
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.complement(initSet);
        return initSet;
    }

    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.intersection((FlowSet)this.unitToPreserveSet.get(unit), out);
        out.union((FlowSet)this.unitToGenerateSet.get(unit), out);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

