/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Unit;
import soot.options.Options;
import soot.shimple.internal.analysis.GuaranteedDefsAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.FlowSet;

public class GuaranteedDefs {
    Map unitToGuaranteedDefs;

    public GuaranteedDefs(UnitGraph graph) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing GuaranteedDefs...");
        }
        GuaranteedDefsAnalysis analysis = new GuaranteedDefsAnalysis(graph);
        this.unitToGuaranteedDefs = new HashMap(graph.size() * 2 + 1, 0.7f);
        Iterator unitIt = graph.iterator();
        while (unitIt.hasNext()) {
            Unit s = (Unit)unitIt.next();
            FlowSet set = (FlowSet)analysis.getFlowBefore(s);
            this.unitToGuaranteedDefs.put(s, Collections.unmodifiableList(set.toList()));
        }
    }

    public List getGuaranteedDefs(Unit s) {
        return (List)this.unitToGuaranteedDefs.get(s);
    }
}

