/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.options.Options;
import soot.shimple.internal.analysis.DominatorsAnalysis;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.scalar.FlowSet;

public class DominatorsFinder {
    Map blockToDominators;

    public DominatorsFinder(BlockGraph graph) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing Dominators...");
        }
        DominatorsAnalysis analysis = new DominatorsAnalysis(graph);
        this.blockToDominators = new HashMap(graph.size() * 2 + 1, 0.7f);
        for (Block s : graph.getBlocks()) {
            FlowSet set = (FlowSet)analysis.getFlowAfter(s);
            this.blockToDominators.put(s, set);
        }
    }

    public List getDominators(Block s) {
        return ((FlowSet)this.blockToDominators.get(s)).toList();
    }

    public boolean isDominatedBy(Block s, Block dominator) {
        return ((FlowSet)this.blockToDominators.get(s)).contains(dominator);
    }

    public boolean isDominatedByAll(Block s, Collection dominators) {
        return ((FlowSet)this.blockToDominators.get(s)).toList().containsAll(dominators);
    }
}

