/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

class DominatorsAnalysis
extends ForwardFlowAnalysis {
    FlowSet emptySet;
    Map blockToGenerateSet;

    DominatorsAnalysis(BlockGraph graph) {
        super(graph);
        List blocks = graph.getBlocks();
        CollectionFlowUniverse blockUniverse = new CollectionFlowUniverse(blocks);
        this.emptySet = new ArrayPackedSet(blockUniverse);
        this.blockToGenerateSet = new HashMap(graph.size() * 2 + 1, 0.7f);
        for (Block s : graph.getBlocks()) {
            FlowSet genSet = (FlowSet)this.emptySet.clone();
            genSet.add(s, genSet);
            this.blockToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.complement(initSet);
        return initSet;
    }

    protected Object entryInitialFlow() {
        List heads = this.graph.getHeads();
        if (heads.size() != 1) {
            throw new RuntimeException("Assertion failed:  Only one head expected.");
        }
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.add((Block)heads.get(0));
        return initSet;
    }

    protected void flowThrough(Object inValue, Object block, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.union((FlowSet)this.blockToGenerateSet.get(block), out);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

