/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.G;
import soot.options.Options;
import soot.shimple.internal.analysis.DominanceFrontier;
import soot.shimple.internal.analysis.DominatorNode;
import soot.shimple.internal.analysis.DominatorsFinder;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.DirectedGraph;

public class DominatorTree
implements DirectedGraph {
    private BlockGraph graph;
    private DominatorsFinder dominators;
    private ArrayList heads;
    private ArrayList tails;
    private HashMap blockToNode;

    public DominatorTree(BlockGraph graph) {
        this(graph, false);
    }

    public DominatorTree(BlockGraph graph, boolean constructFrontier) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing DominatorTree...");
        }
        this.graph = graph;
        this.dominators = new DominatorsFinder(graph);
        this.heads = new ArrayList();
        this.tails = new ArrayList();
        this.blockToNode = new HashMap();
        this.buildTree();
        if (constructFrontier) {
            this.buildFrontier();
        }
    }

    public BlockGraph getGraph() {
        return this.graph;
    }

    public List getHeads() {
        return (List)this.heads.clone();
    }

    public List getTails() {
        return (List)this.tails.clone();
    }

    public List getPredsOf(Object node) {
        ArrayList<DominatorNode> parent = new ArrayList<DominatorNode>();
        parent.add(((DominatorNode)node).getParent());
        return parent;
    }

    public List getSuccsOf(Object node) {
        return ((DominatorNode)node).getChildren();
    }

    public Iterator iterator() {
        return this.blockToNode.values().iterator();
    }

    public int size() {
        return this.blockToNode.size();
    }

    public void buildTree() {
        Iterator blocksIt = this.graph.iterator();
        while (blocksIt.hasNext()) {
            Block block = (Block)blocksIt.next();
            DominatorNode node = this.fetchNode(block);
            DominatorNode parent = this.fetchParent(block);
            if (parent == null) {
                this.heads.add(node);
                continue;
            }
            parent.addChild(node);
            node.setParent(parent);
        }
        for (DominatorNode node : this.blockToNode.values()) {
            node.setDominatorTree(this);
            if (!node.isTail()) continue;
            this.tails.add(node);
        }
    }

    public DominatorNode fetchNode(Block block) {
        DominatorNode node;
        if (this.blockToNode.containsKey(block)) {
            node = (DominatorNode)this.blockToNode.get(block);
        } else {
            node = new DominatorNode(block);
            this.blockToNode.put(block, node);
        }
        return node;
    }

    protected DominatorNode fetchParent(Block block) {
        if (this.graph.getHeads().contains(block)) {
            return null;
        }
        List dominatorsList = this.dominators.getDominators(block);
        Iterator dominatorsIt = dominatorsList.iterator();
        DominatorNode immediateDominator = null;
        while (immediateDominator == null && dominatorsIt.hasNext()) {
            Block dominator = (Block)dominatorsIt.next();
            if (dominator == block) continue;
            List dominatorsListClone = this.dominators.getDominators(block);
            dominatorsListClone.remove(block);
            if (!this.dominators.isDominatedByAll(dominator, dominatorsListClone)) continue;
            immediateDominator = this.fetchNode(dominator);
        }
        if (immediateDominator == null) {
            throw new RuntimeException("Assertion failed.");
        }
        return immediateDominator;
    }

    public void buildFrontier() {
        new DominanceFrontier(this.heads);
    }
}

