/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.Iterator;
import java.util.List;
import soot.shimple.internal.analysis.DominatorNode;

public class DominanceFrontier {
    public DominanceFrontier() {
    }

    public DominanceFrontier(List dominatorNodeHeads) {
        Iterator headsIt = dominatorNodeHeads.iterator();
        while (headsIt.hasNext()) {
            this.bottomUpDispatch((DominatorNode)headsIt.next());
        }
    }

    public void bottomUpDispatch(DominatorNode node) {
        if (node.isFrontierKnown()) {
            return;
        }
        for (DominatorNode child : node.getChildren()) {
            if (!child.isFrontierKnown()) {
                this.bottomUpDispatch(child);
                continue;
            }
            this.processNode(child);
        }
        this.processNode(node);
    }

    public void processNode(DominatorNode node) {
        for (DominatorNode succ : node.getSuccs()) {
            if (succ.isImmediateDominator(node)) continue;
            node.addToDominanceFrontier(succ);
        }
        for (DominatorNode child : node.getChildren()) {
            for (DominatorNode childFront : child.getDominanceFrontier()) {
                if (childFront.isImmediateDominator(node)) continue;
                node.addToDominanceFrontier(childFront);
            }
        }
        node.setFrontierKnown();
    }
}

