/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.IdentityUnit;
import soot.Local;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.Jimple;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.options.ShimpleOptions;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.internal.OneHeadBlockGraph;
import soot.shimple.internal.analysis.DominatorNode;
import soot.shimple.internal.analysis.DominatorTree;
import soot.shimple.internal.analysis.GuaranteedDefs;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.CompleteBlockGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.toolkits.scalar.ValueUnitPair;
import soot.util.HashMultiMap;

public class ShimpleBodyBuilder {
    protected ShimpleBody body;
    protected DominatorTree dt;
    protected BlockGraph cfg;
    protected List origLocals;
    protected GuaranteedDefs gd;
    protected Set newPhiNodes;
    protected Map newLocals;
    protected Map newLocalsToOldLocal;
    protected int[] assignmentCounters;
    protected Stack[] namingStacks;
    protected Map unitToBlock;

    public ShimpleBodyBuilder(ShimpleBody body) {
        this.body = body;
        this.initialize();
        this.transform();
    }

    public void initialize() {
        this.cfg = new CompleteBlockGraph(this.body);
        OneHeadBlockGraph.convert(this.cfg);
        this.dt = new DominatorTree(this.cfg, true);
        this.gd = new GuaranteedDefs(new CompleteUnitGraph(this.body));
        this.origLocals = new ArrayList(this.body.getLocals());
        this.newPhiNodes = new HashSet();
    }

    public void transform() {
        this.insertTrivialPhiNodes();
        this.renameLocals();
        this.trimExceptionalPhiNodes();
        ShimpleBodyBuilder.makeUniqueLocalNames(this.body);
    }

    public void insertTrivialPhiNodes() {
        HashMap localsToDefPoints = new HashMap();
        for (Local local : this.origLocals) {
            ArrayList<Block> blockList = new ArrayList<Block>();
            Iterator blocksIt = this.cfg.iterator();
            block1: while (blocksIt.hasNext()) {
                Block block = (Block)blocksIt.next();
                Iterator defBoxesIt = ShimpleBodyBuilder.getDefBoxesFromBlock(block).iterator();
                while (defBoxesIt.hasNext()) {
                    Value def = ((ValueBox)defBoxesIt.next()).getValue();
                    if (!def.equals(local)) continue;
                    blockList.add(block);
                    continue block1;
                }
            }
            localsToDefPoints.put(local, blockList);
        }
        int[] workFlags = new int[this.cfg.size()];
        int[] hasAlreadyFlags = new int[this.cfg.size()];
        int iterCount = 0;
        Stack<Block> workList = new Stack<Block>();
        for (Local local : localsToDefPoints.keySet()) {
            ++iterCount;
            for (Block block : (List)localsToDefPoints.get(local)) {
                workFlags[block.getIndexInMethod()] = iterCount;
                workList.push(block);
            }
            while (!workList.empty()) {
                Block block = (Block)workList.pop();
                DominatorNode node = this.dt.fetchNode(block);
                Iterator frontierNodes = node.getDominanceFrontier().iterator();
                while (frontierNodes.hasNext()) {
                    Block frontierBlock = ((DominatorNode)frontierNodes.next()).getBlock();
                    int fBIndex = frontierBlock.getIndexInMethod();
                    if (hasAlreadyFlags[fBIndex] >= iterCount) continue;
                    if (this.isLocalDefinedOnEntry(local, frontierBlock)) {
                        this.prependTrivialPhiNode(local, frontierBlock);
                    }
                    hasAlreadyFlags[fBIndex] = iterCount;
                    if (workFlags[fBIndex] >= iterCount) continue;
                    workFlags[fBIndex] = iterCount;
                    workList.push(frontierBlock);
                }
            }
        }
    }

    public void prependTrivialPhiNode(Local local, Block frontierBlock) {
        List preds = frontierBlock.getPreds();
        AssignStmt trivialPhi = Jimple.v().newAssignStmt(local, Shimple.v().newPhiExpr(local, preds));
        Unit blockHead = frontierBlock.getHead();
        if (blockHead instanceof IdentityUnit) {
            frontierBlock.insertAfter(trivialPhi, frontierBlock.getHead());
        } else {
            frontierBlock.insertBefore(trivialPhi, frontierBlock.getHead());
        }
        this.newPhiNodes.add(trivialPhi);
    }

    protected boolean isLocalDefinedOnEntry(Local local, Block block) {
        Iterator unitsIt = block.iterator();
        if (!unitsIt.hasNext()) {
            throw new RuntimeException("Empty block in CFG?");
        }
        Unit unit = (Unit)unitsIt.next();
        List definedLocals = this.gd.getGuaranteedDefs(unit);
        while (definedLocals == null) {
            if (!unitsIt.hasNext()) {
                throw new RuntimeException("Empty block in CFG?");
            }
            unit = (Unit)unitsIt.next();
            definedLocals = this.gd.getGuaranteedDefs(unit);
        }
        return definedLocals.contains(local);
    }

    public void renameLocals() {
        this.newLocals = new HashMap();
        this.newLocalsToOldLocal = new HashMap();
        this.assignmentCounters = new int[this.origLocals.size()];
        this.namingStacks = new Stack[this.origLocals.size()];
        for (int i = 0; i < this.namingStacks.length; ++i) {
            this.namingStacks[i] = new Stack();
        }
        List heads = this.cfg.getHeads();
        if (heads.size() == 0) {
            return;
        }
        if (heads.size() != 1) {
            throw new RuntimeException("Assertion failed:  Only one head expected.");
        }
        Block entry = (Block)heads.get(0);
        this.renameLocalsSearch(entry);
    }

    public void renameLocalsSearch(Block block) {
        ArrayList<Local> lhsLocals = new ArrayList<Local>();
        Iterator unitsIt = block.iterator();
        while (unitsIt.hasNext()) {
            DefinitionStmt defStmt;
            Value lhsValue;
            int localIndex;
            Unit unit = (Unit)unitsIt.next();
            ArrayList useBoxes = new ArrayList();
            if (!this.newPhiNodes.contains(unit)) {
                useBoxes.addAll(unit.getUseBoxes());
            }
            for (ValueBox useBox : useBoxes) {
                Value use = useBox.getValue();
                localIndex = this.indexOfLocal(use);
                if (localIndex == -1) continue;
                Local localUse = (Local)use;
                if (this.namingStacks[localIndex].empty()) continue;
                Integer subscript = (Integer)this.namingStacks[localIndex].peek();
                Local renamedLocal = this.fetchNewLocal(localUse, subscript);
                useBox.setValue(renamedLocal);
            }
            if (!(unit instanceof DefinitionStmt) || !this.origLocals.contains(lhsValue = (defStmt = (DefinitionStmt)unit).getLeftOp())) continue;
            ValueBox lhsLocalBox = defStmt.getLeftOpBox();
            Local lhsLocal = (Local)lhsValue;
            lhsLocals.add(lhsLocal);
            localIndex = this.indexOfLocal(lhsLocal);
            if (localIndex == -1) {
                throw new RuntimeException("Assertion failed.");
            }
            Integer subscript = new Integer(this.assignmentCounters[localIndex]);
            Local newLhsLocal = this.fetchNewLocal(lhsLocal, subscript);
            lhsLocalBox.setValue(newLhsLocal);
            this.namingStacks[localIndex].push(subscript);
            int n = localIndex;
            this.assignmentCounters[n] = this.assignmentCounters[n] + 1;
        }
        for (Block succ : block.getSuccs()) {
            Iterator unitsIt2 = succ.iterator();
            while (unitsIt2.hasNext()) {
                Unit unit = (Unit)unitsIt2.next();
                if (!this.newPhiNodes.contains(unit)) continue;
                PhiExpr phiExpr = Shimple.getPhiExpr(unit);
                int argIndex = phiExpr.getArgIndex(block);
                if (argIndex == -1) {
                    throw new RuntimeException("Assertion failed.");
                }
                ValueUnitPair phiArgBox = phiExpr.getArgBox(argIndex);
                Local phiArg = (Local)phiArgBox.getValue();
                int localIndex = this.indexOfLocal(phiArg);
                if (localIndex == -1) {
                    throw new RuntimeException("Assertion failed.");
                }
                if (this.namingStacks[localIndex].empty()) continue;
                Integer subscript = (Integer)this.namingStacks[localIndex].peek();
                Local newPhiArg = this.fetchNewLocal(phiArg, subscript);
                phiArgBox.setValue(newPhiArg);
            }
        }
        DominatorNode node = this.dt.fetchNode(block);
        for (DominatorNode childNode : node.getChildren()) {
            this.renameLocalsSearch(childNode.getBlock());
        }
        for (Local lhsLocal : lhsLocals) {
            int lhsLocalIndex = this.indexOfLocal(lhsLocal);
            if (lhsLocalIndex == -1) {
                throw new RuntimeException("Assertion failed.");
            }
            this.namingStacks[lhsLocalIndex].pop();
        }
    }

    protected Local fetchNewLocal(Local local, Integer subscript) {
        Local oldLocal = local;
        if (!this.origLocals.contains(local)) {
            oldLocal = (Local)this.newLocalsToOldLocal.get(local);
        }
        if (subscript == 0) {
            return oldLocal;
        }
        String name = oldLocal.getName() + "_" + subscript;
        Local newLocal = (Local)this.newLocals.get(name);
        if (newLocal == null) {
            newLocal = new JimpleLocal(name, oldLocal.getType());
            this.newLocals.put(name, newLocal);
            this.newLocalsToOldLocal.put(newLocal, oldLocal);
            this.body.getLocals().add(newLocal);
        }
        return newLocal;
    }

    protected int indexOfLocal(Value local) {
        int localIndex = this.origLocals.indexOf(local);
        if (localIndex == -1) {
            Local oldLocal = (Local)this.newLocalsToOldLocal.get(local);
            localIndex = this.origLocals.indexOf(oldLocal);
        }
        return localIndex;
    }

    public void trimExceptionalPhiNodes() {
        HashSet<Unit> handlerUnits = new HashSet<Unit>();
        for (Trap trap : this.body.getTraps()) {
            handlerUnits.add(trap.getHandlerUnit());
        }
        Iterator blocksIt = this.cfg.iterator();
        while (blocksIt.hasNext()) {
            Block block = (Block)blocksIt.next();
            if (!handlerUnits.contains(block.getHead())) continue;
            Iterator unitsIt = block.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = (Unit)unitsIt.next();
                if (!this.newPhiNodes.contains(unit)) continue;
                PhiExpr phi = Shimple.getPhiExpr(unit);
                this.trimPhiNode(phi);
            }
        }
    }

    public void trimPhiNode(PhiExpr phiExpr) {
        HashMultiMap valueToPairs = new HashMultiMap();
        for (ValueUnitPair argPair : phiExpr.getArgs()) {
            Value value = argPair.getValue();
            valueToPairs.put(value, argPair);
        }
        block1: for (Value value : valueToPairs.keySet()) {
            Set pairsSet = valueToPairs.get(value);
            ArrayList champs = new ArrayList(pairsSet);
            ArrayList challengers = new ArrayList(pairsSet);
            ValueUnitPair champ = (ValueUnitPair)champs.remove(0);
            Unit champU = champ.getUnit();
            boolean retry = true;
            while (retry) {
                retry = false;
                for (int i = 0; i < challengers.size(); ++i) {
                    ValueUnitPair challenger = (ValueUnitPair)challengers.get(i);
                    if (challenger.equals(champ)) continue;
                    Unit challengerU = challenger.getUnit();
                    if (this.dominates(champU, challengerU)) {
                        phiExpr.removeArg(challenger);
                        continue;
                    }
                    if (this.dominates(challengerU, champU)) {
                        phiExpr.removeArg(champ);
                        champ = challenger;
                        champU = champ.getUnit();
                        champs.remove(champ);
                        continue;
                    }
                    retry = true;
                }
                if (!retry) continue;
                if (champs.size() == 0) continue block1;
                champ = (ValueUnitPair)champs.remove(0);
                champU = champ.getUnit();
            }
        }
    }

    public boolean dominates(Unit champ, Unit challenger) {
        Block challengerBlock;
        Block champBlock;
        if (champ == null || challenger == null) {
            throw new RuntimeException("Assertion failed.");
        }
        if (champ.equals(challenger)) {
            return true;
        }
        if (this.unitToBlock == null) {
            this.unitToBlock = ShimpleBodyBuilder.getUnitToBlockMap(this.cfg);
        }
        if ((champBlock = (Block)this.unitToBlock.get(champ)).equals(challengerBlock = (Block)this.unitToBlock.get(challenger))) {
            Iterator unitsIt = champBlock.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = (Unit)unitsIt.next();
                if (unit.equals(champ)) {
                    return true;
                }
                if (!unit.equals(challenger)) continue;
                return false;
            }
            throw new RuntimeException("Assertion failed.");
        }
        DominatorNode champNode = this.dt.fetchNode(champBlock);
        DominatorNode challengerNode = this.dt.fetchNode(challengerBlock);
        return champNode.dominates(challengerNode);
    }

    public static void eliminatePhiNodes(ShimpleBody body) {
        block10: {
            block9: {
                int phiElimOpt;
                block8: {
                    block7: {
                        ShimpleOptions options = body.getOptions();
                        phiElimOpt = options.phi_elim_opt();
                        if (phiElimOpt == 2) break block7;
                        if (phiElimOpt != 4) break block8;
                    }
                    Aggregator.v().transform(body);
                    DeadAssignmentEliminator.v().transform(body);
                    UnconditionalBranchFolder.v().transform(body);
                    UnusedLocalEliminator.v().transform(body);
                }
                if (ShimpleBodyBuilder.doEliminatePhiNodes(body)) {
                    ShimpleBodyBuilder.makeUniqueLocalNames(body);
                }
                if (phiElimOpt == 3) break block9;
                if (phiElimOpt != 4) break block10;
            }
            Aggregator.v().transform(body);
            DeadAssignmentEliminator.v().transform(body);
            UnreachableCodeEliminator.v().transform(body);
            UnconditionalBranchFolder.v().transform(body);
            UnusedLocalEliminator.v().transform(body);
        }
    }

    public static boolean doEliminatePhiNodes(ShimpleBody body) {
        boolean addedNewLocals = false;
        ArrayList<Unit> phiNodes = new ArrayList<Unit>();
        ArrayList<AssignStmt> equivStmts = new ArrayList<AssignStmt>();
        ArrayList<ValueUnitPair> predBoxes = new ArrayList<ValueUnitPair>();
        PatchingChain units = body.getUnits();
        for (Unit unit : units) {
            PhiExpr phi = Shimple.getPhiExpr(unit);
            if (phi == null) continue;
            Local lhsLocal = Shimple.getLhsLocal(unit);
            for (int i = 0; i < phi.getArgCount(); ++i) {
                Value phiValue = phi.getValue(i);
                AssignStmt convertedPhi = Jimple.v().newAssignStmt(lhsLocal, phiValue);
                equivStmts.add(convertedPhi);
                predBoxes.add(phi.getArgBox(i));
            }
            phiNodes.add(unit);
        }
        if (equivStmts.size() != predBoxes.size()) {
            throw new RuntimeException("Assertion failed.");
        }
        for (int i = 0; i < equivStmts.size(); ++i) {
            AssignStmt stmt = (AssignStmt)equivStmts.get(i);
            Unit pred = ((UnitBox)predBoxes.get(i)).getUnit();
            if (pred == null) {
                throw new RuntimeException("Assertion failed.");
            }
            if (pred.branches()) {
                boolean needPriming = false;
                Local lhsLocal = (Local)stmt.getLeftOp();
                Local savedLocal = Jimple.v().newLocal(lhsLocal.getName() + "_", lhsLocal.getType());
                for (ValueBox useBox : pred.getUseBoxes()) {
                    if (!lhsLocal.equals(useBox.getValue())) continue;
                    needPriming = true;
                    addedNewLocals = true;
                    useBox.setValue(savedLocal);
                }
                if (needPriming) {
                    body.getLocals().add(savedLocal);
                    AssignStmt copyStmt = Jimple.v().newAssignStmt(savedLocal, lhsLocal);
                    units.insertBefore(copyStmt, (Object)pred);
                }
                units.insertBefore(stmt, (Object)pred);
                continue;
            }
            units.insertAfter(stmt, (Object)pred);
        }
        for (Unit removeMe : phiNodes) {
            units.remove(removeMe);
            removeMe.clearUnitBoxes();
        }
        return addedNewLocals;
    }

    public static void makeUniqueLocalNames(ShimpleBody body) {
        if (body.getOptions().standard_local_names()) {
            LocalNameStandardizer.v().transform(body);
            return;
        }
        HashSet<String> localNames = new HashSet<String>();
        for (Local local : body.getLocals()) {
            String localName = local.getName();
            if (localNames.contains(localName)) {
                String uniqueName = ShimpleBodyBuilder.makeUniqueLocalName(localName, localNames);
                local.setName(uniqueName);
                localNames.add(uniqueName);
                continue;
            }
            localNames.add(localName);
        }
    }

    public static String makeUniqueLocalName(String dupName, Set localNames) {
        int counter = 1;
        String newName = dupName;
        while (localNames.contains(newName)) {
            newName = dupName + "_" + counter++;
        }
        return newName;
    }

    public static List getDefBoxesFromBlock(Block block) {
        Iterator unitsIt = block.iterator();
        ArrayList defBoxesList = new ArrayList();
        while (unitsIt.hasNext()) {
            defBoxesList.addAll(((Unit)unitsIt.next()).getDefBoxes());
        }
        return defBoxesList;
    }

    public static List getUseBoxesFromBlock(Block block) {
        Iterator unitsIt = block.iterator();
        ArrayList useBoxesList = new ArrayList();
        while (unitsIt.hasNext()) {
            useBoxesList.addAll(((Unit)unitsIt.next()).getUseBoxes());
        }
        return useBoxesList;
    }

    public static Map getUnitToBlockMap(BlockGraph blocks) {
        HashMap<Unit, Block> unitToBlock = new HashMap<Unit, Block>();
        Iterator blocksIt = blocks.iterator();
        while (blocksIt.hasNext()) {
            Block block = (Block)blocksIt.next();
            Iterator unitsIt = block.iterator();
            while (unitsIt.hasNext()) {
                Unit unit = (Unit)unitsIt.next();
                unitToBlock.put(unit, block);
            }
        }
        return unitToBlock;
    }
}

