/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.PatchingChain;
import soot.TrapManager;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.internal.SUnitBox;
import soot.util.Chain;
import soot.util.HashMultiMap;

public class SPatchingChain
extends PatchingChain {
    Body body = null;
    boolean debug;
    protected Map boxToPhiNode = new HashMap();
    protected Map boxToNeedsPatching = new HashMap();

    public SPatchingChain(Body aBody, Chain aChain) {
        super(aChain);
        this.body = aBody;
        this.debug = Options.v().debug();
        if (aBody instanceof ShimpleBody) {
            this.debug |= ((ShimpleBody)aBody).getOptions().debug();
        }
    }

    public boolean add(Object o) {
        this.processPhiNode(o);
        return super.add(o);
    }

    public void swapWith(Object out, Object in) {
        this.processPhiNode(in);
        Shimple.redirectPointers((Unit)out, (Unit)in);
        super.insertBefore(in, out);
        super.remove(out);
    }

    /*
     * Unable to fully structure code
     */
    public void insertAfter(Object toInsert, Object point) {
        block9: {
            this.processPhiNode(toInsert);
            super.insertAfter(toInsert, point);
            unit = (Unit)point;
            if (!unit.fallsThrough()) break block9;
            if (unit.branches()) ** GOTO lbl-1000
            trappedUnits = Collections.EMPTY_SET;
            if (this.body != null) {
                trappedUnits = TrapManager.getTrappedUnitsOf(this.body);
            }
            if (!trappedUnits.contains(unit)) {
                Shimple.redirectPointers(unit, (Unit)toInsert);
            } else lbl-1000:
            // 2 sources

            {
                boxes = unit.getBoxesPointingToThis().toArray();
                for (i = 0; i < boxes.length; ++i) {
                    ub = (UnitBox)boxes[i];
                    if (ub.getUnit() != unit) {
                        throw new RuntimeException("Assertion failed.");
                    }
                    if (ub.isBranchTarget()) continue;
                    box = this.getSBox(ub);
                    needsPatching = (Boolean)this.boxToNeedsPatching.get(box);
                    if (needsPatching == null || box.isUnitChanged()) {
                        if (!this.boxToPhiNode.containsKey(box)) {
                            this.reprocessPhiNodes();
                            if (!this.boxToPhiNode.containsKey(box)) {
                                throw new RuntimeException("SPatchingChain has pointers from a Phi node that has never been seen.");
                            }
                        }
                        this.computeNeedsPatching();
                        needsPatching = (Boolean)this.boxToNeedsPatching.get(box);
                        if (needsPatching == null) {
                            if (!this.debug) continue;
                            G.v().out.println("Warning: Orphaned UnitBox to " + unit + "?  SPatchingChain will not move the pointer.");
                            continue;
                        }
                    }
                    if (!needsPatching.booleanValue()) continue;
                    box.setUnit((Unit)toInsert);
                    box.setUnitChanged(false);
                }
            }
        }
    }

    public void insertAfter(List toInsert, Object point) {
        this.processPhiNode(toInsert);
        super.insertAfter(toInsert, point);
    }

    public void insertBefore(List toInsert, Object point) {
        this.processPhiNode(toInsert);
        super.insertBefore(toInsert, point);
    }

    public void insertBefore(Object toInsert, Object point) {
        this.processPhiNode(toInsert);
        super.insertBefore(toInsert, point);
    }

    public void addFirst(Object u) {
        this.processPhiNode(u);
        super.addFirst(u);
    }

    public void addLast(Object u) {
        this.processPhiNode(u);
        super.addLast(u);
    }

    public boolean remove(Object obj) {
        if (this.contains(obj)) {
            Shimple.redirectToPreds(this.body, (Unit)obj);
        }
        return super.remove(obj);
    }

    protected void processPhiNode(Object o) {
        Unit phiNode = (Unit)o;
        PhiExpr phi = Shimple.getPhiExpr(phiNode);
        if (phi == null) {
            return;
        }
        if (this.boxToPhiNode.values().contains(phiNode)) {
            return;
        }
        for (UnitBox box : phi.getUnitBoxes()) {
            this.boxToPhiNode.put(box, phiNode);
        }
    }

    protected void reprocessPhiNodes() {
        HashSet phiNodes = new HashSet(this.boxToPhiNode.values());
        this.boxToPhiNode = new HashMap();
        this.boxToNeedsPatching = new HashMap();
        Iterator phiNodesIt = phiNodes.iterator();
        while (phiNodesIt.hasNext()) {
            this.processPhiNode(phiNodesIt.next());
        }
    }

    protected void computeNeedsPatching() {
        Set boxes = this.boxToPhiNode.keySet();
        if (boxes.isEmpty()) {
            return;
        }
        HashMultiMap trackedPhiToBoxes = new HashMultiMap();
        HashSet trackedBranchTargets = new HashSet();
        for (Unit u : this) {
            List boxesToTrack = u.getBoxesPointingToThis();
            if (boxesToTrack != null) {
                for (UnitBox boxToTrack : boxesToTrack) {
                    if (boxToTrack.isBranchTarget()) continue;
                    trackedPhiToBoxes.put(this.boxToPhiNode.get(boxToTrack), boxToTrack);
                }
            }
            if (u.fallsThrough() && u.branches()) {
                trackedBranchTargets.addAll(u.getUnitBoxes());
            }
            if (!u.fallsThrough() || trackedBranchTargets.contains(u)) {
                Iterator boxesIt = trackedPhiToBoxes.values().iterator();
                while (boxesIt.hasNext()) {
                    SUnitBox box = this.getSBox(boxesIt.next());
                    this.boxToNeedsPatching.put(box, Boolean.FALSE);
                    box.setUnitChanged(false);
                }
                trackedPhiToBoxes = new HashMultiMap();
                continue;
            }
            Set boxes2 = trackedPhiToBoxes.get(u);
            if (boxes2 == null) continue;
            Iterator boxesIt = boxes2.iterator();
            while (boxesIt.hasNext()) {
                SUnitBox box = this.getSBox(boxesIt.next());
                this.boxToNeedsPatching.put(box, Boolean.TRUE);
                box.setUnitChanged(false);
            }
            trackedPhiToBoxes.remove(u);
        }
        Iterator boxesIt = trackedPhiToBoxes.values().iterator();
        while (boxesIt.hasNext()) {
            SUnitBox box = this.getSBox(boxesIt.next());
            this.boxToNeedsPatching.put(box, Boolean.FALSE);
            box.setUnitChanged(false);
        }
    }

    protected SUnitBox getSBox(Object box) {
        if (!(box instanceof SUnitBox)) {
            throw new RuntimeException("Shimple box not an SUnitBox?");
        }
        return (SUnitBox)box;
    }

    public Iterator iterator() {
        return new SPatchingIterator(this.innerChain);
    }

    public Iterator iterator(Object u) {
        return new SPatchingIterator(this.innerChain, u);
    }

    public Iterator iterator(Object head, Object tail) {
        return new SPatchingIterator(this.innerChain, head, tail);
    }

    protected class SPatchingIterator
    extends PatchingChain.PatchingIterator {
        SPatchingIterator(Chain innerChain) {
            super(innerChain);
        }

        SPatchingIterator(Chain innerChain, Object u) {
            super(innerChain, u);
        }

        SPatchingIterator(Chain innerChain, Object head, Object tail) {
            super(innerChain, head, tail);
        }

        public void remove() {
            Unit victim = (Unit)this.lastObject;
            if (!this.state) {
                throw new IllegalStateException("remove called before first next() call");
            }
            Shimple.redirectToPreds(SPatchingChain.this.body, victim);
            Unit successor = (Unit)SPatchingChain.this.getSuccOf(victim);
            if (successor == null) {
                successor = (Unit)SPatchingChain.this.getPredOf(victim);
            }
            this.innerIterator.remove();
            victim.redirectJumpsToThisTo(successor);
        }
    }
}

