/*
 * Decompiled with CFR 0.152.
 */
package soot.relations;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import soot.G;
import soot.Singletons;
import soot.jbuddy.JBuddy;

public class JBuddyProfiler {
    Map stackTraceToTime = new HashMap();
    LinkedList stack = new LinkedList();

    public JBuddyProfiler(Singletons.Global g) {
    }

    public static JBuddyProfiler v() {
        return G.v().JBuddyProfiler();
    }

    public void start(String eventName, int bdd) {
        this.start(eventName, bdd, JBuddy.bdd_false());
    }

    public void start(String eventName, int bdd1, int bdd2) {
        Event e = new Event();
        e.bdd1 = bdd1;
        e.bdd2 = bdd2;
        e.startTime = new Date();
        this.stack.addLast(e);
    }

    public void finish(String eventName, int bdd) {
        Event e = (Event)this.stack.removeLast();
        String stackTrace = this.stackTrace();
        long time = new Date().getTime() - e.startTime.getTime();
        Info info = (Info)this.stackTraceToTime.get(stackTrace);
        if (info == null) {
            info = new Info(stackTrace);
            this.stackTraceToTime.put(stackTrace, info);
        }
        info.eventName = eventName;
        info.time += time;
    }

    public void printInfo() {
        ArrayList infos = new ArrayList(this.stackTraceToTime.values());
        Collections.sort(infos);
        for (Info info : infos) {
            G.v().out.println(info.toString());
        }
    }

    private String stackTrace() {
        Throwable t = new Throwable();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    class Info
    implements Comparable {
        String stackTrace;
        long time;
        String eventName;

        public Info(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public int compareTo(Object o) {
            Info other = (Info)o;
            if (this.time > other.time) {
                return 1;
            }
            if (this.time < other.time) {
                return -11;
            }
            return 0;
        }

        public String toString() {
            return "" + this.time + " " + this.eventName;
        }
    }

    class Event {
        int bdd1;
        int bdd2;
        Date startTime;

        Event() {
        }
    }
}

