/*
 * Decompiled with CFR 0.152.
 */
package soot.options;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.PackManager;
import soot.Singletons;
import soot.options.OptionsBase;

public class Options
extends OptionsBase {
    public static final int src_prec_c = 1;
    public static final int src_prec_class = 1;
    public static final int src_prec_J = 2;
    public static final int src_prec_jimple = 2;
    public static final int src_prec_java = 3;
    public static final int output_format_J = 1;
    public static final int output_format_jimple = 1;
    public static final int output_format_j = 2;
    public static final int output_format_jimp = 2;
    public static final int output_format_S = 3;
    public static final int output_format_shimple = 3;
    public static final int output_format_s = 4;
    public static final int output_format_shimp = 4;
    public static final int output_format_B = 5;
    public static final int output_format_baf = 5;
    public static final int output_format_b = 6;
    public static final int output_format_G = 7;
    public static final int output_format_grimple = 7;
    public static final int output_format_g = 8;
    public static final int output_format_grimp = 8;
    public static final int output_format_X = 9;
    public static final int output_format_xml = 9;
    public static final int output_format_n = 10;
    public static final int output_format_none = 10;
    public static final int output_format_jasmin = 11;
    public static final int output_format_c = 12;
    public static final int output_format_class = 12;
    public static final int output_format_d = 13;
    public static final int output_format_dava = 13;
    private boolean help = false;
    private boolean phase_list = false;
    private List phase_help = null;
    private boolean version = false;
    private boolean verbose = false;
    private boolean app = false;
    private boolean whole_program = false;
    private boolean whole_shimple = false;
    private boolean debug = false;
    private String soot_classpath = "";
    private List process_dir = null;
    private int src_prec = 0;
    private boolean allow_phantom_refs = false;
    private String output_dir = "";
    private int output_format = 0;
    private boolean xml_attributes = false;
    private boolean via_grimp = false;
    private boolean via_shimple = false;
    private List include = null;
    private List exclude = null;
    private boolean include_all = false;
    private List dynamic_class = null;
    private List dynamic_dir = null;
    private List dynamic_package = null;
    private boolean keep_line_number = false;
    private boolean keep_offset = false;
    private boolean time = false;
    private boolean subtract_gc = false;

    public Options(Singletons.Global g) {
    }

    public static Options v() {
        return G.v().Options();
    }

    public boolean parse(String[] argv) {
        String phaseOption;
        String phaseName;
        LinkedList<String> phaseOptions = new LinkedList<String>();
        for (int i = argv.length; i > 0; --i) {
            this.pushOptions(argv[i - 1]);
        }
        while (this.hasMoreOptions()) {
            String value;
            String option = this.nextOption();
            if (option.charAt(0) != '-') {
                this.classes.add(option);
                continue;
            }
            while (option.charAt(0) == '-') {
                option = option.substring(1);
            }
            if (option.equals("h") || option.equals("help")) {
                this.help = true;
                continue;
            }
            if (option.equals("pl") || option.equals("phase-list")) {
                this.phase_list = true;
                continue;
            }
            if (option.equals("ph") || option.equals("phase-help")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.phase_help == null) {
                    this.phase_help = new LinkedList();
                }
                this.phase_help.add(value);
                continue;
            }
            if (option.equals("version")) {
                this.version = true;
                continue;
            }
            if (option.equals("v") || option.equals("verbose")) {
                this.verbose = true;
                continue;
            }
            if (option.equals("app")) {
                this.app = true;
                continue;
            }
            if (option.equals("w") || option.equals("whole-program")) {
                this.whole_program = true;
                continue;
            }
            if (option.equals("ws") || option.equals("whole-shimple")) {
                this.whole_shimple = true;
                continue;
            }
            if (option.equals("debug")) {
                this.debug = true;
                continue;
            }
            if (option.equals("cp") || option.equals("soot-class-path") || option.equals("soot-classpath")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.soot_classpath.length() == 0) {
                    this.soot_classpath = value;
                    continue;
                }
                G.v().out.println("Duplicate values " + this.soot_classpath + " and " + value + " for option -" + option);
                return false;
            }
            if (option.equals("process-dir")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.process_dir == null) {
                    this.process_dir = new LinkedList();
                }
                this.process_dir.add(value);
                continue;
            }
            if (option.equals("src-prec")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (value.equals("c") || value.equals("class")) {
                    if (this.src_prec != 0 && this.src_prec != 1) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.src_prec = 1;
                    continue;
                }
                if (value.equals("J") || value.equals("jimple")) {
                    if (this.src_prec != 0 && this.src_prec != 2) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.src_prec = 2;
                    continue;
                }
                if (value.equals("java")) {
                    if (this.src_prec != 0 && this.src_prec != 3) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.src_prec = 3;
                    continue;
                }
                G.v().out.println("Invalid value " + value + " given for option -" + option);
                return false;
            }
            if (option.equals("allow-phantom-refs")) {
                this.allow_phantom_refs = true;
                continue;
            }
            if (option.equals("d") || option.equals("output-dir")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.output_dir.length() == 0) {
                    this.output_dir = value;
                    continue;
                }
                G.v().out.println("Duplicate values " + this.output_dir + " and " + value + " for option -" + option);
                return false;
            }
            if (option.equals("f") || option.equals("output-format")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (value.equals("J") || value.equals("jimple")) {
                    if (this.output_format != 0 && this.output_format != 1) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 1;
                    continue;
                }
                if (value.equals("j") || value.equals("jimp")) {
                    if (this.output_format != 0 && this.output_format != 2) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 2;
                    continue;
                }
                if (value.equals("S") || value.equals("shimple")) {
                    if (this.output_format != 0 && this.output_format != 3) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 3;
                    continue;
                }
                if (value.equals("s") || value.equals("shimp")) {
                    if (this.output_format != 0 && this.output_format != 4) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 4;
                    continue;
                }
                if (value.equals("B") || value.equals("baf")) {
                    if (this.output_format != 0 && this.output_format != 5) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 5;
                    continue;
                }
                if (value.equals("b")) {
                    if (this.output_format != 0 && this.output_format != 6) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 6;
                    continue;
                }
                if (value.equals("G") || value.equals("grimple")) {
                    if (this.output_format != 0 && this.output_format != 7) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 7;
                    continue;
                }
                if (value.equals("g") || value.equals("grimp")) {
                    if (this.output_format != 0 && this.output_format != 8) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 8;
                    continue;
                }
                if (value.equals("X") || value.equals("xml")) {
                    if (this.output_format != 0 && this.output_format != 9) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 9;
                    continue;
                }
                if (value.equals("n") || value.equals("none")) {
                    if (this.output_format != 0 && this.output_format != 10) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 10;
                    continue;
                }
                if (value.equals("jasmin")) {
                    if (this.output_format != 0 && this.output_format != 11) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 11;
                    continue;
                }
                if (value.equals("c") || value.equals("class")) {
                    if (this.output_format != 0 && this.output_format != 12) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 12;
                    continue;
                }
                if (value.equals("d") || value.equals("dava")) {
                    if (this.output_format != 0 && this.output_format != 13) {
                        G.v().out.println("Multiple values given for option " + option);
                        return false;
                    }
                    this.output_format = 13;
                    continue;
                }
                G.v().out.println("Invalid value " + value + " given for option -" + option);
                return false;
            }
            if (option.equals("xml-attributes")) {
                this.xml_attributes = true;
                continue;
            }
            if (option.equals("p") || option.equals("phase-option")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No phase name given for option -" + option);
                    return false;
                }
                phaseName = this.nextOption();
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No phase option given for option -" + option + " " + phaseName);
                    return false;
                }
                phaseOption = this.nextOption();
                phaseOptions.add(phaseName);
                phaseOptions.add(phaseOption);
                continue;
            }
            if (option.equals("O") || option.equals("optimize")) {
                this.pushOptions("enabled:true");
                this.pushOptions("sop");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("jop");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("gop");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("bop");
                this.pushOptions("-p");
                this.pushOptions("only-stack-locals:false");
                this.pushOptions("gb.a2");
                this.pushOptions("-p");
                this.pushOptions("only-stack-locals:false");
                this.pushOptions("gb.a1");
                this.pushOptions("-p");
                continue;
            }
            if (option.equals("W") || option.equals("whole-optimize")) {
                this.pushOptions("-O");
                this.pushOptions("-w");
                this.pushOptions("enabled:true");
                this.pushOptions("wsop");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("wjop");
                this.pushOptions("-p");
                continue;
            }
            if (option.equals("via-grimp")) {
                this.via_grimp = true;
                continue;
            }
            if (option.equals("via-shimple")) {
                this.via_shimple = true;
                continue;
            }
            if (option.equals("i") || option.equals("include")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.include == null) {
                    this.include = new LinkedList();
                }
                this.include.add(value);
                continue;
            }
            if (option.equals("x") || option.equals("exclude")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.exclude == null) {
                    this.exclude = new LinkedList();
                }
                this.exclude.add(value);
                continue;
            }
            if (option.equals("include-all")) {
                this.include_all = true;
                continue;
            }
            if (option.equals("dynamic-class")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.dynamic_class == null) {
                    this.dynamic_class = new LinkedList();
                }
                this.dynamic_class.add(value);
                continue;
            }
            if (option.equals("dynamic-dir")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.dynamic_dir == null) {
                    this.dynamic_dir = new LinkedList();
                }
                this.dynamic_dir.add(value);
                continue;
            }
            if (option.equals("dynamic-package")) {
                if (!this.hasMoreOptions()) {
                    G.v().out.println("No value given for option -" + option);
                    return false;
                }
                value = this.nextOption();
                if (this.dynamic_package == null) {
                    this.dynamic_package = new LinkedList();
                }
                this.dynamic_package.add(value);
                continue;
            }
            if (option.equals("keep-line-number")) {
                this.keep_line_number = true;
                continue;
            }
            if (option.equals("keep-bytecode-offset") || option.equals("keep-offset")) {
                this.keep_offset = true;
                continue;
            }
            if (option.equals("annot-nullpointer")) {
                this.pushOptions("enabled:true");
                this.pushOptions("tag.an");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("jap.npc");
                this.pushOptions("-p");
                continue;
            }
            if (option.equals("annot-arraybounds")) {
                this.pushOptions("enabled:true");
                this.pushOptions("tag.an");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("jap.abc");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("wjap.ra");
                this.pushOptions("-p");
                continue;
            }
            if (option.equals("annot-side-effect")) {
                this.pushOptions("enabled:true");
                this.pushOptions("tag.dep");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("jap.sea");
                this.pushOptions("-p");
                this.pushOptions("-w");
                continue;
            }
            if (option.equals("annot-fieldrw")) {
                this.pushOptions("enabled:true");
                this.pushOptions("tag.fieldrw");
                this.pushOptions("-p");
                this.pushOptions("enabled:true");
                this.pushOptions("jap.fieldrw");
                this.pushOptions("-p");
                this.pushOptions("-w");
                continue;
            }
            if (option.equals("time")) {
                this.time = true;
                continue;
            }
            if (option.equals("subtract-gc")) {
                this.subtract_gc = true;
                continue;
            }
            G.v().out.println("Invalid option -" + option);
            return false;
        }
        Iterator it = phaseOptions.iterator();
        while (it.hasNext()) {
            phaseName = (String)it.next();
            phaseOption = (String)it.next();
            if (this.setPhaseOption(phaseName, "enabled:true")) continue;
            return false;
        }
        it = phaseOptions.iterator();
        while (it.hasNext()) {
            phaseName = (String)it.next();
            if (this.setPhaseOption(phaseName, phaseOption = (String)it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean help() {
        return this.help;
    }

    public void set_help(boolean setting) {
        this.help = setting;
    }

    public boolean phase_list() {
        return this.phase_list;
    }

    public void set_phase_list(boolean setting) {
        this.phase_list = setting;
    }

    public List phase_help() {
        if (this.phase_help == null) {
            return Collections.EMPTY_LIST;
        }
        return this.phase_help;
    }

    public void set_phase_help(List setting) {
        this.phase_help = setting;
    }

    public boolean version() {
        return this.version;
    }

    public void set_version(boolean setting) {
        this.version = setting;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void set_verbose(boolean setting) {
        this.verbose = setting;
    }

    public boolean app() {
        return this.app;
    }

    public void set_app(boolean setting) {
        this.app = setting;
    }

    public boolean whole_program() {
        return this.whole_program;
    }

    public void set_whole_program(boolean setting) {
        this.whole_program = setting;
    }

    public boolean whole_shimple() {
        return this.whole_shimple;
    }

    public void set_whole_shimple(boolean setting) {
        this.whole_shimple = setting;
    }

    public boolean debug() {
        return this.debug;
    }

    public void set_debug(boolean setting) {
        this.debug = setting;
    }

    public String soot_classpath() {
        return this.soot_classpath;
    }

    public void set_soot_classpath(String setting) {
        this.soot_classpath = setting;
    }

    public List process_dir() {
        if (this.process_dir == null) {
            return Collections.EMPTY_LIST;
        }
        return this.process_dir;
    }

    public void set_process_dir(List setting) {
        this.process_dir = setting;
    }

    public int src_prec() {
        if (this.src_prec == 0) {
            return 1;
        }
        return this.src_prec;
    }

    public void set_src_prec(int setting) {
        this.src_prec = setting;
    }

    public boolean allow_phantom_refs() {
        return this.allow_phantom_refs;
    }

    public void set_allow_phantom_refs(boolean setting) {
        this.allow_phantom_refs = setting;
    }

    public String output_dir() {
        return this.output_dir;
    }

    public void set_output_dir(String setting) {
        this.output_dir = setting;
    }

    public int output_format() {
        if (this.output_format == 0) {
            return 12;
        }
        return this.output_format;
    }

    public void set_output_format(int setting) {
        this.output_format = setting;
    }

    public boolean xml_attributes() {
        return this.xml_attributes;
    }

    public void set_xml_attributes(boolean setting) {
        this.xml_attributes = setting;
    }

    public boolean via_grimp() {
        return this.via_grimp;
    }

    public void set_via_grimp(boolean setting) {
        this.via_grimp = setting;
    }

    public boolean via_shimple() {
        return this.via_shimple;
    }

    public void set_via_shimple(boolean setting) {
        this.via_shimple = setting;
    }

    public List include() {
        if (this.include == null) {
            return Collections.EMPTY_LIST;
        }
        return this.include;
    }

    public void set_include(List setting) {
        this.include = setting;
    }

    public List exclude() {
        if (this.exclude == null) {
            return Collections.EMPTY_LIST;
        }
        return this.exclude;
    }

    public void set_exclude(List setting) {
        this.exclude = setting;
    }

    public boolean include_all() {
        return this.include_all;
    }

    public void set_include_all(boolean setting) {
        this.include_all = setting;
    }

    public List dynamic_class() {
        if (this.dynamic_class == null) {
            return Collections.EMPTY_LIST;
        }
        return this.dynamic_class;
    }

    public void set_dynamic_class(List setting) {
        this.dynamic_class = setting;
    }

    public List dynamic_dir() {
        if (this.dynamic_dir == null) {
            return Collections.EMPTY_LIST;
        }
        return this.dynamic_dir;
    }

    public void set_dynamic_dir(List setting) {
        this.dynamic_dir = setting;
    }

    public List dynamic_package() {
        if (this.dynamic_package == null) {
            return Collections.EMPTY_LIST;
        }
        return this.dynamic_package;
    }

    public void set_dynamic_package(List setting) {
        this.dynamic_package = setting;
    }

    public boolean keep_line_number() {
        return this.keep_line_number;
    }

    public void set_keep_line_number(boolean setting) {
        this.keep_line_number = setting;
    }

    public boolean keep_offset() {
        return this.keep_offset;
    }

    public void set_keep_offset(boolean setting) {
        this.keep_offset = setting;
    }

    public boolean time() {
        return this.time;
    }

    public void set_time(boolean setting) {
        this.time = setting;
    }

    public boolean subtract_gc() {
        return this.subtract_gc;
    }

    public void set_subtract_gc(boolean setting) {
        this.subtract_gc = setting;
    }

    public String getUsage() {
        return "\nGeneral Options:\n" + this.padOpt(" -h -help", "Display help and exit") + this.padOpt(" -pl -phase-list", "Print list of available phases") + this.padOpt(" -ph PHASE -phase-help PHASE", "Print help for specified PHASE") + this.padOpt(" -version", "Display version information and exit") + this.padOpt(" -v -verbose", "Verbose mode") + this.padOpt(" -app", "Run in application mode") + this.padOpt(" -w -whole-program", "Run in whole-program mode") + this.padOpt(" -ws -whole-shimple", "Run in whole-shimple mode") + this.padOpt(" -debug", "Print various Soot debugging info") + "\nInput Options:\n" + this.padOpt(" -cp PATH -soot-class-path PATH -soot-classpath PATH", "Use PATH as the classpath for finding classes.") + this.padOpt(" -process-dir DIR", "Process all classes found in DIR") + this.padOpt(" -src-prec FORMAT", "Sets source precedence to FORMAT files") + this.padVal(" c class (default)", "Favour class files as Soot source") + this.padVal(" J jimple", "Favour Jimple files as Soot source") + this.padVal(" java", "Favour Java files as Soot source") + this.padOpt(" -allow-phantom-refs", "Allow unresolved classes; may cause errors") + "\nOutput Options:\n" + this.padOpt(" -d DIR -output-dir DIR", "Store output files in DIR") + this.padOpt(" -f FORMAT -output-format FORMAT", "Set output format for Soot") + this.padVal(" J jimple", "Produce .jimple Files") + this.padVal(" j jimp", "Produce .jimp (abbreviated Jimple) files") + this.padVal(" S shimple", "Produce .shimple files") + this.padVal(" s shimp", "Produce .shimp (abbreviated Shimple) files") + this.padVal(" B baf", "Produce .baf files") + this.padVal(" b", "Produce .b (abbreviated Baf) files") + this.padVal(" G grimple", "Produce .grimple files") + this.padVal(" g grimp", "Produce .grimp (abbreviated Grimp) files") + this.padVal(" X xml", "Produce .xml Files") + this.padVal(" n none", "Produce no output") + this.padVal(" jasmin", "Produce .jasmin files") + this.padVal(" c class (default)", "Produce .class Files") + this.padVal(" d dava", "Produce dava-decompiled .java files") + this.padOpt(" -xml-attributes", "Save tags to XML attributes for Eclipse") + "\nProcessing Options:\n" + this.padOpt(" -p PHASE OPT:VAL -phase-option PHASE OPT:VAL", "Set PHASE's OPT option to VALUE") + this.padOpt(" -O -optimize", "Perform intraprocedural optimizations") + this.padOpt(" -W -whole-optimize", "Perform whole program optimizations") + this.padOpt(" -via-grimp", "Convert to bytecode via Grimp instead of via Baf") + this.padOpt(" -via-shimple", "Enable Shimple SSA representation") + "\nApplication Mode Options:\n" + this.padOpt(" -i PKG -include PKG", "Include classes in PKG as application classes") + this.padOpt(" -x PKG -exclude PKG", "Exclude classes in PKG from application classes") + this.padOpt(" -include-all", "Set default excluded packages to empty list") + this.padOpt(" -dynamic-class CLASS", "Note that CLASS may be loaded dynamically") + this.padOpt(" -dynamic-dir DIR", "Mark all classes in DIR as potentially dynamic") + this.padOpt(" -dynamic-package PKG", "Marks classes in PKG as potentially dynamic") + "\nInput Attribute Options:\n" + this.padOpt(" -keep-line-number", "Keep line number tables") + this.padOpt(" -keep-bytecode-offset -keep-offset", "Attach bytecode offset to IR") + "\nAnnotation Options:\n" + this.padOpt(" -annot-nullpointer", "Emit null pointer attributes") + this.padOpt(" -annot-arraybounds", "Emit array bounds check attributes") + this.padOpt(" -annot-side-effect", "Emit side-effect attributes") + this.padOpt(" -annot-fieldrw", "Emit field read/write attributes") + "\nMiscellaneous Options:\n" + this.padOpt(" -time", "Report time required for transformations") + this.padOpt(" -subtract-gc", "Subtract gc from time");
    }

    public String getPhaseList() {
        return "" + this.padOpt("jb", "Creates a JimpleBody for each method") + this.padVal("jb.ls", "Local splitter: one local per DU-UD web") + this.padVal("jb.a", "Aggregator: removes some unnecessary copies") + this.padVal("jb.ule", "Unused local eliminator") + this.padVal("jb.tr", "Assigns types to locals") + this.padVal("jb.ulp", "Local packer: minimizes number of locals") + this.padVal("jb.lns", "Local name standardizer") + this.padVal("jb.cp", "Copy propagator") + this.padVal("jb.dae", "Dead assignment eliminator") + this.padVal("jb.cp-ule", "Post-copy propagation unused local eliminator") + this.padVal("jb.lp", "Local packer: minimizes number of locals") + this.padVal("jb.ne", "Nop eliminator") + this.padVal("jb.uce", "Unreachable code eliminator") + this.padOpt("jj", "Creates a JimpleBody for each method directly from source") + this.padVal("jj.ls", "Local splitter: one local per DU-UD web") + this.padVal("jj.a", "Aggregator: removes some unnecessary copies") + this.padVal("jj.ule", "Unused local eliminator") + this.padVal("jj.tr", "Assigns types to locals") + this.padVal("jj.ulp", "Local packer: minimizes number of locals") + this.padVal("jj.lns", "Local name standardizer") + this.padVal("jj.cp", "Copy propagator") + this.padVal("jj.dae", "Dead assignment eliminator") + this.padVal("jj.cp-ule", "Post-copy propagation unused local eliminator") + this.padVal("jj.lp", "Local packer: minimizes number of locals") + this.padVal("jj.ne", "Nop eliminator") + this.padVal("jj.uce", "Unreachable code eliminator") + this.padOpt("cg", "Call graph constructor") + this.padVal("cg.cha", "Builds call graph using Class Hierarchy Analysis") + this.padVal("cg.spark", "Spark points-to analysis framework") + this.padVal("cg.bdd", "BDD Spark points-to analysis framework") + this.padOpt("wstp", "Whole-shimple transformation pack") + this.padOpt("wsop", "Whole-shimple optimization pack") + this.padOpt("wjtp", "Whole-jimple transformation pack") + this.padOpt("wjop", "Whole-jimple optimization pack") + this.padVal("wjop.smb", "Static method binder: Devirtualizes monomorphic calls") + this.padVal("wjop.si", "Static inliner: inlines monomorphic calls") + this.padOpt("wjap", "Whole-jimple annotation pack: adds interprocedural tags") + this.padVal("wjap.ra", "Rectangular array finder") + this.padVal("wjap.umt", "Tags all unreachable methods") + this.padVal("wjap.uft", "Tags all unreachable fields") + this.padVal("wjap.tqt", "Tags all qualifiers that could be tighter") + this.padOpt("shimple", "Sets parameters for Shimple SSA form") + this.padOpt("stp", "Shimple transformation pack") + this.padOpt("sop", "Shimple optimization pack") + this.padVal("sop.cpf", "Shimple constant propagator and folder") + this.padOpt("jtp", "Jimple transformation pack: intraprocedural analyses added to Soot") + this.padOpt("jop", "Jimple optimization pack (intraprocedural)") + this.padVal("jop.cse", "Common subexpression eliminator") + this.padVal("jop.bcm", "Busy code motion: unaggressive partial redundancy elimination") + this.padVal("jop.lcm", "Lazy code motion: aggressive partial redundancy elimination") + this.padVal("jop.cp", "Copy propagator") + this.padVal("jop.cpf", "Constant propagator and folder") + this.padVal("jop.cbf", "Conditional branch folder") + this.padVal("jop.dae", "Dead assignment eliminator") + this.padVal("jop.uce1", "Unreachable code eliminator, pass 1") + this.padVal("jop.ubf1", "Unconditional branch folder, pass 1") + this.padVal("jop.uce2", "Unreachable code eliminator, pass 2") + this.padVal("jop.ubf2", "Unconditional branch folder, pass 2") + this.padVal("jop.ule", "Unused local eliminator") + this.padOpt("jap", "Jimple annotation pack: adds intraprocedural tags") + this.padVal("jap.npc", "Null pointer checker") + this.padVal("jap.npcolorer", "Null pointer colourer: tags references for eclipse") + this.padVal("jap.abc", "Array bound checker") + this.padVal("jap.profiling", "Instruments null pointer and array checks") + this.padVal("jap.sea", "Side effect tagger") + this.padVal("jap.fieldrw", "Field read/write tagger") + this.padVal("jap.cgtagger", "Call graph tagger") + this.padVal("jap.parity", "Parity tagger") + this.padVal("jap.pat", "Colour-codes method parameters that may be aliased") + this.padVal("jap.rdtagger", "Creates link tags for reaching defs") + this.padOpt("gb", "Creates a GrimpBody for each method") + this.padVal("gb.a1", "Aggregator: removes some copies, pre-folding") + this.padVal("gb.cf", "Constructor folder") + this.padVal("gb.a2", "Aggregator: removes some copies, post-folding") + this.padVal("gb.ule", "Unused local eliminator") + this.padOpt("gop", "Grimp optimization pack") + this.padOpt("bb", "Creates Baf bodies") + this.padVal("bb.lso", "Load store optimizer") + this.padVal("bb.pho", "Peephole optimizer") + this.padVal("bb.ule", "Unused local eliminator") + this.padVal("bb.lp", "Local packer: minimizes number of locals") + this.padOpt("bop", "Baf optimization pack") + this.padOpt("tag", "Tag aggregator: turns tags into attributes") + this.padVal("tag.ln", "Line number aggregator") + this.padVal("tag.an", "Array bounds and null pointer check aggregator") + this.padVal("tag.dep", "Dependence aggregator") + this.padVal("tag.fieldrw", "Field read/write aggregator");
    }

    public String getPhaseHelp(String phaseName) {
        if (phaseName.equals("jb")) {
            return "Phase " + phaseName + ":\n" + "\nJimple Body Creation creates a JimpleBody for each input \nmethod, using either coffi, to read .class files, or the jimple \nparser, to read .jimple files. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("use-original-names (false)", "");
        }
        if (phaseName.equals("jb.ls")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Splitter identifies DU-UD webs for local variables \nand introduces new variables so that each disjoint web is \nassociated with a single local. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jb.a")) {
            return "Phase " + phaseName + ":\n" + "\nThe Jimple Local Aggregator removes some unnecessary copies by \ncombining local variables. Essentially, it finds definitions \nwhich have only a single use and, if it is safe to do so, \nremoves the original definition after replacing the use with the \ndefinition's right-hand side. At this stage in JimpleBody \nconstruction, local aggregation serves largely to remove the \ncopies to and from stack variables which simulate load and store \ninstructions in the original bytecode." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("jb.ule")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unused Local Eliminator removes any unused locals from the \nmethod. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jb.tr")) {
            return "Phase " + phaseName + ":\n" + "\nThe Type Assigner gives local variables types which will \naccommodate the values stored in them over the course of the \nmethod. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jb.ulp")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unsplit-originals Local Packer executes only when the \n`use-original-names' option is chosen for the `jb' phase. The \nLocal Packer attempts to minimize the number of local variables \nrequired in a method by reusing the same variable for disjoint \nDU-UD webs. Conceptually, it is the inverse of the Local \nSplitter. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("unsplit-original-locals (true)", "");
        }
        if (phaseName.equals("jb.lns")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Name Standardizer assigns generic names to local \nvariables. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (false)", "");
        }
        if (phaseName.equals("jb.cp")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase performs cascaded copy propagation. If the \npropagator encounters situations of the form: A: a = ...; \n... B: x = a; ... C: ... = ... x; where a and x are \neach defined only once (at A and B, respectively), then it can \npropagate immediately without checking between B and C for \nredefinitions of a. In this case the propagator is global. \nOtherwise, if a has multiple definitions then the propagator \nchecks for redefinitions and propagates copies only within \nextended basic blocks. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-regular-locals (false)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("jb.dae")) {
            return "Phase " + phaseName + ":\n" + "\nThe Dead Assignment Eliminator eliminates assignment statements \nto locals whose values are not subsequently used, unless \nevaluating the right-hand side of the assignment may cause \nside-effects. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("jb.cp-ule")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase removes any locals that are unused after copy \npropagation. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jb.lp")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Packer attempts to minimize the number of local \nvariables required in a method by reusing the same variable for \ndisjoint DU-UD webs. Conceptually, it is the inverse of the \nLocal Splitter. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("unsplit-original-locals (false)", "");
        }
        if (phaseName.equals("jb.ne")) {
            return "Phase " + phaseName + ":\n" + "\nThe Nop Eliminator removes nop statements from the method. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jb.uce")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unreachable Code Eliminator removes unreachable code and \ntraps whose catch blocks are empty. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jj")) {
            return "Phase " + phaseName + ":\n" + "\nJimple Body Creation creates a JimpleBody for each input \nmethod, using polyglot, to read .java files. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("use-original-names (true)", "");
        }
        if (phaseName.equals("jj.ls")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Splitter identifies DU-UD webs for local variables \nand introduces new variables so that each disjoint web is \nassociated with a single local. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jj.a")) {
            return "Phase " + phaseName + ":\n" + "\nThe Jimple Local Aggregator removes some unnecessary copies by \ncombining local variables. Essentially, it finds definitions \nwhich have only a single use and, if it is safe to do so, \nremoves the original definition after replacing the use with the \ndefinition's right-hand side. At this stage in JimpleBody \nconstruction, local aggregation serves largely to remove the \ncopies to and from stack variables which simulate load and store \ninstructions in the original bytecode." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("jj.ule")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unused Local Eliminator removes any unused locals from the \nmethod. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jj.tr")) {
            return "Phase " + phaseName + ":\n" + "\nThe Type Assigner gives local variables types which will \naccommodate the values stored in them over the course of the \nmethod. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("jj.ulp")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unsplit-originals Local Packer executes only when the \n`use-original-names' option is chosen for the `jb' phase. The \nLocal Packer attempts to minimize the number of local variables \nrequired in a method by reusing the same variable for disjoint \nDU-UD webs. Conceptually, it is the inverse of the Local \nSplitter. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("unsplit-original-locals (false)", "");
        }
        if (phaseName.equals("jj.lns")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Name Standardizer assigns generic names to local \nvariables. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (false)", "");
        }
        if (phaseName.equals("jj.cp")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase performs cascaded copy propagation. If the \npropagator encounters situations of the form: A: a = ...; \n... B: x = a; ... C: ... = ... x; where a and x are \neach defined only once (at A and B, respectively), then it can \npropagate immediately without checking between B and C for \nredefinitions of a. In this case the propagator is global. \nOtherwise, if a has multiple definitions then the propagator \nchecks for redefinitions and propagates copies only within \nextended basic blocks. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-regular-locals (false)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("jj.dae")) {
            return "Phase " + phaseName + ":\n" + "\nThe Dead Assignment Eliminator eliminates assignment statements \nto locals whose values are not subsequently used, unless \nevaluating the right-hand side of the assignment may cause \nside-effects. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("jj.cp-ule")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase removes any locals that are unused after copy \npropagation. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jj.lp")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Packer attempts to minimize the number of local \nvariables required in a method by reusing the same variable for \ndisjoint DU-UD webs. Conceptually, it is the inverse of the \nLocal Splitter. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("unsplit-original-locals (false)", "");
        }
        if (phaseName.equals("jj.ne")) {
            return "Phase " + phaseName + ":\n" + "\nThe Nop Eliminator removes nop statements from the method. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jj.uce")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unreachable Code Eliminator removes unreachable code and \ntraps whose catch blocks are empty. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("cg")) {
            return "Phase " + phaseName + ":\n" + "\nThe Call Graph Constructor computes a call graph for whole \nprogram analysis. When this pack finishes, a call graph is \navailable in the Scene. The different phases in this pack are \ndifferent ways to construct the call graph. Exactly one phase in \nthis pack must be enabled; Soot will raise an error otherwise. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("safe-forname (true)", "Handle Class.forName() calls conservatively") + this.padOpt("safe-newinstance (true)", "Handle Class.newInstance() calls conservatively") + this.padOpt("verbose (false)", "Print warnings about where the call graph may be incomplete") + this.padOpt("all-reachable (false)", "Assume all methods of application classes are reachable.") + this.padOpt("trim-clinit (true)", "Removes redundant static initializer calls") + this.padOpt("context", "Select context-sensitivity level") + this.padVal("insens (default)", "Builds a context-insensitive call graph") + this.padVal("1cfa", "Builds a 1-CFA call graph") + this.padVal("objsens", "Builds an object-sensitive call graph");
        }
        if (phaseName.equals("cg.cha")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase uses Class Hierarchy Analysis to generate a call \ngraph." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("verbose (false)", "Print statistics about the resulting call graph");
        }
        if (phaseName.equals("cg.spark")) {
            return "Phase " + phaseName + ":\n" + "\nSpark is a flexible points-to analysis framework. Aside from \nbuilding a call graph, it also generates information about the \ntargets of pointers. For details about Spark, please see Ondrej \nLhotak's M.Sc. thesis." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("verbose (false)", "Print detailed information about the execution of Spark") + this.padOpt("ignore-types (false)", "Make Spark completely ignore declared types of variables") + this.padOpt("force-gc (false)", "Force garbage collection for measuring memory usage") + this.padOpt("pre-jimplify (false)", "Jimplify all methods before starting Spark") + this.padOpt("vta (false)", "Emulate Variable Type Analysis") + this.padOpt("rta (false)", "Emulate Rapid Type Analysis") + this.padOpt("field-based (false)", "Use a field-based rather than field-sensitive representation") + this.padOpt("types-for-sites (false)", "Represent objects by their actual type rather than allocation site") + this.padOpt("merge-stringbuffer (true)", "Represent all StringBuffers as one object") + this.padOpt("string-constants (false)", "Propagate all string constants, not just class names") + this.padOpt("simulate-natives (true)", "Simulate effects of native methods in standard class library") + this.padOpt("simple-edges-bidirectional (false)", "Equality-based analysis between variable nodes") + this.padOpt("on-fly-cg (true)", "Build call graph as receiver types become known") + this.padOpt("simplify-offline (false)", "Collapse single-entry subgraphs of the PAG") + this.padOpt("simplify-sccs (false)", "Collapse strongly-connected components of the PAG") + this.padOpt("ignore-types-for-sccs (false)", "Ignore declared types when determining node equivalence for SCCs") + this.padOpt("propagator", "Select propagation algorithm") + this.padVal("iter", "Simple iterative algorithm") + this.padVal("worklist (default)", "Fast, worklist-based algorithm") + this.padVal("cycle", "Unfinished on-the-fly cycle detection algorithm") + this.padVal("merge", "Unfinished field reference merging algorithms") + this.padVal("alias", "Alias-edge based algorithm") + this.padVal("none", "Disable propagation") + this.padOpt("set-impl", "Select points-to set implementation") + this.padVal("hash", "Use Java HashSet") + this.padVal("bit", "Bit vector") + this.padVal("hybrid", "Hybrid representation using bit vector for large sets") + this.padVal("array", "Sorted array representation") + this.padVal("double (default)", "Double set representation for incremental propagation") + this.padVal("shared", "Shared bit-vector representation") + this.padOpt("double-set-old", "Select implementation of points-to set for old part of double set") + this.padVal("hash", "Use Java HashSet") + this.padVal("bit", "Bit vector") + this.padVal("hybrid (default)", "Hybrid representation using bit vector for large sets") + this.padVal("array", "Sorted array representation") + this.padVal("shared", "Shared bit-vector representation") + this.padOpt("double-set-new", "Select implementation of points-to set for new part of double set") + this.padVal("hash", "Use Java HashSet") + this.padVal("bit", "Bit vector") + this.padVal("hybrid (default)", "Hybrid representation using bit vector for large sets") + this.padVal("array", "Sorted array representation") + this.padVal("shared", "Shared bit-vector representation") + this.padOpt("dump-html (false)", "Dump pointer assignment graph to HTML for debugging") + this.padOpt("dump-pag (false)", "Dump pointer assignment graph for other solvers") + this.padOpt("dump-solution (false)", "Dump final solution for comparison with other solvers") + this.padOpt("topo-sort (false)", "Sort variable nodes in dump") + this.padOpt("dump-types (true)", "Include declared types in dump") + this.padOpt("class-method-var (true)", "In dump, label variables by class and method") + this.padOpt("dump-answer (false)", "Dump computed reaching types for comparison with other solvers") + this.padOpt("add-tags (false)", "Output points-to results in tags for viewing with the Jimple") + this.padOpt("set-mass (false)", "Calculate statistics about points-to set sizes");
        }
        if (phaseName.equals("cg.bdd")) {
            return "Phase " + phaseName + ":\n" + "\nSpark is a flexible points-to analysis framework. Aside from \nbuilding a call graph, it also generates information about the \ntargets of pointers. For details about Spark, please see Ondrej \nLhotak's M.Sc. thesis. This phase is the new BDD-based version \nof Spark." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("verbose (false)", "Print detailed information about the execution of Spark") + this.padOpt("ignore-types (false)", "Make Spark completely ignore declared types of variables") + this.padOpt("force-gc (false)", "Force garbage collection for measuring memory usage") + this.padOpt("pre-jimplify (false)", "Jimplify all methods before starting Spark") + this.padOpt("vta (false)", "Emulate Variable Type Analysis") + this.padOpt("rta (false)", "Emulate Rapid Type Analysis") + this.padOpt("field-based (false)", "Use a field-based rather than field-sensitive representation") + this.padOpt("types-for-sites (false)", "Represent objects by their actual type rather than allocation site") + this.padOpt("merge-stringbuffer (true)", "Represent all StringBuffers as one object") + this.padOpt("string-constants (false)", "Propagate all string constants, not just class names") + this.padOpt("simulate-natives (true)", "Simulate effects of native methods in standard class library") + this.padOpt("simple-edges-bidirectional (false)", "Equality-based analysis between variable nodes") + this.padOpt("on-fly-cg (true)", "Build call graph as receiver types become known") + this.padOpt("simplify-offline (false)", "Collapse single-entry subgraphs of the PAG") + this.padOpt("simplify-sccs (false)", "Collapse strongly-connected components of the PAG") + this.padOpt("ignore-types-for-sccs (false)", "Ignore declared types when determining node equivalence for SCCs") + this.padOpt("dump-html (false)", "Dump pointer assignment graph to HTML for debugging") + this.padOpt("dump-pag (false)", "Dump pointer assignment graph for other solvers") + this.padOpt("dump-solution (false)", "Dump final solution for comparison with other solvers") + this.padOpt("topo-sort (false)", "Sort variable nodes in dump") + this.padOpt("dump-types (true)", "Include declared types in dump") + this.padOpt("class-method-var (true)", "In dump, label variables by class and method") + this.padOpt("dump-answer (false)", "Dump computed reaching types for comparison with other solvers") + this.padOpt("add-tags (false)", "Output points-to results in tags for viewing with the Jimple") + this.padOpt("set-mass (false)", "Calculate statistics about points-to set sizes");
        }
        if (phaseName.equals("wstp")) {
            return "Phase " + phaseName + ":\n" + "\nSoot can perform whole-program analyses. In whole-shimple \nmode, Soot applies the contents of the Whole-Shimple \nTransformation Pack to the scene as a whole after constructing a \ncall graph for the program. In an unmodified copy of Soot the \nWhole-Shimple Transformation Pack is empty." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("wsop")) {
            return "Phase " + phaseName + ":\n" + "\nIf Soot is running in whole shimple mode and the Whole-Shimple \nOptimization Pack is enabled, the pack's transformations are \napplied to the scene as a whole after construction of the call \ngraph and application of any enabled Whole-Shimple \nTransformations. In an unmodified copy of Soot the Whole-Shimple \nOptimization Pack is empty." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("wjtp")) {
            return "Phase " + phaseName + ":\n" + "\nSoot can perform whole-program analyses. In whole-program \nmode, Soot applies the contents of the Whole-Jimple \nTransformation Pack to the scene as a whole after constructing a \ncall graph for the program. In an unmodified copy of Soot the \nWhole-Jimple Transformation Pack is empty." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("wjop")) {
            return "Phase " + phaseName + ":\n" + "\nIf Soot is running in whole program mode and the Whole-Jimple \nOptimization Pack is enabled, the pack's transformations are \napplied to the scene as a whole after construction of the call \ngraph and application of any enabled Whole-Jimple \nTransformations." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("wjop.smb")) {
            return "Phase " + phaseName + ":\n" + "\nThe Static Method Binder statically binds monomorphic call \nsites. That is, it searches the call graph for virtual method \ninvocations that can be determined statically to call only a \nsingle implementation of the called method. Then it replaces \nsuch virtual invocations with invocations of a static copy of \nthe single called implementation. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("insert-null-checks (true)", "") + this.padOpt("insert-redundant-casts (true)", "") + this.padOpt("allowed-modifier-changes", "") + this.padVal("unsafe (default)", "") + this.padVal("safe", "") + this.padVal("none", "");
        }
        if (phaseName.equals("wjop.si")) {
            return "Phase " + phaseName + ":\n" + "\nThe Static Inliner visits all call sites in the call graph in a \nbottom-up fashion, replacing monomorphic calls with inlined \ncopies of the invoked methods. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("rerun-jb (true)", "") + this.padOpt("insert-null-checks (true)", "") + this.padOpt("insert-redundant-casts (true)", "") + this.padOpt("allowed-modifier-changes", "") + this.padVal("unsafe (default)", "") + this.padVal("safe", "") + this.padVal("none", "") + this.padOpt("expansion-factor (3)", "") + this.padOpt("max-container-size (5000)", "") + this.padOpt("max-inlinee-size (20)", "");
        }
        if (phaseName.equals("wjap")) {
            return "Phase " + phaseName + ":\n" + "\nSome analyses do not transform Jimple body directly, but \nannotate statements or values with tags. Whole-Jimple annotation \npack provides a place for annotation-oriented analyses in whole \nprogram mode." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("wjap.ra")) {
            return "Phase " + phaseName + ":\n" + "\nThe Rectangular Array Finder traverses Jimple statements based \non the static call graph, and finds array variables which always \nhold rectangular two-dimensional array objects. In Java, a \nmulti-dimensional array is an array of arrays, which means the \nshape of the array can be ragged. Nevertheless, many \napplications use rectangular arrays. Knowing that an array is \nrectangular can be very helpful in proving safe array bounds \nchecks. The Rectangular Array Finder does not change the program \nbeing analyzed. Its results are used by the Array Bound Checker." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("wjap.umt")) {
            return "Phase " + phaseName + ":\n" + "\nUses the call graph to determine which methods are unreachable \nand adds color tags so they can be highlighted in a source \nbrowser." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("wjap.uft")) {
            return "Phase " + phaseName + ":\n" + "\nUses the call graph to determine which fields are unreachable \nand adds color tags so they can be highlighted in a source \nbrowser." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("wjap.tqt")) {
            return "Phase " + phaseName + ":\n" + "\nDetermines which methods and fields have qualifiers that could \nbe tightened. For example: if a field or method has the \nqualifier of public but is only used within the declaring class \nit could be private. This, this field or method is tagged with \ncolor tags so that the results can be highlighted in a source \nbrowser." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("shimple")) {
            return "Phase " + phaseName + ":\n" + "\nShimple Control sets parameters which apply throughout the \ncreation and manipulation of Shimple bodies. Shimple is Soot's \nSSA representation." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("phi-elim-opt", "Phi node elimination optimizations") + this.padVal("none", "Do not optimize during Phi elimination") + this.padVal("pre", "Perform some optimizations before eliminating Phi nodes") + this.padVal("post (default)", "If enabled, some optimizations are applied after               Phi nodes are eliminated.") + this.padVal("pre-and-post", "If enabled, some optimizations are applied             both before and after Phi nodes are eliminated.") + this.padOpt("standard-local-names (false)", "Uses naming scheme of the Local Name             Standardizer.") + this.padOpt("debug (false)", "Enables debugging output, if any.");
        }
        if (phaseName.equals("stp")) {
            return "Phase " + phaseName + ":\n" + "\nWhen the Shimple representation is produced, Soot \napplies the contents of the Shimple Transformation \nPack to each method under analysis. This pack \ncontains no transformations in an unmodified version \nof Soot. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("sop")) {
            return "Phase " + phaseName + ":\n" + "\nThe Shimple Optimization Pack contains \ntransformations that perform optimizations on \nShimple, Soot's SSA representation. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("sop.cpf")) {
            return "Phase " + phaseName + ":\n" + "\nA powerful constant propagator and folder based \non an algorithm sketched by Cytron et al that \ntakes conditional control flow into account. This \noptimization demonstrates some of the benefits of \nSSA -- particularly the fact that Phi nodes \nrepresent natural merge points in the control \nflow. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("prune-cfg (true)", "Take advantage of CFG optimization             opportunities.");
        }
        if (phaseName.equals("jtp")) {
            return "Phase " + phaseName + ":\n" + "\nSoot applies the contents of the Jimple Transformation Pack to \neach method under analysis. This pack contains no \ntransformations in an unmodified version of Soot. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop")) {
            return "Phase " + phaseName + ":\n" + "\nWhen Soot's Optimize option is on, Soot applies the Jimple \nOptimization Pack to every JimpleBody in application classes. \nThis section lists the default transformations in the Jimple \nOptimization Pack. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "Eliminates common subexpressions");
        }
        if (phaseName.equals("jop.cse")) {
            return "Phase " + phaseName + ":\n" + "\nThe Common Subexpression Eliminator runs an available \nexpressions analysis on the method body, then eliminates common \nsubexpressions. This implementation is especially slow, as it \nruns on individual statements rather than on basic blocks. A \nbetter implementation (which would find most common \nsubexpressions, but not all) would use basic blocks instead. \nThis implementation is also slow because the flow universe is \nexplicitly created; it need not be. A better implementation \nwould implicitly compute the kill sets at every node. Because \nof its current slowness, this transformation is not enabled by \ndefault. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("naive-side-effect (false)", "Use naive side effect analysis even if interprocedural information is available");
        }
        if (phaseName.equals("jop.bcm")) {
            return "Phase " + phaseName + ":\n" + "\nBusy Code Motion is a straightforward implementation of Partial \nRedundancy Elimination. This implementation is not very \naggressive. Lazy Code Motion is an improved version which \nshould be used instead of Busy Code Motion. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("naive-side-effect (false)", "Use a naive side effect analysis even if interprocedural information is available");
        }
        if (phaseName.equals("jop.lcm")) {
            return "Phase " + phaseName + ":\n" + "\nLazy Code Motion is an enhanced version of Busy Code Motion, a \nPartial Redundancy Eliminator. Before doing Partial Redundancy \nElimination, this optimization performs loop inversion (turning \nwhile loops into do while loops inside an if statement). This \nallows the Partial Redundancy Eliminator to optimize loop \ninvariants of while loops. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("safety", "") + this.padVal("safe (default)", "") + this.padVal("medium", "") + this.padVal("unsafe", "") + this.padOpt("unroll (true)", "") + this.padOpt("naive-side-effect (false)", "Use a naive side effect analysis even if interprocedural information is available");
        }
        if (phaseName.equals("jop.cp")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase performs cascaded copy propagation." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-regular-locals (false)", "") + this.padOpt("only-stack-locals (false)", "");
        }
        if (phaseName.equals("jop.cpf")) {
            return "Phase " + phaseName + ":\n" + "\nThe Jimple Constant Propagator and Folder evaluates any \nexpressions consisting entirely of compile-time constants, for \nexample 2 * 3, and replaces the expression with the constant \nresult, in this case 6. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop.cbf")) {
            return "Phase " + phaseName + ":\n" + "\nThe Conditional Branch Folder statically evaluates the \nconditional expression of Jimple if statements. If the \ncondition is identically true or false, the Folder replaces the \nconditional branch statement with an unconditional goto \nstatement. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop.dae")) {
            return "Phase " + phaseName + ":\n" + "\nThe Dead Assignment Eliminator eliminates assignment statements \nto locals whose values are not subsequently used, unless \nevaluating the right-hand side of the assignment may cause \nside-effects. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (false)", "");
        }
        if (phaseName.equals("jop.uce1")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unreachable Code Eliminator removes unreachable code and \ntraps whose catch blocks are empty. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop.ubf1")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unconditional Branch Folder removes unnecessary `goto' \nstatements from a JimpleBody. If a goto statement's target is \nthe next instruction, then the statement is removed. If a \ngoto's target is another goto, with target y, then the first \nstatement's target is changed to y. If some if statement's \ntarget is a goto statement, then the if's target can be replaced \nwith the goto's target. (These situations can result from other \noptimizations, and branch folding may itself generate more \nunreachable code.)" + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop.uce2")) {
            return "Phase " + phaseName + ":\n" + "\nAnother iteration of the Unreachable Code Eliminator. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop.ubf2")) {
            return "Phase " + phaseName + ":\n" + "\nAnother iteration of the Unconditional Branch Folder. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jop.ule")) {
            return "Phase " + phaseName + ":\n" + "\nThe Unused Local Eliminator phase removes any unused locals \nfrom the method. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jap")) {
            return "Phase " + phaseName + ":\n" + "\nThe Jimple Annotation Pack contains phases which add \nannotations to Jimple bodies individually (as opposed to the \nWhole-Jimple Annotation Pack, which adds annotations based on \nthe analysis of the whole program). " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("jap.npc")) {
            return "Phase " + phaseName + ":\n" + "\nThe Null Pointer Checker finds instruction which have the \npotential to throw NullPointerExceptions and adds annotations \nindicating whether or not the pointer being dereferenced can be \ndetermined statically not to be null. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("only-array-ref (false)", "Annotate only array references") + this.padOpt("profiling (false)", "Insert instructions to count safe pointer accesses");
        }
        if (phaseName.equals("jap.npcolorer")) {
            return "Phase " + phaseName + ":\n" + "\nProduce colour tags that the Soot plug-in for Eclipse can use \nto highlight null and non-null references. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("jap.abc")) {
            return "Phase " + phaseName + ":\n" + "\nThe Array Bound Checker performs a static analysis to determine \nwhich array bounds checks may safely be eliminated and then \nannotates statements with the results of the analysis. If Soot \nis in whole-program mode, the Array Bound Checker can use the \nresults provided by the Rectangular Array Finder." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("with-all (false)", "") + this.padOpt("with-cse (false)", "") + this.padOpt("with-arrayref (false)", "") + this.padOpt("with-fieldref (false)", "") + this.padOpt("with-classfield (false)", "") + this.padOpt("with-rectarray (false)", "") + this.padOpt("profiling (false)", "Profile the results of array bounds check analysis.") + this.padOpt("add-color-tags (false)", "Add color tags to results of array bound check analysis.");
        }
        if (phaseName.equals("jap.profiling")) {
            return "Phase " + phaseName + ":\n" + "\nThe Profiling Generator inserts the method invocations required \nto initialize and to report the results of any profiling \nperformed by the Null Pointer Checker and Array Bound Checker. \nUsers of the Profiling Generator must provide a MultiCounter \nclass implementing the methods invoked. For details, see the \nProfilingGenerator source code. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("notmainentry (false)", "Instrument runBenchmark() instead of main()");
        }
        if (phaseName.equals("jap.sea")) {
            return "Phase " + phaseName + ":\n" + "\nThe Side Effect Tagger uses the active invoke graph to produce \nside-effect attributes, as described in the Spark thesis, \nchapter 6." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("naive (false)", "");
        }
        if (phaseName.equals("jap.fieldrw")) {
            return "Phase " + phaseName + ":\n" + "\nThe Field Read/Write Tagger uses the active invoke graph to \nproduce tags indicating which fields may be read or written by \neach statement, including invoke statements." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "") + this.padOpt("threshold (100)", "");
        }
        if (phaseName.equals("jap.cgtagger")) {
            return "Phase " + phaseName + ":\n" + "\nThe Call Graph Tagger produces LinkTags based on the call \ngraph. The Eclipse plugin uses these tags to produce linked \npopup lists which indicate the source and target methods of the \nstatement. Selecting a link from the list moves the cursor to \nthe indicated method. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("jap.parity")) {
            return "Phase " + phaseName + ":\n" + "\nThe Parity Tagger produces StringTags and ColorTags indicating \nthe parity of a variable (even, odd, top, or bottom). The \neclipse plugin can use tooltips and variable colouring to \ndisplay the information in these tags. For example, even \nvariables (such as x in x = 2) are coloured yellow. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("jap.pat")) {
            return "Phase " + phaseName + ":\n" + "\nFor each method with parameters of reference type, this tagger \nindicates the aliasing relationships between the parameters \nusing colour tags. Parameters that may be aliased are the same \ncolour. Parameters that may not be aliased are in different \ncolours." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("jap.rdtagger")) {
            return "Phase " + phaseName + ":\n" + "\nFor each use of a local in a stmt creates a link to the reaching \ndef." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("gb")) {
            return "Phase " + phaseName + ":\n" + "\nThe Grimp Body Creation phase creates a GrimpBody for each \nsource method. It is run only if the output format is grimp or \ngrimple, or if class files are being output and the Via Grimp \noption has been specified. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("gb.a1")) {
            return "Phase " + phaseName + ":\n" + "\nThe Grimp Pre-folding Aggregator combines some local variables, \nfinding definitions with only a single use and removing the \ndefinition after replacing the use with the definition's \nright-hand side, if it is safe to do so. While the mechanism is \nthe same as that employed by the Jimple Local Aggregator, there \nis more scope for aggregation because of Grimp's more \ncomplicated expressions. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("gb.cf")) {
            return "Phase " + phaseName + ":\n" + "\nThe Grimp Constructor Folder combines new statements with the \nspecialinvoke statement that calls the new object's constructor. \nFor example, it turns r2 = new java.util.ArrayList; r2.init(); \ninto r2 = new java.util.ArrayList(); " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("gb.a2")) {
            return "Phase " + phaseName + ":\n" + "\nThe Grimp Post-folding Aggregator combines local variables \nafter constructors have been folded. Constructor folding \ntypically introduces new opportunities for aggregation, since \nwhen a sequence of instructions like r2 = new \njava.util.ArrayList; r2.init(); r3 = r2 is replaced by r2 = new \njava.util.ArrayList(); r3 = r2 the invocation of init no longer \nrepresents a potential side-effect separating the two \ndefinitions, so they can be combined into r3 = new \njava.util.ArrayList(); (assuming there are no subsequent uses of \nr2). " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("only-stack-locals (true)", "");
        }
        if (phaseName.equals("gb.ule")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase removes any locals that are unused after constructor \nfolding and aggregation. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("gop")) {
            return "Phase " + phaseName + ":\n" + "\nThe Grimp Optimization pack performs optimizations on \nGrimpBodys (currently there are no optimizations performed \nspecifically on GrimpBodys, and the pack is empty). It is run \nonly if the output format is grimp or grimple, or if class files \nare being output and the Via Grimp option has been specified. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("bb")) {
            return "Phase " + phaseName + ":\n" + "\nThe Baf Body Creation phase creates a BafBody from each source \nmethod. It is run if the output format is baf or b, or if class \nfiles are being output and the Via Grimp option has not been \nspecified. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("bb.lso")) {
            return "Phase " + phaseName + ":\n" + "\nThe Load Store Optimizer replaces some combinations of loads to \nand stores from local variables with stack instructions. A \nsimple example would be the replacement of store.r $r2; load.r \n$r2; with dup1.r in cases where the value of r2 is not used \nsubsequently. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("debug (false)", "") + this.padOpt("inter (false)", "") + this.padOpt("sl (true)", "") + this.padOpt("sl2 (false)", "") + this.padOpt("sll (true)", "") + this.padOpt("sll2 (false)", "");
        }
        if (phaseName.equals("bb.pho")) {
            return "Phase " + phaseName + ":\n" + "\nApplies peephole optimizations to the Baf intermediate \nrepresentation. Individual optimizations must be implemented by \nclasses implementing the Peephole interface. The Peephole \nOptimizer reads the names of the Peephole classes at runtime \nfrom the file peephole.dat and loads them dynamically. Then it \ncontinues to apply the Peepholes repeatedly until none of them \nare able to perform any further optimizations. Soot provides \nonly one Peephole, named ExamplePeephole, which is not enabled \nby the delivered peephole.dat file. ExamplePeephole removes all \ncheckcast instructions." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("bb.ule")) {
            return "Phase " + phaseName + ":\n" + "\nThis phase removes any locals that are unused after load store \noptimization and peephole optimization. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("bb.lp")) {
            return "Phase " + phaseName + ":\n" + "\nThe Local Packer attempts to minimize the number of local \nvariables required in a method by reusing the same variable for \ndisjoint DU-UD webs. Conceptually, it is the inverse of the \nLocal Splitter. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "") + this.padOpt("unsplit-original-locals (false)", "");
        }
        if (phaseName.equals("bop")) {
            return "Phase " + phaseName + ":\n" + "\nThe Baf Optimization pack performs optimizations on BafBodys \n(currently there are no optimizations performed specifically on \nBafBodys, and the pack is empty). It is run only if the output \nformat is baf or b, or if class files are being output and the \nVia Grimp option has not been specified. " + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("tag")) {
            return "Phase " + phaseName + ":\n" + "\nThe Tag Aggregator pack aggregates tags attached to individual \nunits into a code attribute for each method, so that these \nattributes can be encoded in Java class files." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (true)", "");
        }
        if (phaseName.equals("tag.ln")) {
            return "Phase " + phaseName + ":\n" + "\nThe Line Number Tag Aggregator aggregates line number tags." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("tag.an")) {
            return "Phase " + phaseName + ":\n" + "\nThe Array Bounds and Null Pointer Tag Aggregator aggregates \ntags produced by the Array Bound Checker and Null Pointer \nChecker." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("tag.dep")) {
            return "Phase " + phaseName + ":\n" + "\nThe Dependence Tag Aggregator aggregates tags produced by the \nSide Effect Tagger." + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        if (phaseName.equals("tag.fieldrw")) {
            return "Phase " + phaseName + ":\n" + "\nThe Field Read/Write Tag Aggregator aggregates field read/write \ntags produced by the Field Read/Write Tagger, phase jap.fieldrw. \n" + "\n\nRecognized options (with default values):\n" + this.padOpt("enabled (false)", "");
        }
        return "Unrecognized phase: " + phaseName;
    }

    public static String getDeclaredOptionsForPhase(String phaseName) {
        if (phaseName.equals("jb")) {
            return "enabled use-original-names ";
        }
        if (phaseName.equals("jb.ls")) {
            return "enabled ";
        }
        if (phaseName.equals("jb.a")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jb.ule")) {
            return "enabled ";
        }
        if (phaseName.equals("jb.tr")) {
            return "enabled ";
        }
        if (phaseName.equals("jb.ulp")) {
            return "enabled unsplit-original-locals ";
        }
        if (phaseName.equals("jb.lns")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jb.cp")) {
            return "enabled only-regular-locals only-stack-locals ";
        }
        if (phaseName.equals("jb.dae")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jb.cp-ule")) {
            return "enabled ";
        }
        if (phaseName.equals("jb.lp")) {
            return "enabled unsplit-original-locals ";
        }
        if (phaseName.equals("jb.ne")) {
            return "enabled ";
        }
        if (phaseName.equals("jb.uce")) {
            return "enabled ";
        }
        if (phaseName.equals("jj")) {
            return "enabled use-original-names ";
        }
        if (phaseName.equals("jj.ls")) {
            return "enabled ";
        }
        if (phaseName.equals("jj.a")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jj.ule")) {
            return "enabled ";
        }
        if (phaseName.equals("jj.tr")) {
            return "enabled ";
        }
        if (phaseName.equals("jj.ulp")) {
            return "enabled unsplit-original-locals ";
        }
        if (phaseName.equals("jj.lns")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jj.cp")) {
            return "enabled only-regular-locals only-stack-locals ";
        }
        if (phaseName.equals("jj.dae")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jj.cp-ule")) {
            return "enabled ";
        }
        if (phaseName.equals("jj.lp")) {
            return "enabled unsplit-original-locals ";
        }
        if (phaseName.equals("jj.ne")) {
            return "enabled ";
        }
        if (phaseName.equals("jj.uce")) {
            return "enabled ";
        }
        if (phaseName.equals("cg")) {
            return "enabled safe-forname safe-newinstance verbose all-reachable trim-clinit context ";
        }
        if (phaseName.equals("cg.cha")) {
            return "enabled verbose ";
        }
        if (phaseName.equals("cg.spark")) {
            return "enabled verbose ignore-types force-gc pre-jimplify vta rta field-based types-for-sites merge-stringbuffer string-constants simulate-natives simple-edges-bidirectional on-fly-cg simplify-offline simplify-sccs ignore-types-for-sccs propagator set-impl double-set-old double-set-new dump-html dump-pag dump-solution topo-sort dump-types class-method-var dump-answer add-tags set-mass ";
        }
        if (phaseName.equals("cg.bdd")) {
            return "enabled verbose ignore-types force-gc pre-jimplify vta rta field-based types-for-sites merge-stringbuffer string-constants simulate-natives simple-edges-bidirectional on-fly-cg simplify-offline simplify-sccs ignore-types-for-sccs dump-html dump-pag dump-solution topo-sort dump-types class-method-var dump-answer add-tags set-mass ";
        }
        if (phaseName.equals("wstp")) {
            return "enabled ";
        }
        if (phaseName.equals("wsop")) {
            return "enabled ";
        }
        if (phaseName.equals("wjtp")) {
            return "enabled ";
        }
        if (phaseName.equals("wjop")) {
            return "enabled ";
        }
        if (phaseName.equals("wjop.smb")) {
            return "enabled insert-null-checks insert-redundant-casts allowed-modifier-changes ";
        }
        if (phaseName.equals("wjop.si")) {
            return "enabled rerun-jb insert-null-checks insert-redundant-casts allowed-modifier-changes expansion-factor max-container-size max-inlinee-size ";
        }
        if (phaseName.equals("wjap")) {
            return "enabled ";
        }
        if (phaseName.equals("wjap.ra")) {
            return "enabled ";
        }
        if (phaseName.equals("wjap.umt")) {
            return "enabled ";
        }
        if (phaseName.equals("wjap.uft")) {
            return "enabled ";
        }
        if (phaseName.equals("wjap.tqt")) {
            return "enabled ";
        }
        if (phaseName.equals("shimple")) {
            return "enabled phi-elim-opt standard-local-names debug ";
        }
        if (phaseName.equals("stp")) {
            return "enabled ";
        }
        if (phaseName.equals("sop")) {
            return "enabled ";
        }
        if (phaseName.equals("sop.cpf")) {
            return "enabled prune-cfg ";
        }
        if (phaseName.equals("jtp")) {
            return "enabled ";
        }
        if (phaseName.equals("jop")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.cse")) {
            return "enabled naive-side-effect ";
        }
        if (phaseName.equals("jop.bcm")) {
            return "enabled naive-side-effect ";
        }
        if (phaseName.equals("jop.lcm")) {
            return "enabled safety unroll naive-side-effect ";
        }
        if (phaseName.equals("jop.cp")) {
            return "enabled only-regular-locals only-stack-locals ";
        }
        if (phaseName.equals("jop.cpf")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.cbf")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.dae")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("jop.uce1")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.ubf1")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.uce2")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.ubf2")) {
            return "enabled ";
        }
        if (phaseName.equals("jop.ule")) {
            return "enabled ";
        }
        if (phaseName.equals("jap")) {
            return "enabled ";
        }
        if (phaseName.equals("jap.npc")) {
            return "enabled only-array-ref profiling ";
        }
        if (phaseName.equals("jap.npcolorer")) {
            return "enabled ";
        }
        if (phaseName.equals("jap.abc")) {
            return "enabled with-all with-cse with-arrayref with-fieldref with-classfield with-rectarray profiling add-color-tags ";
        }
        if (phaseName.equals("jap.profiling")) {
            return "enabled notmainentry ";
        }
        if (phaseName.equals("jap.sea")) {
            return "enabled naive ";
        }
        if (phaseName.equals("jap.fieldrw")) {
            return "enabled threshold ";
        }
        if (phaseName.equals("jap.cgtagger")) {
            return "enabled ";
        }
        if (phaseName.equals("jap.parity")) {
            return "enabled ";
        }
        if (phaseName.equals("jap.pat")) {
            return "enabled ";
        }
        if (phaseName.equals("jap.rdtagger")) {
            return "enabled ";
        }
        if (phaseName.equals("gb")) {
            return "enabled ";
        }
        if (phaseName.equals("gb.a1")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("gb.cf")) {
            return "enabled ";
        }
        if (phaseName.equals("gb.a2")) {
            return "enabled only-stack-locals ";
        }
        if (phaseName.equals("gb.ule")) {
            return "enabled ";
        }
        if (phaseName.equals("gop")) {
            return "enabled ";
        }
        if (phaseName.equals("bb")) {
            return "enabled ";
        }
        if (phaseName.equals("bb.lso")) {
            return "enabled debug inter sl sl2 sll sll2 ";
        }
        if (phaseName.equals("bb.pho")) {
            return "enabled ";
        }
        if (phaseName.equals("bb.ule")) {
            return "enabled ";
        }
        if (phaseName.equals("bb.lp")) {
            return "enabled unsplit-original-locals ";
        }
        if (phaseName.equals("bop")) {
            return "enabled ";
        }
        if (phaseName.equals("tag")) {
            return "enabled ";
        }
        if (phaseName.equals("tag.ln")) {
            return "enabled ";
        }
        if (phaseName.equals("tag.an")) {
            return "enabled ";
        }
        if (phaseName.equals("tag.dep")) {
            return "enabled ";
        }
        if (phaseName.equals("tag.fieldrw")) {
            return "enabled ";
        }
        return "enabled";
    }

    public static String getDefaultOptionsForPhase(String phaseName) {
        if (phaseName.equals("jb")) {
            return "enabled:true use-original-names:false ";
        }
        if (phaseName.equals("jb.ls")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jb.a")) {
            return "enabled:true only-stack-locals:true ";
        }
        if (phaseName.equals("jb.ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jb.tr")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jb.ulp")) {
            return "enabled:true unsplit-original-locals:true ";
        }
        if (phaseName.equals("jb.lns")) {
            return "enabled:true only-stack-locals:false ";
        }
        if (phaseName.equals("jb.cp")) {
            return "enabled:true only-regular-locals:false only-stack-locals:true ";
        }
        if (phaseName.equals("jb.dae")) {
            return "enabled:true only-stack-locals:true ";
        }
        if (phaseName.equals("jb.cp-ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jb.lp")) {
            return "enabled:false unsplit-original-locals:false ";
        }
        if (phaseName.equals("jb.ne")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jb.uce")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jj")) {
            return "enabled:true use-original-names:true ";
        }
        if (phaseName.equals("jj.ls")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jj.a")) {
            return "enabled:true only-stack-locals:true ";
        }
        if (phaseName.equals("jj.ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jj.tr")) {
            return "enabled:false ";
        }
        if (phaseName.equals("jj.ulp")) {
            return "enabled:false unsplit-original-locals:false ";
        }
        if (phaseName.equals("jj.lns")) {
            return "enabled:true only-stack-locals:false ";
        }
        if (phaseName.equals("jj.cp")) {
            return "enabled:true only-regular-locals:false only-stack-locals:true ";
        }
        if (phaseName.equals("jj.dae")) {
            return "enabled:true only-stack-locals:true ";
        }
        if (phaseName.equals("jj.cp-ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jj.lp")) {
            return "enabled:false unsplit-original-locals:false ";
        }
        if (phaseName.equals("jj.ne")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jj.uce")) {
            return "enabled:true ";
        }
        if (phaseName.equals("cg")) {
            return "enabled:true safe-forname:true safe-newinstance:true verbose:false all-reachable:false trim-clinit:true context:insens ";
        }
        if (phaseName.equals("cg.cha")) {
            return "enabled:true verbose:false ";
        }
        if (phaseName.equals("cg.spark")) {
            return "enabled:false verbose:false ignore-types:false force-gc:false pre-jimplify:false vta:false rta:false field-based:false types-for-sites:false merge-stringbuffer:true string-constants:false simulate-natives:true simple-edges-bidirectional:false on-fly-cg:true simplify-offline:false simplify-sccs:false ignore-types-for-sccs:false propagator:worklist set-impl:double double-set-old:hybrid double-set-new:hybrid dump-html:false dump-pag:false dump-solution:false topo-sort:false dump-types:true class-method-var:true dump-answer:false add-tags:false set-mass:false ";
        }
        if (phaseName.equals("cg.bdd")) {
            return "enabled:false verbose:false ignore-types:false force-gc:false pre-jimplify:false vta:false rta:false field-based:false types-for-sites:false merge-stringbuffer:true string-constants:false simulate-natives:true simple-edges-bidirectional:false on-fly-cg:true simplify-offline:false simplify-sccs:false ignore-types-for-sccs:false dump-html:false dump-pag:false dump-solution:false topo-sort:false dump-types:true class-method-var:true dump-answer:false add-tags:false set-mass:false ";
        }
        if (phaseName.equals("wstp")) {
            return "enabled:true ";
        }
        if (phaseName.equals("wsop")) {
            return "enabled:false ";
        }
        if (phaseName.equals("wjtp")) {
            return "enabled:true ";
        }
        if (phaseName.equals("wjop")) {
            return "enabled:false ";
        }
        if (phaseName.equals("wjop.smb")) {
            return "enabled:false insert-null-checks:true insert-redundant-casts:true allowed-modifier-changes:unsafe ";
        }
        if (phaseName.equals("wjop.si")) {
            return "enabled:true rerun-jb:true insert-null-checks:true insert-redundant-casts:true allowed-modifier-changes:unsafe expansion-factor:3 max-container-size:5000 max-inlinee-size:20 ";
        }
        if (phaseName.equals("wjap")) {
            return "enabled:true ";
        }
        if (phaseName.equals("wjap.ra")) {
            return "enabled:false ";
        }
        if (phaseName.equals("wjap.umt")) {
            return "enabled:false ";
        }
        if (phaseName.equals("wjap.uft")) {
            return "enabled:false ";
        }
        if (phaseName.equals("wjap.tqt")) {
            return "enabled:false ";
        }
        if (phaseName.equals("shimple")) {
            return "enabled:true phi-elim-opt:post standard-local-names:false debug:false ";
        }
        if (phaseName.equals("stp")) {
            return "enabled:true ";
        }
        if (phaseName.equals("sop")) {
            return "enabled:false ";
        }
        if (phaseName.equals("sop.cpf")) {
            return "enabled:true prune-cfg:true ";
        }
        if (phaseName.equals("jtp")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop")) {
            return "enabled:false ";
        }
        if (phaseName.equals("jop.cse")) {
            return "enabled:false naive-side-effect:false ";
        }
        if (phaseName.equals("jop.bcm")) {
            return "enabled:false naive-side-effect:false ";
        }
        if (phaseName.equals("jop.lcm")) {
            return "enabled:false safety:safe unroll:true naive-side-effect:false ";
        }
        if (phaseName.equals("jop.cp")) {
            return "enabled:true only-regular-locals:false only-stack-locals:false ";
        }
        if (phaseName.equals("jop.cpf")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop.cbf")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop.dae")) {
            return "enabled:true only-stack-locals:false ";
        }
        if (phaseName.equals("jop.uce1")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop.ubf1")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop.uce2")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop.ubf2")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jop.ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jap")) {
            return "enabled:true ";
        }
        if (phaseName.equals("jap.npc")) {
            return "enabled:false only-array-ref:false profiling:false ";
        }
        if (phaseName.equals("jap.npcolorer")) {
            return "enabled:false ";
        }
        if (phaseName.equals("jap.abc")) {
            return "enabled:false with-all:false with-cse:false with-arrayref:false with-fieldref:false with-classfield:false with-rectarray:false profiling:false add-color-tags:false ";
        }
        if (phaseName.equals("jap.profiling")) {
            return "enabled:false notmainentry:false ";
        }
        if (phaseName.equals("jap.sea")) {
            return "enabled:false naive:false ";
        }
        if (phaseName.equals("jap.fieldrw")) {
            return "enabled:false threshold:100 ";
        }
        if (phaseName.equals("jap.cgtagger")) {
            return "enabled:false ";
        }
        if (phaseName.equals("jap.parity")) {
            return "enabled:false ";
        }
        if (phaseName.equals("jap.pat")) {
            return "enabled:false ";
        }
        if (phaseName.equals("jap.rdtagger")) {
            return "enabled:false ";
        }
        if (phaseName.equals("gb")) {
            return "enabled:true ";
        }
        if (phaseName.equals("gb.a1")) {
            return "enabled:true only-stack-locals:true ";
        }
        if (phaseName.equals("gb.cf")) {
            return "enabled:true ";
        }
        if (phaseName.equals("gb.a2")) {
            return "enabled:true only-stack-locals:true ";
        }
        if (phaseName.equals("gb.ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("gop")) {
            return "enabled:false ";
        }
        if (phaseName.equals("bb")) {
            return "enabled:true ";
        }
        if (phaseName.equals("bb.lso")) {
            return "enabled:true debug:false inter:false sl:true sl2:false sll:true sll2:false ";
        }
        if (phaseName.equals("bb.pho")) {
            return "enabled:true ";
        }
        if (phaseName.equals("bb.ule")) {
            return "enabled:true ";
        }
        if (phaseName.equals("bb.lp")) {
            return "enabled:true unsplit-original-locals:false ";
        }
        if (phaseName.equals("bop")) {
            return "enabled:false ";
        }
        if (phaseName.equals("tag")) {
            return "enabled:true ";
        }
        if (phaseName.equals("tag.ln")) {
            return "enabled:false ";
        }
        if (phaseName.equals("tag.an")) {
            return "enabled:false ";
        }
        if (phaseName.equals("tag.dep")) {
            return "enabled:false ";
        }
        if (phaseName.equals("tag.fieldrw")) {
            return "enabled:false ";
        }
        return "enabled";
    }

    public void warnForeignPhase(String phaseName) {
        if (phaseName.equals("jb")) {
            return;
        }
        if (phaseName.equals("jb.ls")) {
            return;
        }
        if (phaseName.equals("jb.a")) {
            return;
        }
        if (phaseName.equals("jb.ule")) {
            return;
        }
        if (phaseName.equals("jb.tr")) {
            return;
        }
        if (phaseName.equals("jb.ulp")) {
            return;
        }
        if (phaseName.equals("jb.lns")) {
            return;
        }
        if (phaseName.equals("jb.cp")) {
            return;
        }
        if (phaseName.equals("jb.dae")) {
            return;
        }
        if (phaseName.equals("jb.cp-ule")) {
            return;
        }
        if (phaseName.equals("jb.lp")) {
            return;
        }
        if (phaseName.equals("jb.ne")) {
            return;
        }
        if (phaseName.equals("jb.uce")) {
            return;
        }
        if (phaseName.equals("jj")) {
            return;
        }
        if (phaseName.equals("jj.ls")) {
            return;
        }
        if (phaseName.equals("jj.a")) {
            return;
        }
        if (phaseName.equals("jj.ule")) {
            return;
        }
        if (phaseName.equals("jj.tr")) {
            return;
        }
        if (phaseName.equals("jj.ulp")) {
            return;
        }
        if (phaseName.equals("jj.lns")) {
            return;
        }
        if (phaseName.equals("jj.cp")) {
            return;
        }
        if (phaseName.equals("jj.dae")) {
            return;
        }
        if (phaseName.equals("jj.cp-ule")) {
            return;
        }
        if (phaseName.equals("jj.lp")) {
            return;
        }
        if (phaseName.equals("jj.ne")) {
            return;
        }
        if (phaseName.equals("jj.uce")) {
            return;
        }
        if (phaseName.equals("cg")) {
            return;
        }
        if (phaseName.equals("cg.cha")) {
            return;
        }
        if (phaseName.equals("cg.spark")) {
            return;
        }
        if (phaseName.equals("cg.bdd")) {
            return;
        }
        if (phaseName.equals("wstp")) {
            return;
        }
        if (phaseName.equals("wsop")) {
            return;
        }
        if (phaseName.equals("wjtp")) {
            return;
        }
        if (phaseName.equals("wjop")) {
            return;
        }
        if (phaseName.equals("wjop.smb")) {
            return;
        }
        if (phaseName.equals("wjop.si")) {
            return;
        }
        if (phaseName.equals("wjap")) {
            return;
        }
        if (phaseName.equals("wjap.ra")) {
            return;
        }
        if (phaseName.equals("wjap.umt")) {
            return;
        }
        if (phaseName.equals("wjap.uft")) {
            return;
        }
        if (phaseName.equals("wjap.tqt")) {
            return;
        }
        if (phaseName.equals("shimple")) {
            return;
        }
        if (phaseName.equals("stp")) {
            return;
        }
        if (phaseName.equals("sop")) {
            return;
        }
        if (phaseName.equals("sop.cpf")) {
            return;
        }
        if (phaseName.equals("jtp")) {
            return;
        }
        if (phaseName.equals("jop")) {
            return;
        }
        if (phaseName.equals("jop.cse")) {
            return;
        }
        if (phaseName.equals("jop.bcm")) {
            return;
        }
        if (phaseName.equals("jop.lcm")) {
            return;
        }
        if (phaseName.equals("jop.cp")) {
            return;
        }
        if (phaseName.equals("jop.cpf")) {
            return;
        }
        if (phaseName.equals("jop.cbf")) {
            return;
        }
        if (phaseName.equals("jop.dae")) {
            return;
        }
        if (phaseName.equals("jop.uce1")) {
            return;
        }
        if (phaseName.equals("jop.ubf1")) {
            return;
        }
        if (phaseName.equals("jop.uce2")) {
            return;
        }
        if (phaseName.equals("jop.ubf2")) {
            return;
        }
        if (phaseName.equals("jop.ule")) {
            return;
        }
        if (phaseName.equals("jap")) {
            return;
        }
        if (phaseName.equals("jap.npc")) {
            return;
        }
        if (phaseName.equals("jap.npcolorer")) {
            return;
        }
        if (phaseName.equals("jap.abc")) {
            return;
        }
        if (phaseName.equals("jap.profiling")) {
            return;
        }
        if (phaseName.equals("jap.sea")) {
            return;
        }
        if (phaseName.equals("jap.fieldrw")) {
            return;
        }
        if (phaseName.equals("jap.cgtagger")) {
            return;
        }
        if (phaseName.equals("jap.parity")) {
            return;
        }
        if (phaseName.equals("jap.pat")) {
            return;
        }
        if (phaseName.equals("jap.rdtagger")) {
            return;
        }
        if (phaseName.equals("gb")) {
            return;
        }
        if (phaseName.equals("gb.a1")) {
            return;
        }
        if (phaseName.equals("gb.cf")) {
            return;
        }
        if (phaseName.equals("gb.a2")) {
            return;
        }
        if (phaseName.equals("gb.ule")) {
            return;
        }
        if (phaseName.equals("gop")) {
            return;
        }
        if (phaseName.equals("bb")) {
            return;
        }
        if (phaseName.equals("bb.lso")) {
            return;
        }
        if (phaseName.equals("bb.pho")) {
            return;
        }
        if (phaseName.equals("bb.ule")) {
            return;
        }
        if (phaseName.equals("bb.lp")) {
            return;
        }
        if (phaseName.equals("bop")) {
            return;
        }
        if (phaseName.equals("tag")) {
            return;
        }
        if (phaseName.equals("tag.ln")) {
            return;
        }
        if (phaseName.equals("tag.an")) {
            return;
        }
        if (phaseName.equals("tag.dep")) {
            return;
        }
        if (phaseName.equals("tag.fieldrw")) {
            return;
        }
        G.v().out.println("Warning: Phase " + phaseName + " is not a standard Soot phase listed in XML files.");
    }

    public void warnNonexistentPhase() {
        if (!PackManager.v().hasPhase("jb")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb");
        }
        if (!PackManager.v().hasPhase("jb.ls")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.ls");
        }
        if (!PackManager.v().hasPhase("jb.a")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.a");
        }
        if (!PackManager.v().hasPhase("jb.ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.ule");
        }
        if (!PackManager.v().hasPhase("jb.tr")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.tr");
        }
        if (!PackManager.v().hasPhase("jb.ulp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.ulp");
        }
        if (!PackManager.v().hasPhase("jb.lns")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.lns");
        }
        if (!PackManager.v().hasPhase("jb.cp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.cp");
        }
        if (!PackManager.v().hasPhase("jb.dae")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.dae");
        }
        if (!PackManager.v().hasPhase("jb.cp-ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.cp-ule");
        }
        if (!PackManager.v().hasPhase("jb.lp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.lp");
        }
        if (!PackManager.v().hasPhase("jb.ne")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.ne");
        }
        if (!PackManager.v().hasPhase("jb.uce")) {
            G.v().out.println("Warning: Options exist for non-existent phase jb.uce");
        }
        if (!PackManager.v().hasPhase("jj")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj");
        }
        if (!PackManager.v().hasPhase("jj.ls")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.ls");
        }
        if (!PackManager.v().hasPhase("jj.a")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.a");
        }
        if (!PackManager.v().hasPhase("jj.ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.ule");
        }
        if (!PackManager.v().hasPhase("jj.tr")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.tr");
        }
        if (!PackManager.v().hasPhase("jj.ulp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.ulp");
        }
        if (!PackManager.v().hasPhase("jj.lns")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.lns");
        }
        if (!PackManager.v().hasPhase("jj.cp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.cp");
        }
        if (!PackManager.v().hasPhase("jj.dae")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.dae");
        }
        if (!PackManager.v().hasPhase("jj.cp-ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.cp-ule");
        }
        if (!PackManager.v().hasPhase("jj.lp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.lp");
        }
        if (!PackManager.v().hasPhase("jj.ne")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.ne");
        }
        if (!PackManager.v().hasPhase("jj.uce")) {
            G.v().out.println("Warning: Options exist for non-existent phase jj.uce");
        }
        if (!PackManager.v().hasPhase("cg")) {
            G.v().out.println("Warning: Options exist for non-existent phase cg");
        }
        if (!PackManager.v().hasPhase("cg.cha")) {
            G.v().out.println("Warning: Options exist for non-existent phase cg.cha");
        }
        if (!PackManager.v().hasPhase("cg.spark")) {
            G.v().out.println("Warning: Options exist for non-existent phase cg.spark");
        }
        if (!PackManager.v().hasPhase("cg.bdd")) {
            G.v().out.println("Warning: Options exist for non-existent phase cg.bdd");
        }
        if (!PackManager.v().hasPhase("wstp")) {
            G.v().out.println("Warning: Options exist for non-existent phase wstp");
        }
        if (!PackManager.v().hasPhase("wsop")) {
            G.v().out.println("Warning: Options exist for non-existent phase wsop");
        }
        if (!PackManager.v().hasPhase("wjtp")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjtp");
        }
        if (!PackManager.v().hasPhase("wjop")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjop");
        }
        if (!PackManager.v().hasPhase("wjop.smb")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjop.smb");
        }
        if (!PackManager.v().hasPhase("wjop.si")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjop.si");
        }
        if (!PackManager.v().hasPhase("wjap")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjap");
        }
        if (!PackManager.v().hasPhase("wjap.ra")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjap.ra");
        }
        if (!PackManager.v().hasPhase("wjap.umt")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjap.umt");
        }
        if (!PackManager.v().hasPhase("wjap.uft")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjap.uft");
        }
        if (!PackManager.v().hasPhase("wjap.tqt")) {
            G.v().out.println("Warning: Options exist for non-existent phase wjap.tqt");
        }
        if (!PackManager.v().hasPhase("shimple")) {
            G.v().out.println("Warning: Options exist for non-existent phase shimple");
        }
        if (!PackManager.v().hasPhase("stp")) {
            G.v().out.println("Warning: Options exist for non-existent phase stp");
        }
        if (!PackManager.v().hasPhase("sop")) {
            G.v().out.println("Warning: Options exist for non-existent phase sop");
        }
        if (!PackManager.v().hasPhase("sop.cpf")) {
            G.v().out.println("Warning: Options exist for non-existent phase sop.cpf");
        }
        if (!PackManager.v().hasPhase("jtp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jtp");
        }
        if (!PackManager.v().hasPhase("jop")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop");
        }
        if (!PackManager.v().hasPhase("jop.cse")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.cse");
        }
        if (!PackManager.v().hasPhase("jop.bcm")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.bcm");
        }
        if (!PackManager.v().hasPhase("jop.lcm")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.lcm");
        }
        if (!PackManager.v().hasPhase("jop.cp")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.cp");
        }
        if (!PackManager.v().hasPhase("jop.cpf")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.cpf");
        }
        if (!PackManager.v().hasPhase("jop.cbf")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.cbf");
        }
        if (!PackManager.v().hasPhase("jop.dae")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.dae");
        }
        if (!PackManager.v().hasPhase("jop.uce1")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.uce1");
        }
        if (!PackManager.v().hasPhase("jop.ubf1")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.ubf1");
        }
        if (!PackManager.v().hasPhase("jop.uce2")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.uce2");
        }
        if (!PackManager.v().hasPhase("jop.ubf2")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.ubf2");
        }
        if (!PackManager.v().hasPhase("jop.ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase jop.ule");
        }
        if (!PackManager.v().hasPhase("jap")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap");
        }
        if (!PackManager.v().hasPhase("jap.npc")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.npc");
        }
        if (!PackManager.v().hasPhase("jap.npcolorer")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.npcolorer");
        }
        if (!PackManager.v().hasPhase("jap.abc")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.abc");
        }
        if (!PackManager.v().hasPhase("jap.profiling")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.profiling");
        }
        if (!PackManager.v().hasPhase("jap.sea")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.sea");
        }
        if (!PackManager.v().hasPhase("jap.fieldrw")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.fieldrw");
        }
        if (!PackManager.v().hasPhase("jap.cgtagger")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.cgtagger");
        }
        if (!PackManager.v().hasPhase("jap.parity")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.parity");
        }
        if (!PackManager.v().hasPhase("jap.pat")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.pat");
        }
        if (!PackManager.v().hasPhase("jap.rdtagger")) {
            G.v().out.println("Warning: Options exist for non-existent phase jap.rdtagger");
        }
        if (!PackManager.v().hasPhase("gb")) {
            G.v().out.println("Warning: Options exist for non-existent phase gb");
        }
        if (!PackManager.v().hasPhase("gb.a1")) {
            G.v().out.println("Warning: Options exist for non-existent phase gb.a1");
        }
        if (!PackManager.v().hasPhase("gb.cf")) {
            G.v().out.println("Warning: Options exist for non-existent phase gb.cf");
        }
        if (!PackManager.v().hasPhase("gb.a2")) {
            G.v().out.println("Warning: Options exist for non-existent phase gb.a2");
        }
        if (!PackManager.v().hasPhase("gb.ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase gb.ule");
        }
        if (!PackManager.v().hasPhase("gop")) {
            G.v().out.println("Warning: Options exist for non-existent phase gop");
        }
        if (!PackManager.v().hasPhase("bb")) {
            G.v().out.println("Warning: Options exist for non-existent phase bb");
        }
        if (!PackManager.v().hasPhase("bb.lso")) {
            G.v().out.println("Warning: Options exist for non-existent phase bb.lso");
        }
        if (!PackManager.v().hasPhase("bb.pho")) {
            G.v().out.println("Warning: Options exist for non-existent phase bb.pho");
        }
        if (!PackManager.v().hasPhase("bb.ule")) {
            G.v().out.println("Warning: Options exist for non-existent phase bb.ule");
        }
        if (!PackManager.v().hasPhase("bb.lp")) {
            G.v().out.println("Warning: Options exist for non-existent phase bb.lp");
        }
        if (!PackManager.v().hasPhase("bop")) {
            G.v().out.println("Warning: Options exist for non-existent phase bop");
        }
        if (!PackManager.v().hasPhase("tag")) {
            G.v().out.println("Warning: Options exist for non-existent phase tag");
        }
        if (!PackManager.v().hasPhase("tag.ln")) {
            G.v().out.println("Warning: Options exist for non-existent phase tag.ln");
        }
        if (!PackManager.v().hasPhase("tag.an")) {
            G.v().out.println("Warning: Options exist for non-existent phase tag.an");
        }
        if (!PackManager.v().hasPhase("tag.dep")) {
            G.v().out.println("Warning: Options exist for non-existent phase tag.dep");
        }
        if (!PackManager.v().hasPhase("tag.fieldrw")) {
            G.v().out.println("Warning: Options exist for non-existent phase tag.fieldrw");
        }
    }
}

