/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.typing.ClassHierarchy;
import soot.jimple.toolkits.typing.ConstraintChecker;
import soot.jimple.toolkits.typing.ConstraintCollector;
import soot.jimple.toolkits.typing.StronglyConnectedComponents;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeVariable;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;

public class TypeResolver {
    private ClassHierarchy hierarchy;
    private final List typeVariableList = new ArrayList();
    private final Map typeVariableMap = new HashMap();
    private final JimpleBody stmtBody;
    final TypeNode NULL;
    private final TypeNode OBJECT;
    private static final boolean DEBUG = false;
    private List unsolved;
    private List solved;
    private List single_soft_parent;
    private List single_hard_parent;
    private List multiple_parents;
    private List single_child_not_null;
    private List single_null_child;
    private List multiple_children;

    public ClassHierarchy hierarchy() {
        return this.hierarchy;
    }

    public TypeNode typeNode(Type type) {
        return this.hierarchy.typeNode(type);
    }

    TypeVariable typeVariable(Local local) {
        TypeVariable result = (TypeVariable)this.typeVariableMap.get(local);
        if (result == null) {
            int id = this.typeVariableList.size();
            this.typeVariableList.add(null);
            result = new TypeVariable(id, this);
            this.typeVariableList.set(id, result);
            this.typeVariableMap.put(local, result);
        }
        return result;
    }

    public TypeVariable typeVariable(TypeNode typeNode) {
        TypeVariable result = (TypeVariable)this.typeVariableMap.get(typeNode);
        if (result == null) {
            int id = this.typeVariableList.size();
            this.typeVariableList.add(null);
            result = new TypeVariable(id, this, typeNode);
            this.typeVariableList.set(id, result);
            this.typeVariableMap.put(typeNode, result);
        }
        return result;
    }

    public TypeVariable typeVariable(SootClass sootClass) {
        return this.typeVariable(this.hierarchy.typeNode(sootClass.getType()));
    }

    public TypeVariable typeVariable(Type type) {
        return this.typeVariable(this.hierarchy.typeNode(type));
    }

    public TypeVariable typeVariable() {
        int id = this.typeVariableList.size();
        this.typeVariableList.add(null);
        TypeVariable result = new TypeVariable(id, this);
        this.typeVariableList.set(id, result);
        return result;
    }

    private TypeResolver(JimpleBody stmtBody, Scene scene) {
        this.stmtBody = stmtBody;
        this.hierarchy = ClassHierarchy.classHierarchy(scene);
        this.OBJECT = this.hierarchy.OBJECT;
        this.NULL = this.hierarchy.NULL;
        this.typeVariable(this.OBJECT);
        this.typeVariable(this.NULL);
        G.v().getClass();
        this.typeVariable(this.hierarchy.CLONEABLE);
        this.typeVariable(this.hierarchy.SERIALIZABLE);
    }

    public static void resolve(JimpleBody stmtBody, Scene scene) {
        try {
            TypeResolver resolver = new TypeResolver(stmtBody, scene);
            resolver.resolve_step_1();
        }
        catch (TypeException e1) {
            try {
                TypeResolver resolver = new TypeResolver(stmtBody, scene);
                resolver.resolve_step_2();
            }
            catch (TypeException e2) {
                try {
                    TypeResolver resolver = new TypeResolver(stmtBody, scene);
                    resolver.resolve_step_3();
                }
                catch (TypeException e3) {
                    StringWriter st = new StringWriter();
                    PrintWriter pw = new PrintWriter(st);
                    e3.printStackTrace(pw);
                    pw.close();
                    throw new RuntimeException(st.toString());
                }
            }
        }
        soot.jimple.toolkits.typing.integer.TypeResolver.resolve(stmtBody);
    }

    private void debug_vars(String message) {
    }

    private void debug_body() {
    }

    private void resolve_step_1() throws TypeException {
        this.collect_constraints_1_2();
        this.debug_vars("constraints");
        this.compute_array_depth();
        this.propagate_array_constraints();
        this.debug_vars("arrays");
        this.merge_primitive_types();
        this.debug_vars("primitive");
        this.merge_connected_components();
        this.debug_vars("components");
        this.remove_transitive_constraints();
        this.debug_vars("transitive");
        this.merge_single_constraints();
        this.debug_vars("single");
        this.assign_types_1_2();
        this.debug_vars("assign");
        this.check_constraints();
    }

    private void resolve_step_2() throws TypeException {
        this.debug_body();
        this.split_new();
        this.debug_body();
        this.collect_constraints_1_2();
        this.debug_vars("constraints");
        this.compute_array_depth();
        this.propagate_array_constraints();
        this.debug_vars("arrays");
        this.merge_primitive_types();
        this.debug_vars("primitive");
        this.merge_connected_components();
        this.debug_vars("components");
        this.remove_transitive_constraints();
        this.debug_vars("transitive");
        this.merge_single_constraints();
        this.debug_vars("single");
        this.assign_types_1_2();
        this.debug_vars("assign");
        this.check_constraints();
    }

    private void resolve_step_3() throws TypeException {
        this.collect_constraints_3();
        this.compute_approximate_types();
        this.assign_types_3();
        this.check_and_fix_constraints();
    }

    private void collect_constraints_1_2() {
        ConstraintCollector collector = new ConstraintCollector(this, true);
        for (Stmt stmt : this.stmtBody.getUnits()) {
            collector.collect(stmt, this.stmtBody);
        }
    }

    private void collect_constraints_3() {
        ConstraintCollector collector = new ConstraintCollector(this, false);
        for (Stmt stmt : this.stmtBody.getUnits()) {
            collector.collect(stmt, this.stmtBody);
        }
    }

    private void compute_array_depth() throws TypeException {
        this.compute_approximate_types();
        TypeVariable[] vars = new TypeVariable[this.typeVariableList.size()];
        vars = this.typeVariableList.toArray(vars);
        for (int i = 0; i < vars.length; ++i) {
            vars[i].fixDepth();
        }
    }

    private void propagate_array_constraints() {
        int max = 0;
        for (TypeVariable var : this.typeVariableList) {
            int depth = var.depth();
            if (depth <= max) continue;
            max = depth;
        }
        if (max > 1) {
            G.v().getClass();
            this.typeVariable(ArrayType.v(RefType.v("java.lang.Cloneable"), max - 1));
            this.typeVariable(ArrayType.v(RefType.v("java.io.Serializable"), max - 1));
        }
        LinkedList[] lists = new LinkedList[max + 1];
        for (int i = 0; i <= max; ++i) {
            lists[i] = new LinkedList();
        }
        for (TypeVariable var : this.typeVariableList) {
            int depth = var.depth();
            lists[depth].add(var);
        }
        for (int i = max; i >= 0; --i) {
            for (TypeVariable var : this.typeVariableList) {
                var.propagate();
            }
        }
    }

    private void merge_primitive_types() throws TypeException {
        this.compute_solved();
        for (TypeVariable var : this.solved) {
            boolean finished;
            if (!(var.type().type() instanceof IntType) && !(var.type().type() instanceof LongType) && !(var.type().type() instanceof FloatType) && !(var.type().type() instanceof DoubleType)) continue;
            do {
                List children;
                finished = true;
                List parents = var.parents();
                if (parents.size() != 0) {
                    finished = false;
                    for (TypeVariable parent : parents) {
                        var = var.union(parent);
                    }
                }
                if ((children = var.children()).size() == 0) continue;
                finished = false;
                for (TypeVariable child : children) {
                    var = var.union(child);
                }
            } while (!finished);
        }
    }

    private void merge_connected_components() throws TypeException {
        this.refresh_solved();
        LinkedList list = new LinkedList();
        list.addAll(this.solved);
        list.addAll(this.unsolved);
        StronglyConnectedComponents.merge(list);
    }

    private void remove_transitive_constraints() throws TypeException {
        this.refresh_solved();
        LinkedList list = new LinkedList();
        list.addAll(this.solved);
        list.addAll(this.unsolved);
        for (TypeVariable var : list) {
            var.removeIndirectRelations();
        }
    }

    /*
     * Exception decompiling
     */
    private void merge_single_constraints() throws TypeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void assign_types_1_2() throws TypeException {
        for (Local local : this.stmtBody.getLocals()) {
            TypeVariable var = this.typeVariable(local);
            if (var == null) {
                local.setType(RefType.v("java.lang.Object"));
                continue;
            }
            if (var.depth() == 0) {
                if (var.type() == null) {
                    TypeVariable.error("Type Error(5):  Variable without type");
                    continue;
                }
                local.setType(var.type().type());
                continue;
            }
            TypeVariable element = var.element();
            for (int j = 1; j < var.depth(); ++j) {
                element = element.element();
            }
            if (element.type() == null) {
                TypeVariable.error("Type Error(6):  Array variable without base type");
                continue;
            }
            if (element.type().type() instanceof NullType) {
                local.setType(NullType.v());
                continue;
            }
            Type t = element.type().type();
            if (t instanceof IntType) {
                local.setType(var.approx().type());
                continue;
            }
            local.setType(ArrayType.v(t, var.depth()));
        }
    }

    private void assign_types_3() throws TypeException {
        for (Local local : this.stmtBody.getLocals()) {
            TypeVariable var = this.typeVariable(local);
            if (var == null || var.approx() == null || var.approx().type() == null) {
                local.setType(RefType.v("java.lang.Object"));
                continue;
            }
            local.setType(var.approx().type());
        }
    }

    private void check_constraints() throws TypeException {
        ConstraintChecker checker = new ConstraintChecker(this, false);
        Object s = null;
        for (Stmt stmt : this.stmtBody.getUnits()) {
            checker.check(stmt, this.stmtBody);
        }
    }

    private void check_and_fix_constraints() throws TypeException {
        ConstraintChecker checker = new ConstraintChecker(this, true);
        Object s = null;
        PatchingChain units = this.stmtBody.getUnits();
        Stmt[] stmts = new Stmt[units.size()];
        units.toArray(stmts);
        for (int i = 0; i < stmts.length; ++i) {
            Stmt stmt = stmts[i];
            checker.check(stmt, this.stmtBody);
            continue;
        }
    }

    private void compute_approximate_types() throws TypeException {
        TreeSet<TypeVariable> workList = new TreeSet<TypeVariable>();
        for (TypeVariable var : this.typeVariableList) {
            if (var.type() == null) continue;
            workList.add(var);
        }
        TypeVariable.computeApprox(workList);
        for (TypeVariable var : this.typeVariableList) {
            if (var.approx() == this.NULL) {
                var.union(this.typeVariable(this.NULL));
                continue;
            }
            if (var.approx() != null) continue;
            var.union(this.typeVariable(this.NULL));
        }
    }

    private void compute_solved() {
        TreeSet<TypeVariable> unsolved_set = new TreeSet<TypeVariable>();
        TreeSet<TypeVariable> solved_set = new TreeSet<TypeVariable>();
        for (TypeVariable var : this.typeVariableList) {
            if (var.depth() != 0) continue;
            if (var.type() == null) {
                unsolved_set.add(var);
                continue;
            }
            solved_set.add(var);
        }
        this.solved = new LinkedList(solved_set);
        this.unsolved = new LinkedList(unsolved_set);
    }

    private void refresh_solved() throws TypeException {
        TreeSet<TypeVariable> unsolved_set = new TreeSet<TypeVariable>();
        TreeSet<TypeVariable> solved_set = new TreeSet<TypeVariable>(this.solved);
        for (TypeVariable var : this.unsolved) {
            if (var.depth() != 0) continue;
            if (var.type() == null) {
                unsolved_set.add(var);
                continue;
            }
            solved_set.add(var);
        }
        this.solved = new LinkedList(solved_set);
        this.unsolved = new LinkedList(unsolved_set);
    }

    private void categorize() throws TypeException {
        this.refresh_solved();
        this.single_soft_parent = new LinkedList();
        this.single_hard_parent = new LinkedList();
        this.multiple_parents = new LinkedList();
        this.single_child_not_null = new LinkedList();
        this.single_null_child = new LinkedList();
        this.multiple_children = new LinkedList();
        for (TypeVariable var : this.unsolved) {
            List parents = var.parents();
            int size = parents.size();
            if (size == 0) {
                var.addParent(this.typeVariable(this.OBJECT));
                this.single_soft_parent.add(var);
            } else if (size == 1) {
                TypeVariable parent = (TypeVariable)parents.get(0);
                if (parent.type() == null) {
                    this.single_soft_parent.add(var);
                } else {
                    this.single_hard_parent.add(var);
                }
            } else {
                this.multiple_parents.add(var);
            }
            List children = var.children();
            size = children.size();
            if (size == 0) {
                var.addChild(this.typeVariable(this.NULL));
                this.single_null_child.add(var);
                continue;
            }
            if (size == 1) {
                TypeVariable child = (TypeVariable)children.get(0);
                if (child.type() == this.NULL) {
                    this.single_null_child.add(var);
                    continue;
                }
                this.single_child_not_null.add(var);
                continue;
            }
            this.multiple_children.add(var);
        }
    }

    private void validate() throws TypeException {
        for (TypeVariable var : this.solved) {
            try {
                var.validate();
            }
            catch (TypeException e) {
                this.debug_vars("Error while validating");
                throw e;
            }
        }
    }

    private void split_new() {
        CompleteUnitGraph graph = new CompleteUnitGraph(this.stmtBody);
        SimpleLocalDefs defs = new SimpleLocalDefs(graph);
        PatchingChain units = this.stmtBody.getUnits();
        Stmt[] stmts = new Stmt[units.size()];
        units.toArray(stmts);
        block0: for (int i = 0; i < stmts.length; ++i) {
            Stmt stmt2;
            SpecialInvokeExpr special;
            InvokeStmt invoke;
            Stmt stmt = stmts[i];
            if (!(stmt instanceof InvokeStmt) || !((invoke = (InvokeStmt)stmt).getInvokeExpr() instanceof SpecialInvokeExpr) || !(special = (SpecialInvokeExpr)invoke.getInvokeExpr()).getMethod().getName().equals("<init>")) continue;
            List deflist = defs.getDefsOfAt((Local)special.getBase(), invoke);
            while (deflist.size() == 1 && (stmt2 = (Stmt)deflist.get(0)) instanceof AssignStmt) {
                AssignStmt assign = (AssignStmt)stmt2;
                if (assign.getRightOp() instanceof Local) {
                    deflist = defs.getDefsOfAt((Local)assign.getRightOp(), assign);
                    continue;
                }
                if (!(assign.getRightOp() instanceof NewExpr)) continue block0;
                Local newlocal = Jimple.v().newLocal("tmp", null);
                this.stmtBody.getLocals().add(newlocal);
                special.setBase(newlocal);
                units.insertAfter(Jimple.v().newAssignStmt(assign.getLeftOp(), newlocal), (Object)assign);
                assign.setLeftOp(newlocal);
                continue block0;
            }
        }
    }
}

