/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.List;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.SootMethod;
import soot.TrapManager;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.ClassHierarchy;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeResolver;
import soot.jimple.toolkits.typing.TypeVariable;

class ConstraintCollector
extends AbstractStmtSwitch {
    private TypeResolver resolver;
    private ClassHierarchy hierarchy;
    private boolean uses;
    private JimpleBody stmtBody;

    public ConstraintCollector(TypeResolver resolver, boolean uses) {
        this.resolver = resolver;
        this.uses = uses;
        this.hierarchy = resolver.hierarchy();
    }

    public void collect(Stmt stmt, JimpleBody stmtBody) {
        this.stmtBody = stmtBody;
        stmt.apply(this);
    }

    private void handleInvokeExpr(InvokeExpr ie) {
        if (!this.uses) {
            return;
        }
        if (ie instanceof InterfaceInvokeExpr) {
            InterfaceInvokeExpr invoke = (InterfaceInvokeExpr)ie;
            SootMethod method = invoke.getMethod();
            Value base = invoke.getBase();
            if (base instanceof Local) {
                Local local = (Local)base;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getDeclaringClass()));
            }
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                if (!(invoke.getArg(i) instanceof Local)) continue;
                Local local = (Local)invoke.getArg(i);
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getParameterType(i)));
            }
        } else if (ie instanceof SpecialInvokeExpr) {
            SpecialInvokeExpr invoke = (SpecialInvokeExpr)ie;
            SootMethod method = invoke.getMethod();
            Value base = invoke.getBase();
            if (base instanceof Local) {
                Local local = (Local)base;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getDeclaringClass()));
            }
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                if (!(invoke.getArg(i) instanceof Local)) continue;
                Local local = (Local)invoke.getArg(i);
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getParameterType(i)));
            }
        } else if (ie instanceof VirtualInvokeExpr) {
            VirtualInvokeExpr invoke = (VirtualInvokeExpr)ie;
            SootMethod method = invoke.getMethod();
            Value base = invoke.getBase();
            if (base instanceof Local) {
                Local local = (Local)base;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getDeclaringClass()));
            }
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                if (!(invoke.getArg(i) instanceof Local)) continue;
                Local local = (Local)invoke.getArg(i);
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getParameterType(i)));
            }
        } else if (ie instanceof StaticInvokeExpr) {
            StaticInvokeExpr invoke = (StaticInvokeExpr)ie;
            SootMethod method = invoke.getMethod();
            int count = invoke.getArgCount();
            for (int i = 0; i < count; ++i) {
                if (!(invoke.getArg(i) instanceof Local)) continue;
                Local local = (Local)invoke.getArg(i);
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.getParameterType(i)));
            }
        } else {
            throw new RuntimeException("Unhandled invoke expression type: " + ie.getClass());
        }
    }

    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void caseAssignStmt(AssignStmt stmt) {
        TypeVariable var;
        Value size;
        Object baseType;
        TypeVariable baseType2;
        Value index;
        Value base;
        ConcreteRef ref;
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        TypeVariable left = null;
        TypeVariable right = null;
        if (l instanceof ArrayRef) {
            ref = (ArrayRef)l;
            base = ref.getBase();
            index = ref.getIndex();
            baseType2 = this.resolver.typeVariable((Local)base);
            baseType2.makeElement();
            left = baseType2.element();
            if (index instanceof Local && this.uses) {
                this.resolver.typeVariable((Local)index).addParent(this.resolver.typeVariable(IntType.v()));
            }
        } else if (l instanceof Local) {
            left = this.resolver.typeVariable((Local)l);
        } else if (l instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)l;
            if (this.uses) {
                baseType = this.resolver.typeVariable((Local)ref.getBase());
                ((TypeVariable)baseType).addParent(this.resolver.typeVariable(ref.getField().getDeclaringClass()));
                left = this.resolver.typeVariable(ref.getField().getType());
            }
        } else {
            if (!(l instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment left hand side type: " + l.getClass());
            if (this.uses) {
                ref = (StaticFieldRef)l;
                left = this.resolver.typeVariable(((StaticFieldRef)ref).getField().getType());
            }
        }
        if (r instanceof ArrayRef) {
            ref = (ArrayRef)r;
            base = ref.getBase();
            index = ref.getIndex();
            baseType2 = this.resolver.typeVariable((Local)base);
            baseType2.makeElement();
            right = baseType2.element();
            if (index instanceof Local && this.uses) {
                this.resolver.typeVariable((Local)index).addParent(this.resolver.typeVariable(IntType.v()));
            }
        } else if (r instanceof DoubleConstant) {
            right = this.resolver.typeVariable(DoubleType.v());
        } else if (r instanceof FloatConstant) {
            right = this.resolver.typeVariable(FloatType.v());
        } else if (r instanceof IntConstant) {
            right = this.resolver.typeVariable(IntType.v());
        } else if (r instanceof LongConstant) {
            right = this.resolver.typeVariable(LongType.v());
        } else if (r instanceof NullConstant) {
            right = null;
        } else if (r instanceof StringConstant) {
            right = this.resolver.typeVariable(RefType.v("java.lang.String"));
        } else if (r instanceof BinopExpr) {
            TypeVariable rop;
            TypeVariable lop;
            BinopExpr be = (BinopExpr)r;
            Value lv = be.getOp1();
            Value rv = be.getOp2();
            if (lv instanceof Local) {
                lop = this.resolver.typeVariable((Local)lv);
            } else if (lv instanceof DoubleConstant) {
                lop = this.resolver.typeVariable(DoubleType.v());
            } else if (lv instanceof FloatConstant) {
                lop = this.resolver.typeVariable(FloatType.v());
            } else if (lv instanceof IntConstant) {
                lop = this.resolver.typeVariable(IntType.v());
            } else if (lv instanceof LongConstant) {
                lop = this.resolver.typeVariable(LongType.v());
            } else if (lv instanceof NullConstant) {
                lop = this.resolver.typeVariable(NullType.v());
            } else {
                if (!(lv instanceof StringConstant)) throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                lop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            }
            if (rv instanceof Local) {
                rop = this.resolver.typeVariable((Local)rv);
            } else if (rv instanceof DoubleConstant) {
                rop = this.resolver.typeVariable(DoubleType.v());
            } else if (rv instanceof FloatConstant) {
                rop = this.resolver.typeVariable(FloatType.v());
            } else if (rv instanceof IntConstant) {
                rop = this.resolver.typeVariable(IntType.v());
            } else if (rv instanceof LongConstant) {
                rop = this.resolver.typeVariable(LongType.v());
            } else if (rv instanceof NullConstant) {
                rop = this.resolver.typeVariable(NullType.v());
            } else {
                if (!(rv instanceof StringConstant)) throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                rop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            }
            if (be instanceof AddExpr || be instanceof SubExpr || be instanceof MulExpr || be instanceof DivExpr || be instanceof RemExpr || be instanceof AndExpr || be instanceof OrExpr || be instanceof XorExpr) {
                if (this.uses) {
                    TypeVariable common = this.resolver.typeVariable();
                    rop.addParent(common);
                    lop.addParent(common);
                }
                if (left != null) {
                    rop.addParent(left);
                    lop.addParent(left);
                }
            } else if (be instanceof ShlExpr || be instanceof ShrExpr || be instanceof UshrExpr) {
                if (this.uses) {
                    rop.addParent(this.resolver.typeVariable(IntType.v()));
                }
                right = lop;
            } else {
                if (!(be instanceof CmpExpr) && !(be instanceof CmpgExpr) && !(be instanceof CmplExpr) && !(be instanceof EqExpr) && !(be instanceof GeExpr) && !(be instanceof GtExpr) && !(be instanceof LeExpr) && !(be instanceof LtExpr) && !(be instanceof NeExpr)) throw new RuntimeException("Unhandled binary expression type: " + be.getClass());
                if (this.uses) {
                    TypeVariable common = this.resolver.typeVariable();
                    rop.addParent(common);
                    lop.addParent(common);
                }
                right = this.resolver.typeVariable(IntType.v());
            }
        } else if (r instanceof CastExpr) {
            CastExpr ce = (CastExpr)r;
            right = this.resolver.typeVariable(ce.getCastType());
        } else if (r instanceof InstanceOfExpr) {
            InstanceOfExpr ioe = (InstanceOfExpr)r;
            right = this.resolver.typeVariable(IntType.v());
        } else if (r instanceof InvokeExpr) {
            InvokeExpr ie = (InvokeExpr)r;
            this.handleInvokeExpr(ie);
            right = this.resolver.typeVariable(ie.getMethod().getReturnType());
        } else if (r instanceof NewArrayExpr) {
            NewArrayExpr nae = (NewArrayExpr)r;
            baseType = nae.getBaseType();
            right = baseType instanceof ArrayType ? this.resolver.typeVariable(ArrayType.v(((ArrayType)baseType).baseType, ((ArrayType)baseType).numDimensions + 1)) : this.resolver.typeVariable(ArrayType.v((Type)baseType, 1));
            if (this.uses && (size = nae.getSize()) instanceof Local) {
                var = this.resolver.typeVariable((Local)size);
                var.addParent(this.resolver.typeVariable(IntType.v()));
            }
        } else if (r instanceof NewExpr) {
            NewExpr na = (NewExpr)r;
            right = this.resolver.typeVariable(na.getBaseType());
        } else if (r instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)r;
            right = this.resolver.typeVariable(nmae.getBaseType());
            if (this.uses) {
                for (int i = 0; i < nmae.getSizeCount(); ++i) {
                    size = nmae.getSize(i);
                    if (!(size instanceof Local)) continue;
                    var = this.resolver.typeVariable((Local)size);
                    var.addParent(this.resolver.typeVariable(IntType.v()));
                }
            }
        } else if (r instanceof LengthExpr) {
            LengthExpr le = (LengthExpr)r;
            if (this.uses && le.getOp() instanceof Local) {
                this.resolver.typeVariable((Local)le.getOp()).makeElement();
            }
            right = this.resolver.typeVariable(IntType.v());
        } else if (r instanceof NegExpr) {
            NegExpr ne = (NegExpr)r;
            if (ne.getOp() instanceof Local) {
                right = this.resolver.typeVariable((Local)ne.getOp());
            } else if (ne.getOp() instanceof DoubleConstant) {
                right = this.resolver.typeVariable(DoubleType.v());
            } else if (ne.getOp() instanceof FloatConstant) {
                right = this.resolver.typeVariable(FloatType.v());
            } else if (ne.getOp() instanceof IntConstant) {
                right = this.resolver.typeVariable(IntType.v());
            } else {
                if (!(ne.getOp() instanceof LongConstant)) throw new RuntimeException("Unhandled neg expression operand type: " + ne.getOp().getClass());
                right = this.resolver.typeVariable(LongType.v());
            }
        } else if (r instanceof Local) {
            right = this.resolver.typeVariable((Local)r);
        } else if (r instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)r;
            if (this.uses) {
                baseType = this.resolver.typeVariable((Local)ref.getBase());
                ((TypeVariable)baseType).addParent(this.resolver.typeVariable(ref.getField().getDeclaringClass()));
            }
            right = this.resolver.typeVariable(ref.getField().getType());
        } else {
            if (!(r instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment right hand side type: " + r.getClass());
            ref = (StaticFieldRef)r;
            right = this.resolver.typeVariable(((StaticFieldRef)ref).getField().getType());
        }
        if (left == null || right == null) return;
        right.addParent(left);
    }

    private String printTypeVar(TypeVariable t) {
        StringBuffer _sb = new StringBuffer(t.toString() + " ");
        TypeNode _a = t.approx();
        if (_a != null) {
            _sb.append(_a.toString() + " ");
        }
        for (TypeVariable _t : t.parents()) {
            if (_t == null) continue;
            _sb.append(" " + _t.toString() + " ");
            TypeNode _a1 = t.approx();
            if (_a1 == null) continue;
            _sb.append(_a1.toString() + " ");
        }
        return _sb.toString();
    }

    public void caseIdentityStmt(IdentityStmt stmt) {
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        if (l instanceof Local) {
            TypeVariable left = this.resolver.typeVariable((Local)l);
            if (!(r instanceof CaughtExceptionRef)) {
                TypeVariable right = this.resolver.typeVariable(r.getType());
                right.addParent(left);
            } else {
                List exceptionTypes = TrapManager.getExceptionTypesOf(stmt, this.stmtBody);
                for (Type t : exceptionTypes) {
                    this.resolver.typeVariable(t).addParent(left);
                }
                if (this.uses) {
                    left.addParent(this.resolver.typeVariable(RefType.v("java.lang.Throwable")));
                }
            }
        }
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            TypeVariable op = this.resolver.typeVariable((Local)stmt.getOp());
            op.addParent(this.resolver.typeVariable(RefType.v("java.lang.Object")));
        }
    }

    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            TypeVariable op = this.resolver.typeVariable((Local)stmt.getOp());
            op.addParent(this.resolver.typeVariable(RefType.v("java.lang.Object")));
        }
    }

    public void caseGotoStmt(GotoStmt stmt) {
    }

    public void caseIfStmt(IfStmt stmt) {
        if (this.uses) {
            TypeVariable rop;
            TypeVariable lop;
            ConditionExpr cond;
            ConditionExpr expr = cond = (ConditionExpr)stmt.getCondition();
            Value lv = expr.getOp1();
            Value rv = expr.getOp2();
            if (lv instanceof Local) {
                lop = this.resolver.typeVariable((Local)lv);
            } else if (lv instanceof DoubleConstant) {
                lop = this.resolver.typeVariable(DoubleType.v());
            } else if (lv instanceof FloatConstant) {
                lop = this.resolver.typeVariable(FloatType.v());
            } else if (lv instanceof IntConstant) {
                lop = this.resolver.typeVariable(IntType.v());
            } else if (lv instanceof LongConstant) {
                lop = this.resolver.typeVariable(LongType.v());
            } else if (lv instanceof NullConstant) {
                lop = this.resolver.typeVariable(NullType.v());
            } else if (lv instanceof StringConstant) {
                lop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            } else {
                throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
            }
            if (rv instanceof Local) {
                rop = this.resolver.typeVariable((Local)rv);
            } else if (rv instanceof DoubleConstant) {
                rop = this.resolver.typeVariable(DoubleType.v());
            } else if (rv instanceof FloatConstant) {
                rop = this.resolver.typeVariable(FloatType.v());
            } else if (rv instanceof IntConstant) {
                rop = this.resolver.typeVariable(IntType.v());
            } else if (rv instanceof LongConstant) {
                rop = this.resolver.typeVariable(LongType.v());
            } else if (rv instanceof NullConstant) {
                rop = this.resolver.typeVariable(NullType.v());
            } else if (rv instanceof StringConstant) {
                rop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            } else {
                throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
            }
            TypeVariable common = this.resolver.typeVariable();
            rop.addParent(common);
            lop.addParent(common);
        }
    }

    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        Value key;
        if (this.uses && (key = stmt.getKey()) instanceof Local) {
            this.resolver.typeVariable((Local)key).addParent(this.resolver.typeVariable(IntType.v()));
        }
    }

    public void caseNopStmt(NopStmt stmt) {
    }

    public void caseReturnStmt(ReturnStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            this.resolver.typeVariable((Local)stmt.getOp()).addParent(this.resolver.typeVariable(this.stmtBody.getMethod().getReturnType()));
        }
    }

    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        Value key;
        if (this.uses && (key = stmt.getKey()) instanceof Local) {
            this.resolver.typeVariable((Local)key).addParent(this.resolver.typeVariable(IntType.v()));
        }
    }

    public void caseThrowStmt(ThrowStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            TypeVariable op = this.resolver.typeVariable((Local)stmt.getOp());
            op.addParent(this.resolver.typeVariable(RefType.v("java.lang.Throwable")));
        }
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled statement type: " + stmt.getClass());
    }
}

