/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.jimple.toolkits.scalar.pre.DelayabilityAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;

public class LatestComputation {
    private Map unitToLatest;

    public LatestComputation(UnitGraph unitGraph, DelayabilityAnalysis delayed, Map equivRhsMap) {
        this(unitGraph, delayed, equivRhsMap, new ArrayPackedSet(new CollectionFlowUniverse(equivRhsMap.values())));
    }

    public LatestComputation(UnitGraph unitGraph, DelayabilityAnalysis delayed, Map equivRhsMap, BoundedFlowSet set) {
        this.unitToLatest = new HashMap(unitGraph.size() + 1, 0.7f);
        Iterator unitIt = unitGraph.iterator();
        while (unitIt.hasNext()) {
            Unit currentUnit = (Unit)unitIt.next();
            FlowSet delaySet = (FlowSet)delayed.getFlowBefore(currentUnit);
            FlowSet succCompSet = (FlowSet)set.topSet();
            List succList = unitGraph.getSuccsOf(currentUnit);
            for (Unit successor : succList) {
                succCompSet.intersection((FlowSet)delayed.getFlowBefore(successor), succCompSet);
            }
            if (equivRhsMap.get(currentUnit) != null) {
                succCompSet.remove(equivRhsMap.get(currentUnit));
            }
            FlowSet latest = (FlowSet)delaySet.emptySet();
            delaySet.difference(succCompSet, latest);
            this.unitToLatest.put(currentUnit, latest);
        }
    }

    public Object getFlowBefore(Object node) {
        return this.unitToLatest.get(node);
    }
}

