/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.EquivalentValue;
import soot.SideEffectTester;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.jimple.toolkits.scalar.pre.DownSafetyAnalysis;
import soot.jimple.toolkits.scalar.pre.UpSafetyAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;

public class EarliestnessComputation {
    private Map unitToEarliest;
    private SideEffectTester sideEffect;

    public EarliestnessComputation(UnitGraph unitGraph, UpSafetyAnalysis upSafe, DownSafetyAnalysis downSafe, SideEffectTester sideEffect) {
        this(unitGraph, upSafe, downSafe, sideEffect, new ArraySparseSet());
    }

    public EarliestnessComputation(UnitGraph unitGraph, UpSafetyAnalysis upSafe, DownSafetyAnalysis downSafe, SideEffectTester sideEffect, FlowSet set) {
        this.sideEffect = sideEffect;
        this.unitToEarliest = new HashMap(unitGraph.size() + 1, 0.7f);
        Iterator unitIt = unitGraph.iterator();
        while (unitIt.hasNext()) {
            Unit currentUnit = (Unit)unitIt.next();
            FlowSet earliest = (FlowSet)set.emptySet();
            this.unitToEarliest.put(currentUnit, earliest);
            FlowSet downSafeSet = (FlowSet)((FlowSet)downSafe.getFlowBefore(currentUnit)).clone();
            List predList = unitGraph.getPredsOf(currentUnit);
            if (predList.size() == 0) {
                earliest.union(downSafeSet);
                continue;
            }
            for (Unit predecessor : predList) {
                Value avail;
                EquivalentValue equiVal;
                Iterator downSafeIt = downSafeSet.iterator();
                block2: while (downSafeIt.hasNext()) {
                    equiVal = (EquivalentValue)downSafeIt.next();
                    avail = equiVal.getValue();
                    if (avail instanceof FieldRef) {
                        if (!sideEffect.unitCanWriteTo(predecessor, avail)) continue;
                        earliest.add(equiVal);
                        downSafeIt.remove();
                        continue;
                    }
                    Iterator usesIt = avail.getUseBoxes().iterator();
                    while (usesIt.hasNext()) {
                        Value use = ((ValueBox)usesIt.next()).getValue();
                        if (!sideEffect.unitCanWriteTo(predecessor, use)) continue;
                        earliest.add(equiVal);
                        downSafeIt.remove();
                        continue block2;
                    }
                }
                downSafeIt = downSafeSet.iterator();
                while (downSafeIt.hasNext()) {
                    equiVal = (EquivalentValue)downSafeIt.next();
                    avail = equiVal.getValue();
                    FlowSet preDown = (FlowSet)downSafe.getFlowBefore(predecessor);
                    FlowSet preUp = (FlowSet)upSafe.getFlowBefore(predecessor);
                    if (preDown.contains(equiVal) || preUp.contains(equiVal)) continue;
                    earliest.add(equiVal);
                    downSafeIt.remove();
                }
            }
        }
    }

    public Object getFlowBefore(Object node) {
        return this.unitToEarliest.get(node);
    }
}

