/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;

public class ToppedSet
extends AbstractFlowSet {
    FlowSet underlyingSet;
    boolean isTop;

    public void setTop(boolean top) {
        this.isTop = top;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public ToppedSet(FlowSet under) {
        this.underlyingSet = under;
    }

    public Object clone() {
        ToppedSet newSet = new ToppedSet((FlowSet)this.underlyingSet.clone());
        newSet.setTop(this.isTop());
        return newSet;
    }

    public void copy(FlowSet d) {
        ToppedSet dest = (ToppedSet)d;
        if (!this.isTop()) {
            this.underlyingSet.copy(dest.underlyingSet);
            dest.setTop(false);
            return;
        }
        dest.setTop(true);
    }

    public Object emptySet() {
        return new ToppedSet((FlowSet)this.underlyingSet.emptySet());
    }

    public void clear() {
        this.isTop = false;
        this.underlyingSet.clear();
    }

    public void union(FlowSet o, FlowSet d) {
        if (o instanceof ToppedSet && d instanceof ToppedSet) {
            ToppedSet other = (ToppedSet)o;
            ToppedSet dest = (ToppedSet)d;
            if (this.isTop()) {
                this.copy(dest);
                return;
            }
            if (other.isTop()) {
                other.copy(dest);
            } else {
                this.underlyingSet.union(other.underlyingSet, dest.underlyingSet);
                dest.setTop(false);
            }
        } else {
            super.union(o, d);
        }
    }

    public void intersection(FlowSet o, FlowSet d) {
        if (this.isTop()) {
            o.copy(d);
            return;
        }
        ToppedSet other = (ToppedSet)o;
        ToppedSet dest = (ToppedSet)d;
        if (other.isTop()) {
            this.copy(dest);
            return;
        }
        this.underlyingSet.intersection(other.underlyingSet, dest.underlyingSet);
        dest.setTop(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void difference(FlowSet o, FlowSet d) {
        ToppedSet other = (ToppedSet)o;
        ToppedSet dest = (ToppedSet)d;
        if (this.isTop()) {
            if (other.isTop()) {
                dest.clear();
                return;
            } else {
                if (!(other.underlyingSet instanceof BoundedFlowSet)) throw new RuntimeException("can't take difference!");
                ((BoundedFlowSet)other.underlyingSet).complement(dest);
            }
            return;
        } else if (other.isTop()) {
            dest.clear();
            return;
        } else {
            this.underlyingSet.difference(other.underlyingSet, dest.underlyingSet);
        }
    }

    public boolean isEmpty() {
        if (this.isTop()) {
            return false;
        }
        return this.underlyingSet.isEmpty();
    }

    public int size() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.size();
    }

    public void add(Object obj) {
        if (this.isTop()) {
            return;
        }
        this.underlyingSet.add(obj);
    }

    public void remove(Object obj) {
        if (this.isTop()) {
            return;
        }
        this.underlyingSet.remove(obj);
    }

    public boolean contains(Object obj) {
        if (this.isTop()) {
            return true;
        }
        return this.underlyingSet.contains(obj);
    }

    public List toList() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.toList();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToppedSet)) {
            return false;
        }
        ToppedSet other = (ToppedSet)o;
        if (other.isTop() != this.isTop()) {
            return false;
        }
        return this.underlyingSet.equals(other.underlyingSet);
    }

    public String toString() {
        if (this.isTop()) {
            return "{TOP}";
        }
        return this.underlyingSet.toString();
    }
}

