/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.Type;
import soot.jimple.Jimple;
import soot.util.Chain;

public class LocalCreation {
    public static final String DEFAULT_PREFIX = "soot";
    private String prefix;
    private int counter;
    private Set locals;
    private Chain localChain;

    public LocalCreation(Chain locals) {
        this(locals, DEFAULT_PREFIX);
    }

    public LocalCreation(Chain locals, String prefix) {
        this.locals = new HashSet(locals.size());
        this.localChain = locals;
        for (Local l : locals) {
            this.locals.add(l.getName());
        }
        this.prefix = prefix;
        this.counter = 0;
    }

    public Local newLocal(Type type) {
        return this.newLocal(this.prefix, type);
    }

    public Local newLocal(String prefix, Type type) {
        int suffix = 0;
        if (prefix == this.prefix || prefix.equals(this.prefix)) {
            suffix = this.counter;
        }
        while (this.locals.contains(prefix + suffix)) {
            ++suffix;
        }
        if (prefix == this.prefix || prefix.equals(this.prefix)) {
            this.counter = suffix + 1;
        }
        String newName = prefix + suffix;
        Local newLocal = Jimple.v().newLocal(newName, type);
        this.localChain.addLast(newLocal);
        this.locals.add(newName);
        return newLocal;
    }
}

