/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.BitSet;
import java.util.List;
import soot.FastHierarchy;
import soot.Local;
import soot.RefType;
import soot.Scene;

class LocalTypeSet
extends BitSet {
    protected List locals;
    protected List types;

    public LocalTypeSet(List locals, List types) {
        super(locals.size() * types.size());
        this.locals = locals;
        this.types = types;
        if (!Scene.v().hasFastHierarchy()) {
            Scene.v().setFastHierarchy(new FastHierarchy());
        }
    }

    protected int indexOf(Local l, RefType t) {
        if (this.locals.indexOf(l) == -1 || this.types.indexOf(t) == -1) {
            throw new RuntimeException("Invalid local or type in LocalTypeSet");
        }
        return this.locals.indexOf(l) * this.types.size() + this.types.indexOf(t);
    }

    public void killLocal(Local l) {
        int base = this.types.size() * this.locals.indexOf(l);
        for (int i = 0; i < this.types.size(); ++i) {
            this.clear(i + base);
        }
    }

    public void localCopy(Local to, Local from) {
        int baseTo = this.types.size() * this.locals.indexOf(to);
        int baseFrom = this.types.size() * this.locals.indexOf(from);
        for (int i = 0; i < this.types.size(); ++i) {
            if (this.get(i + baseFrom)) {
                this.set(i + baseTo);
                continue;
            }
            this.clear(i + baseTo);
        }
    }

    public void clearAllBits() {
        for (int i = 0; i < this.types.size() * this.locals.size(); ++i) {
            this.clear(i);
        }
    }

    public void setAllBits() {
        for (int i = 0; i < this.types.size() * this.locals.size(); ++i) {
            this.set(i);
        }
    }

    public void localMustBeSubtypeOf(Local l, RefType t) {
        FastHierarchy fh = Scene.v().getFastHierarchy();
        for (RefType supertype : this.types) {
            if (!fh.canStoreType(t, supertype)) continue;
            this.set(this.indexOf(l, supertype));
        }
    }
}

