/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashSet;
import soot.tagkit.Attribute;

public class DependenceGraph
implements Attribute {
    private static final String NAME = "DependenceGraph";
    HashSet edges = new HashSet();

    public boolean areAdjacent(short from, short to) {
        if (from > to) {
            return this.areAdjacent(to, from);
        }
        if (from < 0 || to < 0) {
            return false;
        }
        if (from == to) {
            return true;
        }
        return this.edges.contains(new Edge(from, to));
    }

    public void addEdge(short from, short to) {
        if (from < 0) {
            throw new RuntimeException("from < 0");
        }
        if (to < 0) {
            throw new RuntimeException("to < 0");
        }
        if (from > to) {
            this.addEdge(to, from);
            return;
        }
        this.edges.add(new Edge(from, to));
    }

    public String getName() {
        return NAME;
    }

    public void setValue(byte[] v) {
        throw new RuntimeException("Not Supported");
    }

    public byte[] getValue() {
        byte[] ret = new byte[4 * this.edges.size()];
        int i = 0;
        for (Edge e : this.edges) {
            ret[i + 0] = (byte)(e.from >> 8 & 0xFF);
            ret[i + 1] = (byte)(e.from & 0xFF);
            ret[i + 2] = (byte)(e.to >> 8 & 0xFF);
            ret[i + 3] = (byte)(e.to & 0xFF);
            i += 4;
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Dependences");
        for (Edge e : this.edges) {
            buf.append("( " + e.from + ", " + e.to + " ) ");
        }
        return buf.toString();
    }

    protected class Edge {
        short from;
        short to;

        Edge(short from, short to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            return (this.from << 16) + this.to;
        }

        public boolean equals(Object other) {
            Edge o = (Edge)other;
            return this.from == o.from && this.to == o.to;
        }
    }
}

