/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import soot.ClassMember;
import soot.Hierarchy;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;

public class AccessManager {
    public static boolean isAccessLegal(SootMethod container2, ClassMember target) {
        SootClass targetClass = target.getDeclaringClass();
        SootClass containerClass = container2.getDeclaringClass();
        if (!AccessManager.isAccessLegal(container2, targetClass)) {
            return false;
        }
        if (target.isPrivate() && !targetClass.getName().equals(containerClass.getName())) {
            return false;
        }
        if (!(target.isPrivate() || target.isProtected() || target.isPublic() || targetClass.getPackageName().equals(containerClass.getPackageName()))) {
            return false;
        }
        if (target.isProtected()) {
            Hierarchy h = Scene.v().getActiveHierarchy();
            return h.isClassSuperclassOfIncluding(targetClass, containerClass);
        }
        return true;
    }

    public static boolean isAccessLegal(SootMethod container2, SootClass target) {
        return target.isPublic() || container2.getDeclaringClass().getPackageName().equals(target.getPackageName());
    }

    public static boolean ensureAccess(SootMethod container2, ClassMember target, String options) {
        boolean safeChangesOnly;
        boolean allowChanges = !options.equals("none");
        boolean bl = safeChangesOnly = !options.equals("unsafe");
        if (safeChangesOnly) {
            throw new RuntimeException("not implemented yet!");
        }
        SootClass targetClass = target.getDeclaringClass();
        if (!AccessManager.ensureAccess(container2, targetClass, options)) {
            return false;
        }
        if (AccessManager.isAccessLegal(container2, target)) {
            return true;
        }
        if (!allowChanges) {
            return false;
        }
        if (target.getDeclaringClass().isApplicationClass()) {
            target.setModifiers(target.getModifiers() | 1);
            return true;
        }
        return false;
    }

    public static boolean ensureAccess(SootMethod container2, SootClass target, String options) {
        boolean safeChangesOnly;
        boolean allowChanges = !options.equals("none");
        boolean bl = safeChangesOnly = !options.equals("unsafe");
        if (safeChangesOnly) {
            throw new RuntimeException("not implemented yet!");
        }
        if (AccessManager.isAccessLegal(container2, target)) {
            return true;
        }
        if (!allowChanges) {
            return false;
        }
        if (target.isApplicationClass()) {
            target.setModifiers(target.getModifiers() | 1);
            return true;
        }
        return false;
    }
}

