/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.HashSet;
import java.util.LinkedList;
import soot.AnySubType;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.G;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.util.LargeNumberedMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;

public final class VirtualCalls {
    private LargeNumberedMap typeToVtbl = new LargeNumberedMap(Scene.v().getTypeNumberer());
    public final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    public final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    public final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");

    public VirtualCalls(Singletons.Global g) {
    }

    public static VirtualCalls v() {
        return G.v().VirtualCalls();
    }

    private SootMethod resolveRefType(RefType t, InstanceInvokeExpr iie, NumberedString subSig, SootMethod container2) {
        if (iie instanceof SpecialInvokeExpr) {
            SootMethod target = iie.getMethod();
            if (Scene.v().getOrMakeFastHierarchy().canStoreType(container2.getDeclaringClass().getType(), target.getDeclaringClass().getType()) && container2.getDeclaringClass().getType() != target.getDeclaringClass().getType() && !target.getName().equals("<init>") && subSig != this.sigClinit) {
                t = container2.getDeclaringClass().getSuperclass().getType();
            } else {
                return target;
            }
        }
        return this.resolveNonSpecial(t, iie, container2, subSig);
    }

    private SootMethod resolveNonSpecial(RefType t, InstanceInvokeExpr iie, SootMethod container2, NumberedString subSig) {
        SootMethod ret;
        SmallNumberedMap vtbl = (SmallNumberedMap)this.typeToVtbl.get(t);
        if (vtbl == null) {
            vtbl = new SmallNumberedMap(Scene.v().getMethodNumberer());
            this.typeToVtbl.put(t, vtbl);
        }
        if ((ret = (SootMethod)vtbl.get(subSig)) != null) {
            return ret;
        }
        SootClass cls = t.getSootClass();
        if (cls.declaresMethod(subSig)) {
            SootMethod m = cls.getMethod(subSig);
            if (m.isConcrete() || m.isNative()) {
                ret = cls.getMethod(subSig);
            }
        } else if (cls.hasSuperclass()) {
            ret = this.resolveNonSpecial(cls.getSuperclass().getType(), iie, container2, subSig);
        }
        vtbl.put(subSig, ret);
        return ret;
    }

    public void resolve(Type t, InstanceInvokeExpr iie, NumberedString subSig, SootMethod container2, ChunkedQueue targets) {
        if (iie != null && !Scene.v().getOrMakeFastHierarchy().canStoreType(t, iie.getBase().getType())) {
            return;
        }
        if (t instanceof ArrayType) {
            t = RefType.v("java.lang.Object");
        }
        if (t instanceof RefType) {
            SootMethod target = this.resolveRefType((RefType)t, iie, subSig, container2);
            if (target != null) {
                targets.add(target);
            }
        } else if (t instanceof AnySubType) {
            RefType base = ((AnySubType)t).getBase();
            this.resolve(base, iie, subSig, container2, targets);
            if (iie instanceof SpecialInvokeExpr) {
                return;
            }
            LinkedList<SootClass> worklist = new LinkedList<SootClass>();
            HashSet<SootClass> workset = new HashSet<SootClass>();
            FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
            SootClass cl = base.getSootClass();
            if (workset.add(cl)) {
                worklist.add(cl);
            }
            while (!worklist.isEmpty()) {
                cl = (SootClass)worklist.removeFirst();
                if (cl.isInterface()) {
                    for (SootClass c : fh.getAllImplementersOfInterface(cl)) {
                        if (!workset.add(c)) continue;
                        worklist.add(c);
                    }
                    continue;
                }
                this.resolve(cl.getType(), iie, subSig, container2, targets);
                for (SootClass c : fh.getSubclassesOf(cl)) {
                    if (!workset.add(c)) continue;
                    worklist.add(c);
                }
            }
        } else if (!(t instanceof NullType)) {
            throw new RuntimeException("oops " + t);
        }
    }

    public void resolve(Type t, InstanceInvokeExpr iie, SootMethod container2, ChunkedQueue targets) {
        this.resolve(t, iie, iie.getMethod().getNumberedSubSignature(), container2, targets);
    }

    public void resolveThread(Type t, InstanceInvokeExpr iie, SootMethod container2, ChunkedQueue targets) {
        if (iie.getMethod().getNumberedSubSignature() != this.sigStart) {
            return;
        }
        if (!Scene.v().getOrMakeFastHierarchy().canStoreType(t, RefType.v("java.lang.Runnable"))) {
            return;
        }
        this.resolve(t, iie, this.sigRun, container2, targets);
    }
}

