/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import soot.ArrayType;
import soot.Body;
import soot.FastHierarchy;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextManager;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.EntryPoints;
import soot.jimple.toolkits.callgraph.MethodContext;
import soot.jimple.toolkits.callgraph.MethodOrMethodContext;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.callgraph.VirtualCallSite;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.options.CGOptions;
import soot.util.LargeNumberedMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public final class OnFlyCallGraphBuilder {
    private CallGraph cicg = new CallGraph();
    private HashSet analyzedMethods = new HashSet();
    private LargeNumberedMap receiverToSites = new LargeNumberedMap(Scene.v().getLocalNumberer());
    private LargeNumberedMap methodToReceivers = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private SmallNumberedMap stringConstToSites = new SmallNumberedMap(Scene.v().getLocalNumberer());
    private LargeNumberedMap methodToStringConstants = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private CGOptions options;
    private boolean appOnly;
    private ReachableMethods rm;
    private QueueReader worklist;
    private ContextManager cm;
    private ChunkedQueue targetsQueue = new ChunkedQueue();
    private QueueReader targets = this.targetsQueue.reader();
    private final NumberedString sigMain = Scene.v().getSubSigNumberer().findOrAdd("void main(java.lang.String[])");
    private final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    private final NumberedString sigExit = Scene.v().getSubSigNumberer().findOrAdd("void exit()");
    private final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    private final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    private final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    private final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    private final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");
    private final RefType clPrivilegedAction = RefType.v("java.security.PrivilegedAction");
    private final RefType clPrivilegedExceptionAction = RefType.v("java.security.PrivilegedExceptionAction");
    private final RefType clRunnable = RefType.v("java.lang.Runnable");

    public LargeNumberedMap methodToReceivers() {
        return this.methodToReceivers;
    }

    public LargeNumberedMap methodToStringConstants() {
        return this.methodToStringConstants;
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm) {
        this.cm = cm;
        this.rm = rm;
        this.worklist = rm.listener();
        this.options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        if (!this.options.verbose()) {
            G.v().out.println("[Call Graph] For information on where the call graph may be incomplete, use the verbose option to the cg phase.");
        }
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm, boolean appOnly) {
        this(cm, rm);
        this.appOnly = appOnly;
    }

    public void processReachables() {
        while (true) {
            MethodOrMethodContext momc;
            if ((momc = (MethodOrMethodContext)this.worklist.next()) == null) {
                this.rm.update();
                momc = (MethodOrMethodContext)this.worklist.next();
                if (momc == null) break;
            }
            SootMethod m = momc.method();
            if (this.appOnly && !m.getDeclaringClass().isApplicationClass()) continue;
            if (this.analyzedMethods.add(m)) {
                this.processNewMethod(m);
            }
            this.processNewMethodContext(momc);
        }
    }

    public boolean wantTypes(Local receiver) {
        return this.receiverToSites.get(receiver) != null;
    }

    public void addType(Local receiver, Object srcContext, Type type, Object typeContext) {
        for (VirtualCallSite site : (Collection)this.receiverToSites.get(receiver)) {
            SootMethod target;
            InstanceInvokeExpr iie = site.getInstanceInvokeExpr();
            if (iie == null) {
                VirtualCalls.v().resolve(type, null, this.sigObjRun, site.getContainer(), this.targetsQueue);
            } else {
                VirtualCalls.v().resolve(type, site.getInstanceInvokeExpr(), site.getContainer(), this.targetsQueue);
            }
            while ((target = (SootMethod)this.targets.next()) != null) {
                if (iie == null) {
                    this.cm.addVirtualEdge(MethodContext.v(site.getContainer(), srcContext), site.getStmt(), target, 9, typeContext);
                    continue;
                }
                this.cm.addVirtualEdge(MethodContext.v(site.getContainer(), srcContext), site.getStmt(), target, Edge.ieToKind(site.getStmt().getInvokeExpr()), typeContext);
            }
            if (iie == null || iie.getMethod().getNumberedSubSignature() != this.sigStart) continue;
            VirtualCalls.v().resolveThread(type, site.getInstanceInvokeExpr(), site.getContainer(), this.targetsQueue);
            while ((target = (SootMethod)this.targets.next()) != null) {
                this.cm.addVirtualEdge(MethodContext.v(site.getContainer(), srcContext), site.getStmt(), target, 6, typeContext);
            }
        }
    }

    public boolean wantStringConstants(Local stringConst) {
        return this.stringConstToSites.get(stringConst) != null;
    }

    public void addStringConstant(Local l, Object srcContext, String constant) {
        for (VirtualCallSite site : (Collection)this.stringConstToSites.get(l)) {
            if (constant == null) {
                if (!this.options.verbose()) continue;
                G.v().out.println("Warning: Method " + site.getContainer() + " is reachable, and calls Class.forName on a" + " non-constant String; graph will be incomplete!" + " Use safe-forname option for a conservative result.");
                continue;
            }
            if (constant.charAt(0) == '[') {
                if (constant.length() <= 1 || constant.charAt(1) != 'L' || constant.charAt(constant.length() - 1) != ';') continue;
                constant = constant.substring(2, constant.length() - 1);
            }
            if (!Scene.v().containsClass(constant)) {
                if (!this.options.verbose()) continue;
                G.v().out.println("Warning: Class " + constant + " is" + " a dynamic class, and you did not specify" + " it as such; graph will be incomplete!");
                continue;
            }
            SootClass sootcls = Scene.v().getSootClass(constant);
            if (!sootcls.isApplicationClass()) {
                sootcls.setLibraryClass();
            }
            if (!sootcls.declaresMethod(this.sigClinit)) continue;
            this.cm.addStaticEdge(MethodContext.v(site.getContainer(), srcContext), site.getStmt(), sootcls.getMethod(this.sigClinit), 5);
        }
    }

    private void processNewMethod(SootMethod m) {
        if (m.isNative() || m.isPhantom()) {
            return;
        }
        Body b = m.retrieveActiveBody();
        this.getImplicitTargets(m);
        this.findReceivers(m, b);
    }

    private void findReceivers(SootMethod m, Body b) {
        ArrayList<Local> receivers = (ArrayList<Local>)this.methodToReceivers.get(m);
        if (receivers == null) {
            receivers = new ArrayList<Local>();
            this.methodToReceivers.put(m, receivers);
        }
        for (Stmt s : b.getUnits()) {
            if (!s.containsInvokeExpr()) continue;
            InvokeExpr ie = s.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                VirtualCallSite site = new VirtualCallSite(s, m);
                Local receiver = (Local)((InstanceInvokeExpr)ie).getBase();
                ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)this.receiverToSites.get(receiver);
                if (sites == null) {
                    sites = new ArrayList<VirtualCallSite>();
                    this.receiverToSites.put(receiver, sites);
                    receivers.add(receiver);
                }
                sites.add(site);
                continue;
            }
            SootMethod tgt = ((StaticInvokeExpr)ie).getMethod();
            this.cicg.addEdge(new Edge(m, s, tgt));
            if (!tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>") && !tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>") && !tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>") && !tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>")) continue;
            VirtualCallSite site = new VirtualCallSite(s, m);
            Local receiver = (Local)ie.getArg(0);
            ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)this.receiverToSites.get(receiver);
            if (sites == null) {
                sites = new ArrayList<VirtualCallSite>();
                this.receiverToSites.put(receiver, sites);
                receivers.add(receiver);
            }
            sites.add(site);
        }
    }

    private void getImplicitTargets(SootMethod source) {
        ArrayList<Local> stringConstants = (ArrayList<Local>)this.methodToStringConstants.get(source);
        if (stringConstants == null) {
            stringConstants = new ArrayList<Local>();
            this.methodToStringConstants.put(source, stringConstants);
        }
        SootClass scl = source.getDeclaringClass();
        if (source.isNative() || source.isPhantom()) {
            return;
        }
        if (source.getSubSignature().indexOf("<init>") >= 0) {
            this.handleInit(source, scl);
        }
        Body b = source.retrieveActiveBody();
        boolean warnedAlready = false;
        for (Stmt s : b.getUnits()) {
            FieldRef fr;
            if (s.containsInvokeExpr()) {
                InvokeExpr ie = s.getInvokeExpr();
                if (ie.getMethod().getSignature().equals("<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>") && !warnedAlready) {
                    if (this.options.verbose()) {
                        G.v().out.println("Warning: call to java.lang.reflect.Method: invoke() from " + source + "; graph will be incomplete!");
                    }
                    warnedAlready = true;
                }
                if (ie.getMethod().getSignature().equals("<java.lang.Class: java.lang.Object newInstance()>")) {
                    if (this.options.safe_newinstance()) {
                        for (SootMethod tgt : EntryPoints.v().inits()) {
                            this.cicg.addEdge(new Edge(source, s, tgt, 10));
                        }
                    } else if (this.options.verbose()) {
                        G.v().out.println("Warning: Method " + source + " is reachable, and calls Class.newInstance;" + " graph will be incomplete!" + " Use safe-newinstance option for a conservative result.");
                    }
                }
                if (ie instanceof StaticInvokeExpr) {
                    this.addEdge(source, s, ie.getMethod().getDeclaringClass(), this.sigClinit, 5);
                }
                if (ie.getMethod().getNumberedSubSignature() == this.sigForName) {
                    Value className = ie.getArg(0);
                    if (className instanceof StringConstant) {
                        String cls = ((StringConstant)className).value;
                        this.constantForName(cls, source, s);
                    } else {
                        Local constant = (Local)className;
                        if (this.options.safe_forname()) {
                            for (SootMethod tgt : EntryPoints.v().clinits()) {
                                this.cicg.addEdge(new Edge(source, s, tgt, 5));
                            }
                        } else {
                            VirtualCallSite site = new VirtualCallSite(s, source);
                            ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)this.stringConstToSites.get(constant);
                            if (sites == null) {
                                sites = new ArrayList<VirtualCallSite>();
                                this.stringConstToSites.put(constant, sites);
                                stringConstants.add(constant);
                            }
                            sites.add(site);
                        }
                    }
                }
            }
            if (s.containsFieldRef() && (fr = s.getFieldRef()) instanceof StaticFieldRef) {
                SootClass cl = fr.getField().getDeclaringClass();
                this.addEdge(source, s, cl, this.sigClinit, 5);
            }
            if (!(s instanceof AssignStmt)) continue;
            Value rhs = ((AssignStmt)s).getRightOp();
            if (rhs instanceof NewExpr) {
                NewExpr r = (NewExpr)rhs;
                this.addEdge(source, s, r.getBaseType().getSootClass(), this.sigClinit, 5);
                continue;
            }
            if (!(rhs instanceof NewArrayExpr) && !(rhs instanceof NewMultiArrayExpr)) continue;
            Type t = rhs.getType();
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).baseType;
            }
            if (!(t instanceof RefType)) continue;
            this.addEdge(source, s, ((RefType)t).getSootClass(), this.sigClinit, 5);
        }
    }

    private void processNewMethodContext(MethodOrMethodContext momc) {
        SootMethod m = momc.method();
        Object ctxt = momc.context();
        Iterator it = this.cicg.edgesOutOf(m);
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            this.cm.addStaticEdge(momc, e.srcUnit(), e.tgt(), e.kind());
        }
    }

    private void handleInit(SootMethod source, SootClass scl) {
        this.addEdge(source, null, scl, this.sigFinalize, 8);
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        if (fh.canStoreType(scl.getType(), this.clRunnable)) {
            this.addEdge(source, null, scl, this.sigExit, 7);
        }
    }

    private void constantForName(String cls, SootMethod src, Stmt srcUnit) {
        if (cls.charAt(0) == '[') {
            if (cls.charAt(1) == 'L' && cls.charAt(cls.length() - 1) == ';') {
                cls = cls.substring(2, cls.length() - 1);
                this.constantForName(cls, src, srcUnit);
            }
        } else if (!Scene.v().containsClass(cls)) {
            if (this.options.verbose()) {
                G.v().out.println("Warning: Class " + cls + " is" + " a dynamic class, and you did not specify" + " it as such; graph will be incomplete!");
            }
        } else {
            SootClass sootcls = Scene.v().getSootClass(cls);
            if (!sootcls.isApplicationClass()) {
                sootcls.setLibraryClass();
            }
            this.addEdge(src, srcUnit, sootcls, this.sigClinit, 5);
        }
    }

    private final void addEdge(SootMethod src, Stmt stmt, SootClass cls, NumberedString methodSubSig, int type) {
        if (cls.declaresMethod(methodSubSig)) {
            this.cicg.addEdge(new Edge(src, stmt, cls.getMethod(methodSubSig), type));
        }
    }

    private final void addEdge(SootMethod src, Stmt stmt, String methodSig, int type) {
        if (Scene.v().containsMethod(methodSig)) {
            this.cicg.addEdge(new Edge(src, stmt, Scene.v().getMethod(methodSig), type));
        }
    }
}

