/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import soot.SootMethod;
import soot.Unit;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.callgraph.MethodOrMethodContext;

public final class Edge {
    private MethodOrMethodContext src;
    private Unit srcUnit;
    private MethodOrMethodContext tgt;
    public static final int INVALID = 0;
    public static final int STATIC = 1;
    public static final int VIRTUAL = 2;
    public static final int INTERFACE = 3;
    public static final int SPECIAL = 4;
    public static final int CLINIT = 5;
    public static final int THREAD = 6;
    public static final int EXIT = 7;
    public static final int FINALIZE = 8;
    public static final int PRIVILEGED = 9;
    public static final int NEWINSTANCE = 10;
    public static final String[] kinds = new String[]{"INVALID", "STATIC", "VIRTUAL", "INTERFACE", "SPECIAL", "CLINIT", "THREAD", "EXIT", "FINALIZE", "PRIVILEGED", "NEWINSTANCE"};
    private int kind;
    private Edge nextBySrc = this;
    private Edge prevBySrc = this;
    private Edge nextByTgt = this;
    private Edge prevByTgt = this;

    public SootMethod src() {
        if (this.src == null) {
            return null;
        }
        return this.src.method();
    }

    public Object srcCtxt() {
        if (this.src == null) {
            return null;
        }
        return this.src.context();
    }

    public MethodOrMethodContext getSrc() {
        return this.src;
    }

    public Unit srcUnit() {
        return this.srcUnit;
    }

    public Stmt srcStmt() {
        return (Stmt)this.srcUnit;
    }

    public SootMethod tgt() {
        return this.tgt.method();
    }

    public Object tgtCtxt() {
        return this.tgt.context();
    }

    public MethodOrMethodContext getTgt() {
        return this.tgt;
    }

    public int kind() {
        return this.kind;
    }

    public Edge(MethodOrMethodContext src, Unit srcUnit, MethodOrMethodContext tgt, int type) {
        this.src = src;
        this.srcUnit = srcUnit;
        this.tgt = tgt;
        this.kind = type;
    }

    public Edge(MethodOrMethodContext src, Stmt srcUnit, MethodOrMethodContext tgt) {
        this.kind = Edge.ieToKind(srcUnit.getInvokeExpr());
        this.src = src;
        this.srcUnit = srcUnit;
        this.tgt = tgt;
    }

    public static int ieToKind(InvokeExpr ie) {
        if (ie instanceof VirtualInvokeExpr) {
            return 2;
        }
        if (ie instanceof SpecialInvokeExpr) {
            return 4;
        }
        if (ie instanceof InterfaceInvokeExpr) {
            return 3;
        }
        if (ie instanceof StaticInvokeExpr) {
            return 1;
        }
        throw new RuntimeException();
    }

    public boolean isExplicit() {
        return this.isInstance() || this.isStatic();
    }

    public boolean isInstance() {
        return this.kind == 2 || this.kind == 3 || this.kind == 4;
    }

    public boolean isClinit() {
        return this.kind == 5;
    }

    public boolean isStatic() {
        return this.kind == 1;
    }

    public boolean passesParameters() {
        return this.isExplicit() || this.kind == 6 || this.kind == 7 || this.kind == 8 || this.kind == 9 || this.kind == 10;
    }

    public int hashCode() {
        int ret = this.tgt.hashCode() + this.kind;
        if (this.src != null) {
            ret += this.src.hashCode();
        }
        if (this.srcUnit != null) {
            ret += this.srcUnit.hashCode();
        }
        return ret;
    }

    public boolean equals(Object other) {
        Edge o = (Edge)other;
        if (o.src != this.src) {
            return false;
        }
        if (o.srcUnit != this.srcUnit) {
            return false;
        }
        if (o.tgt != this.tgt) {
            return false;
        }
        return o.kind == this.kind;
    }

    public static String kindToString(int kind) {
        return kinds[kind];
    }

    public String toString() {
        return Edge.kindToString(this.kind) + " edge: " + this.srcUnit + " in " + this.src + " ==> " + this.tgt;
    }

    void insertAfterBySrc(Edge other) {
        this.nextBySrc = other.nextBySrc;
        this.nextBySrc.prevBySrc = this;
        other.nextBySrc = this;
        this.prevBySrc = other;
    }

    void insertAfterByTgt(Edge other) {
        this.nextByTgt = other.nextByTgt;
        this.nextByTgt.prevByTgt = this;
        other.nextByTgt = this;
        this.prevByTgt = other;
    }

    void insertBeforeBySrc(Edge other) {
        this.prevBySrc = other.prevBySrc;
        this.prevBySrc.nextBySrc = this;
        other.prevBySrc = this;
        this.nextBySrc = other;
    }

    void insertBeforeByTgt(Edge other) {
        this.prevByTgt = other.prevByTgt;
        this.prevByTgt.nextByTgt = this;
        other.prevByTgt = this;
        this.nextByTgt = other;
    }

    void remove() {
        this.nextBySrc.prevBySrc = this.prevBySrc;
        this.prevBySrc.nextBySrc = this.nextBySrc;
        this.nextByTgt.prevByTgt = this.prevByTgt;
        this.prevByTgt.nextByTgt = this.nextByTgt;
    }

    Edge nextBySrc() {
        return this.nextBySrc;
    }

    Edge nextByTgt() {
        return this.nextByTgt;
    }
}

