/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.base.Zone;

public class Zonation {
    private int zoneCount;
    private Map unitToZone;

    public Zonation(StmtBody body) {
        PatchingChain units = body.getUnits();
        HashMap unitToTrapBoundaries = new HashMap();
        for (Unit u : units) {
            unitToTrapBoundaries.put(u, new ArrayList());
        }
        for (Trap t : body.getTraps()) {
            List boundary = (List)unitToTrapBoundaries.get(t.getBeginUnit());
            boundary.add(t);
            boundary = (List)unitToTrapBoundaries.get(t.getEndUnit());
            boundary.add(t);
        }
        HashMap trapListToZone = new HashMap(10, 0.7f);
        ArrayList<Trap> currentTraps = new ArrayList<Trap>();
        this.zoneCount = 0;
        this.unitToZone = new HashMap(units.size() * 2 + 1, 0.7f);
        Zone currentZone = new Zone("0");
        trapListToZone.put(new ArrayList(), currentZone);
        for (Unit u : units) {
            List trapBoundaries = (List)unitToTrapBoundaries.get(u);
            if (trapBoundaries.size() != 0) {
                for (Trap trap : trapBoundaries) {
                    if (currentTraps.contains(trap)) {
                        currentTraps.remove(trap);
                        continue;
                    }
                    currentTraps.add(trap);
                }
                if (trapListToZone.containsKey(currentTraps)) {
                    currentZone = (Zone)trapListToZone.get(currentTraps);
                } else {
                    ++this.zoneCount;
                    currentZone = new Zone(new Integer(this.zoneCount).toString());
                    trapListToZone.put(currentTraps, currentZone);
                }
            }
            this.unitToZone.put(u, currentZone);
        }
    }

    public Zone getZoneOf(Unit u) {
        Zone z = (Zone)this.unitToZone.get(u);
        if (z == null) {
            throw new RuntimeException("null zone!");
        }
        return z;
    }

    public int getZoneCount() {
        return this.zoneCount;
    }
}

