/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.parity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.parity.ParityAnalysis;
import soot.tagkit.ColorTag;
import soot.tagkit.KeyTag;
import soot.tagkit.StringTag;
import soot.toolkits.graph.BriefUnitGraph;

public class ParityTagger
extends BodyTransformer {
    public ParityTagger(Singletons.Global g) {
    }

    public static ParityTagger v() {
        return G.v().ParityTagger();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        ParityAnalysis a = new ParityAnalysis(new BriefUnitGraph(b));
        for (Stmt s : b.getUnits()) {
            String type;
            HashMap parityVars = (HashMap)a.getFlowAfter(s);
            for (Value variable : parityVars.keySet()) {
                StringTag t = new StringTag("Parity variable: " + variable + " " + parityVars.get(variable));
                s.addTag(t);
            }
            HashMap parityVarsUses = (HashMap)a.getFlowBefore(s);
            HashMap parityVarsDefs = (HashMap)a.getFlowAfter(s);
            for (ValueBox vb : s.getUseBoxes()) {
                if (!parityVarsUses.containsKey(vb.getValue())) continue;
                type = (String)parityVarsUses.get(vb.getValue());
                this.addColorTag(vb, type);
            }
            for (ValueBox vb : s.getDefBoxes()) {
                if (!parityVarsDefs.containsKey(vb.getValue())) continue;
                type = (String)parityVarsDefs.get(vb.getValue());
                this.addColorTag(vb, type);
            }
        }
        Iterator keyIt = b.getMethod().getDeclaringClass().getTags().iterator();
        boolean keysAdded = false;
        while (keyIt.hasNext()) {
            if (!(keyIt.next() instanceof KeyTag)) continue;
            keysAdded = true;
        }
        if (!keysAdded) {
            b.getMethod().getDeclaringClass().addTag(new KeyTag(255, 0, 0, "Parity: Top"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(45, 255, 84, "Parity: Bottom"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(255, 248, 35, "Parity: Even"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(174, 210, 255, "Parity: Odd"));
        }
    }

    private void addColorTag(ValueBox vb, String type) {
        if (type.equals("bottom")) {
            vb.addTag(new ColorTag(1));
        } else if (type.equals("top")) {
            vb.addTag(new ColorTag(0));
        } else if (type.equals("even")) {
            vb.addTag(new ColorTag(2));
        } else if (type.equals("odd")) {
            vb.addTag(new ColorTag(3));
        }
    }
}

