/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.RefLikeType;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.nullcheck.BranchedRefVarsAnalysis;
import soot.tagkit.ColorTag;
import soot.tagkit.KeyTag;
import soot.tagkit.StringTag;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FlowSet;

public class NullPointerColorer
extends BodyTransformer {
    public NullPointerColorer(Singletons.Global g) {
    }

    public static NullPointerColorer v() {
        return G.v().NullPointerColorer();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        BranchedRefVarsAnalysis analysis = new BranchedRefVarsAnalysis(new CompleteUnitGraph(b));
        for (Stmt s : b.getUnits()) {
            Iterator usesIt = s.getUseBoxes().iterator();
            FlowSet beforeSet = (FlowSet)analysis.getFlowBefore(s);
            while (usesIt.hasNext()) {
                ValueBox vBox = (ValueBox)usesIt.next();
                this.addColorTags(vBox, beforeSet, s, analysis);
            }
            Iterator defsIt = s.getDefBoxes().iterator();
            FlowSet afterSet = (FlowSet)analysis.getFallFlowAfter(s);
            while (defsIt.hasNext()) {
                ValueBox vBox = (ValueBox)defsIt.next();
                this.addColorTags(vBox, afterSet, s, analysis);
            }
        }
        Iterator keysIt = b.getMethod().getDeclaringClass().getTags().iterator();
        boolean keysAdded = false;
        while (keysIt.hasNext()) {
            if (!(keysIt.next() instanceof KeyTag)) continue;
            keysAdded = true;
        }
        if (!keysAdded) {
            b.getMethod().getDeclaringClass().addTag(new KeyTag(0, "Nullness: Null"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(1, "Nullness: Not Null"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(3, "Nullness: Nullness Unknown"));
        }
    }

    private void addColorTags(ValueBox vBox, FlowSet set, Stmt s, BranchedRefVarsAnalysis analysis) {
        Value val = vBox.getValue();
        if (val.getType() instanceof RefLikeType) {
            int vInfo = analysis.anyRefInfo(val, set);
            switch (vInfo) {
                case 1: {
                    s.addTag(new StringTag(val + ": Null"));
                    vBox.addTag(new ColorTag(0));
                    break;
                }
                case 2: {
                    s.addTag(new StringTag(val + ": NonNull"));
                    vBox.addTag(new ColorTag(1));
                    break;
                }
                case 99: {
                    s.addTag(new StringTag(val + ": Nullness Unknown"));
                    vBox.addTag(new ColorTag(3));
                    break;
                }
                case 0: {
                    s.addTag(new StringTag(val + ": Nullness Unknown"));
                    vBox.addTag(new ColorTag(3));
                }
            }
        }
    }
}

