/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.callgraph;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.MethodOrMethodContext;
import soot.jimple.toolkits.callgraph.MethodToContexts;
import soot.tagkit.Host;
import soot.tagkit.LinkTag;

public class CallGraphTagger
extends BodyTransformer {
    private MethodToContexts methodToContexts;

    public CallGraphTagger(Singletons.Global g) {
    }

    public static CallGraphTagger v() {
        return G.v().CallGraphTagger();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        CallGraph cg = Scene.v().getCallGraph();
        if (this.methodToContexts == null) {
            this.methodToContexts = new MethodToContexts(Scene.v().getReachableMethods().listener());
        }
        for (Stmt s : b.getUnits()) {
            Iterator edges = cg.edgesOutOf(s);
            while (edges.hasNext()) {
                Edge e = (Edge)edges.next();
                SootMethod m = e.tgt();
                s.addTag(new LinkTag("CallGraph: Type: " + Edge.kindToString(e.kind()) + " Target Method/Context: " + e.getTgt().toString(), m, m.getDeclaringClass().getName()));
            }
        }
        SootMethod m = b.getMethod();
        for (MethodOrMethodContext momc : this.methodToContexts.get(m)) {
            Iterator callerEdges = cg.edgesInto(momc);
            while (callerEdges.hasNext()) {
                SootMethod methodCaller;
                Edge callEdge = (Edge)callerEdges.next();
                Host src = methodCaller = callEdge.src();
                if (callEdge.srcUnit() != null) {
                    src = callEdge.srcUnit();
                }
                m.addTag(new LinkTag("CallGraph: Source Type: " + Edge.kindToString(callEdge.kind()) + " Source Method/Context: " + callEdge.getSrc().toString(), src, methodCaller.getDeclaringClass().getName()));
            }
        }
    }
}

