/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import soot.jimple.toolkits.annotation.arraycheck.IntContainer;
import soot.jimple.toolkits.annotation.arraycheck.WeightedDirectedEdge;

class WeightedDirectedSparseGraph {
    private boolean isUnknown;
    private Hashtable sources = new Hashtable();
    private HashSet vertexes = new HashSet();
    private HashSet reachableNodes = new HashSet();
    private HashSet reachableEdges = new HashSet();
    private Hashtable distance = new Hashtable();
    private Hashtable pei = new Hashtable();

    public WeightedDirectedSparseGraph(HashSet vertexset) {
        this(vertexset, false);
    }

    public WeightedDirectedSparseGraph(HashSet vertexset, boolean isTop) {
        this.vertexes = vertexset;
        this.isUnknown = !isTop;
    }

    public void setTop() {
        this.isUnknown = false;
        this.sources.clear();
    }

    public HashSet getVertexes() {
        return this.vertexes;
    }

    public void setVertexes(HashSet newset) {
        this.vertexes = newset;
        this.sources.clear();
    }

    public void addEdge(Object from, Object to, int w) {
        IntContainer weight;
        if (this.isUnknown) {
            throw new RuntimeException("Unknown graph can not have edges");
        }
        Hashtable<Object, IntContainer> targets = (Hashtable<Object, IntContainer>)this.sources.get(from);
        if (targets == null) {
            targets = new Hashtable<Object, IntContainer>();
            this.sources.put(from, targets);
        }
        if ((weight = (IntContainer)targets.get(to)) == null) {
            weight = new IntContainer(w);
            targets.put(to, weight);
        } else if (weight.value > w) {
            weight.value = w;
        }
    }

    public void addMutualEdges(Object from, Object to, int weight) {
        this.addEdge(from, to, weight);
        this.addEdge(to, from, -weight);
    }

    public void removeEdge(Object from, Object to) {
        Hashtable targets = (Hashtable)this.sources.get(from);
        if (targets == null) {
            return;
        }
        targets.remove(to);
        if (targets.size() == 0) {
            this.sources.remove(from);
        }
    }

    public boolean hasEdge(Object from, Object to) {
        Hashtable targets = (Hashtable)this.sources.get(from);
        if (targets == null) {
            return false;
        }
        return targets.containsKey(to);
    }

    public int edgeWeight(Object from, Object to) {
        Hashtable targets = (Hashtable)this.sources.get(from);
        if (targets == null) {
            throw new RuntimeException("No such edge (" + from + " ," + to + ") exists.");
        }
        IntContainer weight = (IntContainer)targets.get(to);
        if (weight == null) {
            throw new RuntimeException("No such edge (" + from + ", " + to + ") exists.");
        }
        return weight.value;
    }

    public void unionSelf(WeightedDirectedSparseGraph other) {
        if (other == null) {
            return;
        }
        WeightedDirectedSparseGraph othergraph = other;
        if (othergraph.isUnknown) {
            return;
        }
        if (this.isUnknown) {
            this.addAll(othergraph);
        }
        ArrayList sourceList = new ArrayList(this.sources.keySet());
        for (Object srcKey : sourceList) {
            Hashtable src1 = (Hashtable)this.sources.get(srcKey);
            Hashtable src2 = (Hashtable)othergraph.sources.get(srcKey);
            if (src2 == null) {
                this.sources.remove(srcKey);
                continue;
            }
            ArrayList targetList = new ArrayList(src1.keySet());
            for (Object target : targetList) {
                IntContainer w1 = (IntContainer)src1.get(target);
                IntContainer w2 = (IntContainer)src2.get(target);
                if (w2 == null) {
                    src1.remove(target);
                    continue;
                }
                if (w2.value <= w1.value) continue;
                w1.value = w2.value;
            }
            if (src1.size() != 0) continue;
            this.sources.remove(srcKey);
        }
    }

    public void widenEdges(WeightedDirectedSparseGraph othergraph) {
        WeightedDirectedSparseGraph other = othergraph;
        if (other.isUnknown) {
            return;
        }
        Hashtable othersources = other.sources;
        ArrayList sourceList = new ArrayList(this.sources.keySet());
        for (Object src : sourceList) {
            Hashtable thistargets = (Hashtable)this.sources.get(src);
            Hashtable othertargets = (Hashtable)othersources.get(src);
            if (othertargets == null) {
                this.sources.remove(src);
                continue;
            }
            ArrayList targetList = new ArrayList(thistargets.keySet());
            for (Object target : targetList) {
                IntContainer thisweight = (IntContainer)thistargets.get(target);
                IntContainer otherweight = (IntContainer)othertargets.get(target);
                if (otherweight == null) {
                    thistargets.remove(target);
                    continue;
                }
                if (thisweight.value <= otherweight.value) continue;
                thistargets.remove(target);
            }
            if (thistargets.size() != 0) continue;
            this.sources.remove(src);
        }
    }

    public void killNode(Object tokill) {
        if (!this.vertexes.contains(tokill)) {
            return;
        }
        this.makeShortestPathGraph();
        ArrayList sourceList = new ArrayList(this.sources.keySet());
        for (Object src : sourceList) {
            Hashtable targets = (Hashtable)this.sources.get(src);
            targets.remove(tokill);
            if (targets.size() != 0) continue;
            this.sources.remove(src);
        }
        this.sources.remove(tokill);
        this.makeShortestPathGraph();
    }

    public void updateWeight(Object which, int c) {
        for (Object from : this.sources.keySet()) {
            Hashtable targets = (Hashtable)this.sources.get(from);
            IntContainer weight = (IntContainer)targets.get(which);
            if (weight == null) continue;
            weight.value += c;
        }
        Hashtable toset = (Hashtable)this.sources.get(which);
        if (toset == null) {
            return;
        }
        for (Object to : toset.keySet()) {
            IntContainer weight = (IntContainer)toset.get(to);
            weight.value -= c;
        }
    }

    public void clear() {
        this.sources.clear();
    }

    public void replaceAllEdges(WeightedDirectedSparseGraph other) {
        this.isUnknown = other.isUnknown;
        this.vertexes = other.vertexes;
        this.sources = other.sources;
    }

    public void addBoundedAll(WeightedDirectedSparseGraph another) {
        this.isUnknown = another.isUnknown;
        Hashtable othersources = another.sources;
        for (Object src : this.vertexes) {
            Hashtable othertargets = (Hashtable)othersources.get(src);
            if (othertargets == null) continue;
            Hashtable thistargets = new Hashtable();
            for (Object key : othertargets.keySet()) {
                if (!this.vertexes.contains(key)) continue;
                IntContainer weight = (IntContainer)othertargets.get(key);
                thistargets.put(key, weight.dup());
            }
            if (thistargets.size() <= 0) continue;
            this.sources.put(src, thistargets);
        }
    }

    public void addAll(WeightedDirectedSparseGraph othergraph) {
        WeightedDirectedSparseGraph another = othergraph;
        this.isUnknown = another.isUnknown;
        this.clear();
        Hashtable othersources = another.sources;
        for (Object src : othersources.keySet()) {
            Hashtable othertargets = (Hashtable)othersources.get(src);
            Hashtable thistargets = new Hashtable(othersources.size());
            this.sources.put(src, thistargets);
            for (Object target : othertargets.keySet()) {
                IntContainer otherweight = (IntContainer)othertargets.get(target);
                thistargets.put(target, otherweight.dup());
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof WeightedDirectedSparseGraph)) {
            return false;
        }
        WeightedDirectedSparseGraph othergraph = (WeightedDirectedSparseGraph)other;
        if (this.isUnknown != othergraph.isUnknown) {
            return false;
        }
        if (this.isUnknown) {
            return true;
        }
        Hashtable othersources = othergraph.sources;
        if (this.sources.size() != othersources.size()) {
            return false;
        }
        for (Object src : this.sources.keySet()) {
            Hashtable thistarget = (Hashtable)this.sources.get(src);
            Hashtable othertarget = (Hashtable)othersources.get(src);
            if (othertarget == null) {
                return false;
            }
            if (thistarget.size() != othertarget.size()) {
                return false;
            }
            for (Object target : thistarget.keySet()) {
                IntContainer thisweight = (IntContainer)thistarget.get(target);
                IntContainer otherweight = (IntContainer)othertarget.get(target);
                if (otherweight == null) {
                    return false;
                }
                if (thisweight.value == otherweight.value) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String graphstring = "WeightedDirectedSparseGraph:\n";
        graphstring = graphstring + this.vertexes + "\n";
        for (Object src : this.sources.keySet()) {
            graphstring = graphstring + src + " : ";
            Hashtable targets = (Hashtable)this.sources.get(src);
            for (Object target : targets.keySet()) {
                IntContainer weight = (IntContainer)targets.get(target);
                graphstring = graphstring + target + "(" + weight.value + ")  ";
            }
            graphstring = graphstring + "\n";
        }
        return graphstring;
    }

    public WeightedDirectedSparseGraph dup() {
        WeightedDirectedSparseGraph newone = new WeightedDirectedSparseGraph(this.vertexes);
        newone.addAll(this);
        return newone;
    }

    public boolean makeShortestPathGraph() {
        boolean nonegcycle = true;
        ArrayList srcList = new ArrayList(this.sources.keySet());
        for (Object src : srcList) {
            if (this.SSSPFinder(src)) continue;
            nonegcycle = false;
        }
        return nonegcycle;
    }

    private boolean SSSPFinder(Object src) {
        Hashtable outedges = (Hashtable)this.sources.get(src);
        if (outedges == null) {
            return true;
        }
        if (outedges.size() == 0) {
            return true;
        }
        this.InitializeSingleSource(src);
        this.getReachableNodesAndEdges(src);
        int vSize = this.reachableNodes.size();
        for (int i = 0; i < vSize; ++i) {
            for (WeightedDirectedEdge edge : this.reachableEdges) {
                this.Relax(edge.from, edge.to, edge.weight);
            }
        }
        this.distance.remove(src);
        for (WeightedDirectedEdge edge : this.reachableEdges) {
            IntContainer dto;
            IntContainer dfrom = (IntContainer)this.distance.get(edge.from);
            if (dfrom == null || (dto = (IntContainer)this.distance.get(edge.to)) == null || dto.value <= dfrom.value + edge.weight) continue;
            return false;
        }
        outedges.clear();
        for (Object to : this.distance.keySet()) {
            IntContainer dist = (IntContainer)this.distance.get(to);
            outedges.put(to, dist.dup());
        }
        return true;
    }

    private void InitializeSingleSource(Object src) {
        this.reachableNodes.clear();
        this.reachableEdges.clear();
        this.pei.clear();
        this.distance.clear();
        this.distance.put(src, new IntContainer(0));
    }

    private void getReachableNodesAndEdges(Object src) {
        LinkedList<Object> worklist = new LinkedList<Object>();
        this.reachableNodes.add(src);
        worklist.add(src);
        while (!worklist.isEmpty()) {
            Object from = worklist.removeFirst();
            Hashtable targets = (Hashtable)this.sources.get(from);
            if (targets == null) continue;
            for (Object target : targets.keySet()) {
                if (!this.reachableNodes.contains(target)) {
                    worklist.add(target);
                    this.reachableNodes.add(target);
                }
                IntContainer weight = (IntContainer)targets.get(target);
                this.reachableEdges.add(new WeightedDirectedEdge(from, target, weight.value));
            }
        }
    }

    private void Relax(Object from, Object to, int weight) {
        IntContainer dfrom = (IntContainer)this.distance.get(from);
        IntContainer dto = (IntContainer)this.distance.get(to);
        if (dfrom != null) {
            int vfrom = dfrom.value;
            int vnew = vfrom + weight;
            if (dto == null) {
                this.distance.put(to, new IntContainer(vnew));
                this.pei.put(to, from);
            } else {
                int vto = dto.value;
                if (vto > vnew) {
                    this.distance.put(to, new IntContainer(vnew));
                    this.pei.put(to, from);
                }
            }
        }
    }
}

