/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.List;
import soot.toolkits.graph.HashMutableDirectedGraph;

class ExtendedHashMutableDirectedGraph
extends HashMutableDirectedGraph {
    public void addEdge(Object from, Object to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
    }

    public void addMutualEdge(Object from, Object to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
        super.addEdge(to, from);
    }

    public void skipNode(Object node) {
        int i;
        if (!super.containsNode(node)) {
            return;
        }
        Object[] preds = this.getPredsOf(node).toArray();
        Object[] succs = this.getSuccsOf(node).toArray();
        for (i = 0; i < preds.length; ++i) {
            for (int j = 0; j < succs.length; ++j) {
                if (preds[i] == succs[j]) continue;
                super.addEdge(preds[i], succs[j]);
            }
        }
        for (i = 0; i < preds.length; ++i) {
            super.removeEdge(preds[i], node);
        }
        for (int j = 0; j < succs.length; ++j) {
            super.removeEdge(node, succs[j]);
        }
        super.removeNode(node);
    }

    public void mergeWith(ExtendedHashMutableDirectedGraph other) {
        List nodes = other.getNodes();
        for (Object node : nodes) {
            List succs = other.getSuccsOf(node);
            for (Object succ : succs) {
                this.addEdge(node, succ);
            }
        }
    }

    public String toString() {
        String rtn = "Graph:\n";
        List nodes = super.getNodes();
        for (Object node : nodes) {
            List succs = super.getSuccsOf(node);
            for (Object succ : succs) {
                rtn = rtn + node + "\t --- \t" + succ + "\n";
            }
        }
        return rtn;
    }
}

