/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.Hierarchy;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AddExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.FieldRef;
import soot.jimple.GeExpr;
import soot.jimple.GtExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.jimple.toolkits.annotation.arraycheck.Array2ndDimensionSymbol;
import soot.jimple.toolkits.annotation.arraycheck.ArrayIndexLivenessAnalysis;
import soot.jimple.toolkits.annotation.arraycheck.BoundedPriorityList;
import soot.jimple.toolkits.annotation.arraycheck.ClassFieldAnalysis;
import soot.jimple.toolkits.annotation.arraycheck.FlowGraphEdge;
import soot.jimple.toolkits.annotation.arraycheck.IntContainer;
import soot.jimple.toolkits.annotation.arraycheck.IntValueContainer;
import soot.jimple.toolkits.annotation.arraycheck.MethodLocal;
import soot.jimple.toolkits.annotation.arraycheck.RectangularArrayFinder;
import soot.jimple.toolkits.annotation.arraycheck.WeightedDirectedSparseGraph;
import soot.options.Options;
import soot.toolkits.graph.ArrayRefBlockGraph;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.SlowPseudoTopologicalOrderer;

class ArrayBoundsCheckerAnalysis {
    protected Map blockToBeforeFlow;
    protected Map unitToBeforeFlow;
    private Map edgeMap;
    private Set edgeSet;
    private HashMap stableRoundOfUnits;
    private boolean flowStable = false;
    private Body body;
    private ArrayRefBlockGraph graph;
    private IntContainer zero = new IntContainer(0);
    private boolean fieldin = false;
    private HashMap localToFieldRef;
    private HashMap fieldToFieldRef;
    private HashSet allFieldRefs;
    private int strictness = 2;
    private boolean arrayin = false;
    private HashMap localToArrayRef;
    private HashSet allArrayRefs;
    private boolean csin = false;
    private HashMap localToExpr;
    private boolean classfieldin = false;
    private ClassFieldAnalysis cfield;
    private boolean rectarray = false;
    private HashSet rectarrayset;
    private HashSet multiarraylocals;
    private ArrayIndexLivenessAnalysis ailanalysis;

    public ArrayBoundsCheckerAnalysis(Body body, boolean takeClassField, boolean takeFieldRef, boolean takeArrayRef, boolean takeCSE, boolean takeRectArray) {
        this.classfieldin = takeClassField;
        this.fieldin = takeFieldRef;
        this.arrayin = takeArrayRef;
        this.csin = takeCSE;
        this.rectarray = takeRectArray;
        this.body = body;
        SootMethod thismethod = body.getMethod();
        if (Options.v().debug()) {
            G.v().out.println("ArrayBoundsCheckerAnalysis started on  " + thismethod.getName());
        }
        this.ailanalysis = new ArrayIndexLivenessAnalysis(new CompleteUnitGraph(body), this.fieldin, this.arrayin, this.csin, this.rectarray);
        if (this.fieldin) {
            this.localToFieldRef = this.ailanalysis.getLocalToFieldRef();
            this.fieldToFieldRef = this.ailanalysis.getFieldToFieldRef();
            this.allFieldRefs = this.ailanalysis.getAllFieldRefs();
        }
        if (this.arrayin) {
            this.localToArrayRef = this.ailanalysis.getLocalToArrayRef();
            this.allArrayRefs = this.ailanalysis.getAllArrayRefs();
            if (this.rectarray) {
                this.multiarraylocals = this.ailanalysis.getMultiArrayLocals();
                this.rectarrayset = new HashSet();
                RectangularArrayFinder pgbuilder = RectangularArrayFinder.v();
                for (Local local : this.multiarraylocals) {
                    MethodLocal mlocal = new MethodLocal(thismethod, local);
                    if (!pgbuilder.isRectangular(mlocal)) continue;
                    this.rectarrayset.add(local);
                }
            }
        }
        if (this.csin) {
            this.localToExpr = this.ailanalysis.getLocalToExpr();
        }
        if (this.classfieldin) {
            this.cfield = ClassFieldAnalysis.v();
        }
        this.graph = new ArrayRefBlockGraph(body);
        this.blockToBeforeFlow = new HashMap(this.graph.size() * 2 + 1, 0.7f);
        this.edgeMap = new HashMap(this.graph.size() * 2 + 1, 0.7f);
        this.edgeSet = this.buildEdgeSet(this.graph);
        this.doAnalysis();
        this.convertToUnitEntry();
        if (Options.v().debug()) {
            G.v().out.println("ArrayBoundsCheckerAnalysis finished.");
        }
    }

    private void convertToUnitEntry() {
        this.unitToBeforeFlow = new HashMap();
        for (Block block : this.blockToBeforeFlow.keySet()) {
            Unit first = block.getHead();
            this.unitToBeforeFlow.put(first, this.blockToBeforeFlow.get(block));
        }
    }

    public Set buildEdgeSet(DirectedGraph dg) {
        HashSet<FlowGraphEdge> edges = new HashSet<FlowGraphEdge>();
        Iterator unitIt = dg.iterator();
        while (unitIt.hasNext()) {
            Object s = unitIt.next();
            List preds = this.graph.getPredsOf(s);
            List succs = this.graph.getSuccsOf(s);
            if (preds.size() == 0) {
                edges.add(new FlowGraphEdge(s, s));
            }
            if (succs.size() == 0) {
                edges.add(new FlowGraphEdge(s, s));
                continue;
            }
            Iterator succIt = succs.iterator();
            while (succIt.hasNext()) {
                edges.add(new FlowGraphEdge(s, succIt.next()));
            }
        }
        return edges;
    }

    public Object getFlowBefore(Object s) {
        return this.unitToBeforeFlow.get(s);
    }

    private void mergebunch(Object[] ins, Object s, Object prevOut, Object out) {
        int i;
        WeightedDirectedSparseGraph prevgraph = (WeightedDirectedSparseGraph)prevOut;
        WeightedDirectedSparseGraph outgraph = (WeightedDirectedSparseGraph)out;
        WeightedDirectedSparseGraph[] ingraphs = new WeightedDirectedSparseGraph[ins.length];
        for (i = 0; i < ins.length; ++i) {
            ingraphs[i] = (WeightedDirectedSparseGraph)ins[i];
        }
        outgraph.addBoundedAll(ingraphs[0]);
        for (i = 1; i < ingraphs.length; ++i) {
            outgraph.unionSelf(ingraphs[i]);
            outgraph.makeShortestPathGraph();
        }
        outgraph.widenEdges(prevgraph);
    }

    private void doAnalysis() {
        HashSet livelocals;
        Block block;
        Date start = new Date();
        if (Options.v().debug()) {
            G.v().out.println("Building PseudoTopological order list on " + start);
        }
        LinkedList allUnits = (LinkedList)SlowPseudoTopologicalOrderer.v().newList(this.graph);
        BoundedPriorityList changedUnits = new BoundedPriorityList(allUnits);
        Date finish = new Date();
        if (Options.v().debug()) {
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime % 60000L / 1000L;
            G.v().out.println("Building PseudoTopological order finished. It took " + mins + " mins and " + secs + " secs.");
        }
        start = new Date();
        if (Options.v().debug()) {
            G.v().out.println("Doing analysis started on " + start);
        }
        for (int i = 0; i < allUnits.size(); ++i) {
            Block block2 = (Block)allUnits.get(i);
            Unit tail = block2.getTail();
            HashSet livelocals2 = (HashSet)this.ailanalysis.getFlowAfter(tail);
        }
        HashSet changedUnitsSet = new HashSet(allUnits);
        FlowGraphEdge tmpEdge = new FlowGraphEdge();
        HashSet<Block> unvisitedNodes = new HashSet<Block>(this.graph.size() * 2 + 1, 0.7f);
        int numNodes = this.graph.size();
        Iterator blockIt = this.graph.iterator();
        while (blockIt.hasNext()) {
            block = (Block)blockIt.next();
            livelocals = (HashSet)this.ailanalysis.getFlowBefore(block.getHead());
            livelocals.add(this.zero);
        }
        this.stableRoundOfUnits = new HashMap();
        Iterator it = this.graph.iterator();
        while (it.hasNext()) {
            block = (Block)it.next();
            unvisitedNodes.add(block);
            this.stableRoundOfUnits.put(block, new Integer(0));
            livelocals = (HashSet)this.ailanalysis.getFlowBefore(block.getHead());
            this.blockToBeforeFlow.put(block, new WeightedDirectedSparseGraph(livelocals, false));
        }
        for (FlowGraphEdge edge : this.edgeSet) {
            Block target = (Block)edge.to;
            HashSet livelocals3 = (HashSet)this.ailanalysis.getFlowBefore(target.getHead());
            this.edgeMap.put(edge, new WeightedDirectedSparseGraph(livelocals3, false));
        }
        List headlist = this.graph.getHeads();
        for (Object head : headlist) {
            FlowGraphEdge edge = new FlowGraphEdge(head, head);
            WeightedDirectedSparseGraph initgraph = (WeightedDirectedSparseGraph)this.edgeMap.get(edge);
            initgraph.setTop();
        }
        WeightedDirectedSparseGraph beforeFlow = new WeightedDirectedSparseGraph(null, false);
        while (!changedUnits.isEmpty()) {
            Object s = changedUnits.removeFirst();
            changedUnitsSet.remove(s);
            WeightedDirectedSparseGraph previousBeforeFlow = (WeightedDirectedSparseGraph)this.blockToBeforeFlow.get(s);
            beforeFlow.setVertexes(previousBeforeFlow.getVertexes());
            List preds = this.graph.getPredsOf(s);
            if (preds.size() == 0) {
                tmpEdge.changeEndUnits(s, s);
                this.copy(this.edgeMap.get(tmpEdge), beforeFlow);
            } else if (preds.size() == 1) {
                tmpEdge.changeEndUnits(preds.get(0), s);
                this.copy(this.edgeMap.get(tmpEdge), beforeFlow);
            } else {
                Object[] predFlows = new Object[preds.size()];
                boolean allUnvisited = true;
                Iterator predIt = preds.iterator();
                int index = 0;
                int lastVisited = 0;
                while (predIt.hasNext()) {
                    Object pred = predIt.next();
                    tmpEdge.changeEndUnits(pred, s);
                    if (!unvisitedNodes.contains(pred)) {
                        allUnvisited = false;
                        lastVisited = index;
                    }
                    predFlows[index++] = this.edgeMap.get(tmpEdge);
                }
                if (allUnvisited) {
                    G.v().out.println("Warning : see all unvisited node");
                } else {
                    Object tmp = predFlows[0];
                    predFlows[0] = predFlows[lastVisited];
                    predFlows[lastVisited] = tmp;
                }
                this.mergebunch(predFlows, s, previousBeforeFlow, beforeFlow);
            }
            this.copy(beforeFlow, previousBeforeFlow);
            List changedSuccs = this.flowThrough(beforeFlow, s);
            for (int i = 0; i < changedSuccs.size(); ++i) {
                Object succ = changedSuccs.get(i);
                if (changedUnitsSet.contains(succ)) continue;
                changedUnits.add(succ);
                changedUnitsSet.add(succ);
            }
            unvisitedNodes.remove(s);
            this.flowStable = unvisitedNodes.isEmpty();
        }
        finish = new Date();
        if (Options.v().debug()) {
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime / 60000L / 1000L;
            G.v().out.println("Doing analysis finished. It took " + mins + " mins and " + secs + "secs.");
        }
    }

    private List flowThrough(Object inValue, Object unit) {
        ArrayList changedSuccs = new ArrayList();
        WeightedDirectedSparseGraph ingraph = (WeightedDirectedSparseGraph)inValue;
        Block block = (Block)unit;
        List succs = block.getSuccs();
        Unit s = block.getHead();
        Unit nexts = block.getSuccOf(s);
        while (nexts != null) {
            this.assertArrayRef(ingraph, s);
            this.assertNormalExpr(ingraph, s);
            s = nexts;
            nexts = block.getSuccOf(nexts);
        }
        if (s instanceof IfStmt) {
            if (!this.assertBranchStmt(ingraph, s, block, succs, changedSuccs)) {
                this.updateOutEdges(ingraph, block, succs, changedSuccs);
            }
        } else {
            this.assertArrayRef(ingraph, s);
            this.assertNormalExpr(ingraph, s);
            this.updateOutEdges(ingraph, block, succs, changedSuccs);
        }
        return changedSuccs;
    }

    private void assertArrayRef(Object in, Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return;
        }
        Stmt s = (Stmt)unit;
        WeightedDirectedSparseGraph ingraph = (WeightedDirectedSparseGraph)in;
        if (!s.containsArrayRef()) {
            return;
        }
        ArrayRef op = s.getArrayRef();
        Value base = op.getBase();
        Value index = op.getIndex();
        HashSet livelocals = (HashSet)this.ailanalysis.getFlowAfter(s);
        if (!livelocals.contains(base) && !livelocals.contains(index)) {
            return;
        }
        if (index instanceof IntConstant) {
            int weight = ((IntConstant)index).value;
            weight = -1 - weight;
            ingraph.addEdge(base, this.zero, weight);
        } else {
            ingraph.addEdge(base, index, -1);
            ingraph.addEdge(index, this.zero, 0);
        }
    }

    private void assertNormalExpr(Object in, Unit s) {
        Value size;
        Value rhs;
        Value base;
        int inc_w;
        Value op2;
        Value op1;
        HashSet exprs;
        SootField field;
        Stmt stmt;
        WeightedDirectedSparseGraph ingraph = (WeightedDirectedSparseGraph)in;
        if (this.fieldin && (stmt = (Stmt)s).containsInvokeExpr()) {
            Value para;
            HashSet tokills = new HashSet();
            InvokeExpr expr = stmt.getInvokeExpr();
            List parameters = expr.getArgs();
            if (this.strictness == 0) {
                Value base2;
                Type type;
                Hierarchy hierarchy = Scene.v().getActiveHierarchy();
                for (int i = 0; i < parameters.size(); ++i) {
                    para = (Value)parameters.get(i);
                    Type type2 = para.getType();
                    if (!(type2 instanceof RefType)) continue;
                    SootClass pclass = ((RefType)type2).getSootClass();
                    for (Value local : this.localToFieldRef.keySet()) {
                        Type ltype = local.getType();
                        SootClass lclass = ((RefType)ltype).getSootClass();
                        if (!hierarchy.isClassSuperclassOfIncluding(pclass, lclass) && !hierarchy.isClassSuperclassOfIncluding(lclass, pclass)) continue;
                        HashSet toadd = (HashSet)this.localToFieldRef.get(local);
                        tokills.addAll(toadd);
                    }
                }
                if (expr instanceof InstanceInvokeExpr && (type = (base2 = ((InstanceInvokeExpr)expr).getBase()).getType()) instanceof RefType) {
                    SootClass pclass = ((RefType)type).getSootClass();
                    for (Value local : this.localToFieldRef.keySet()) {
                        Type ltype = local.getType();
                        SootClass lclass = ((RefType)ltype).getSootClass();
                        if (!hierarchy.isClassSuperclassOfIncluding(pclass, lclass) && !hierarchy.isClassSuperclassOfIncluding(lclass, pclass)) continue;
                        HashSet toadd = (HashSet)this.localToFieldRef.get(local);
                        tokills.addAll(toadd);
                    }
                }
            } else if (this.strictness == 1) {
                boolean killall = false;
                if (expr instanceof InstanceInvokeExpr) {
                    killall = true;
                } else {
                    for (int i = 0; i < parameters.size(); ++i) {
                        para = (Value)parameters.get(i);
                        if (!(para.getType() instanceof RefType)) continue;
                        killall = true;
                        break;
                    }
                }
                if (killall) {
                    Iterator keyIt = this.localToFieldRef.keySet().iterator();
                    while (keyIt.hasNext()) {
                        HashSet toadd = (HashSet)this.localToFieldRef.get(keyIt.next());
                        tokills.addAll(toadd);
                    }
                }
            } else if (this.strictness == 2) {
                HashSet vertexes = ingraph.getVertexes();
                for (Object node : vertexes) {
                    if (!(node instanceof FieldRef)) continue;
                    ingraph.killNode(node);
                }
            }
        }
        if (this.arrayin && (stmt = (Stmt)s).containsInvokeExpr() && this.strictness == 2) {
            HashSet vertexes = ingraph.getVertexes();
            for (Object node : vertexes) {
                if (!(node instanceof ArrayRef)) continue;
                ingraph.killNode(node);
            }
        }
        if (!(s instanceof AssignStmt)) {
            return;
        }
        Value leftOp = ((AssignStmt)s).getLeftOp();
        Value rightOp = ((AssignStmt)s).getRightOp();
        HashSet livelocals = (HashSet)this.ailanalysis.getFlowAfter(s);
        if (this.fieldin) {
            HashSet fieldrefs;
            if (leftOp instanceof Local) {
                HashSet fieldrefs2 = (HashSet)this.localToFieldRef.get(leftOp);
                if (fieldrefs2 != null) {
                    for (Object ref : fieldrefs2) {
                        if (!livelocals.contains(ref)) continue;
                        ingraph.killNode(ref);
                    }
                }
            } else if (leftOp instanceof InstanceFieldRef && (fieldrefs = (HashSet)this.fieldToFieldRef.get(field = ((InstanceFieldRef)leftOp).getField())) != null) {
                for (Object ref : fieldrefs) {
                    if (!livelocals.contains(ref)) continue;
                    ingraph.killNode(ref);
                }
            }
        }
        if (this.arrayin) {
            HashSet vertexes;
            if (leftOp instanceof Local) {
                vertexes = ingraph.getVertexes();
                for (Object node : vertexes) {
                    Object base3;
                    if (node instanceof ArrayRef) {
                        base3 = ((ArrayRef)node).getBase();
                        Value index = ((ArrayRef)node).getIndex();
                        if (base3.equals(leftOp) || index.equals(leftOp)) {
                            ingraph.killNode(node);
                        }
                    }
                    if (!this.rectarray || !(node instanceof Array2ndDimensionSymbol) || !(base3 = ((Array2ndDimensionSymbol)node).getVar()).equals(leftOp)) continue;
                    ingraph.killNode(node);
                }
            } else if (leftOp instanceof ArrayRef) {
                vertexes = ingraph.getVertexes();
                for (Object node : vertexes) {
                    if (!(node instanceof ArrayRef)) continue;
                    ingraph.killNode(node);
                }
            }
        }
        if (!livelocals.contains(leftOp) && !livelocals.contains(rightOp)) {
            return;
        }
        if (rightOp.equals(leftOp)) {
            return;
        }
        if (this.csin && (exprs = (HashSet)this.localToExpr.get(leftOp)) != null) {
            Iterator exprIt = exprs.iterator();
            while (exprIt.hasNext()) {
                ingraph.killNode(exprIt.next());
            }
        }
        if (rightOp instanceof AddExpr) {
            op1 = ((AddExpr)rightOp).getOp1();
            op2 = ((AddExpr)rightOp).getOp2();
            if (op1 == leftOp && op2 instanceof IntConstant) {
                inc_w = ((IntConstant)op2).value;
                ingraph.updateWeight(leftOp, inc_w);
                return;
            }
            if (op2 == leftOp && op1 instanceof IntConstant) {
                inc_w = ((IntConstant)op1).value;
                ingraph.updateWeight(leftOp, inc_w);
                return;
            }
        }
        if (rightOp instanceof SubExpr) {
            op1 = ((SubExpr)rightOp).getOp1();
            op2 = ((SubExpr)rightOp).getOp2();
            if (op1 == leftOp && op2 instanceof IntConstant) {
                inc_w = -((IntConstant)op2).value;
                ingraph.updateWeight(leftOp, inc_w);
                return;
            }
        }
        ingraph.killNode(leftOp);
        if (rightOp instanceof IntConstant) {
            int inc_w2 = ((IntConstant)rightOp).value;
            ingraph.addMutualEdges(this.zero, leftOp, inc_w2);
            return;
        }
        if (rightOp instanceof Local) {
            ingraph.addMutualEdges(rightOp, leftOp, 0);
            return;
        }
        if (rightOp instanceof FieldRef) {
            IntValueContainer flength;
            if (this.fieldin) {
                ingraph.addMutualEdges(rightOp, leftOp, 0);
            }
            if (this.classfieldin && (flength = (IntValueContainer)this.cfield.getFieldInfo(field = ((FieldRef)rightOp).getField())) != null && flength.isInteger()) {
                ingraph.addMutualEdges(this.zero, leftOp, flength.getValue());
            }
            return;
        }
        if (this.arrayin && rightOp instanceof ArrayRef) {
            ingraph.addMutualEdges(rightOp, leftOp, 0);
            if (this.rectarray && this.rectarrayset.contains(base = ((ArrayRef)rightOp).getBase())) {
                ingraph.addMutualEdges(leftOp, Array2ndDimensionSymbol.v(base), 0);
            }
            return;
        }
        if (this.csin && (rhs = rightOp) instanceof BinopExpr) {
            Value op12 = ((BinopExpr)rhs).getOp1();
            Value op22 = ((BinopExpr)rhs).getOp2();
            if (rhs instanceof AddExpr) {
                if (op12 instanceof Local && op22 instanceof Local) {
                    ingraph.addMutualEdges(rhs, leftOp, 0);
                    return;
                }
            } else if (rhs instanceof MulExpr) {
                if (op12 instanceof Local || op22 instanceof Local) {
                    ingraph.addMutualEdges(rhs, leftOp, 0);
                    return;
                }
            } else if (rhs instanceof SubExpr && op22 instanceof Local) {
                ingraph.addMutualEdges(rhs, leftOp, 0);
                return;
            }
        }
        if (rightOp instanceof AddExpr) {
            op1 = ((AddExpr)rightOp).getOp1();
            op2 = ((AddExpr)rightOp).getOp2();
            if (op1 instanceof Local && op2 instanceof IntConstant) {
                inc_w = ((IntConstant)op2).value;
                ingraph.addMutualEdges(op1, leftOp, inc_w);
                return;
            }
            if (op2 instanceof Local && op1 instanceof IntConstant) {
                inc_w = ((IntConstant)op1).value;
                ingraph.addMutualEdges(op2, leftOp, inc_w);
                return;
            }
        }
        if (rightOp instanceof SubExpr) {
            op1 = ((SubExpr)rightOp).getOp1();
            op2 = ((SubExpr)rightOp).getOp2();
            if (op1 instanceof Local && op2 instanceof IntConstant) {
                inc_w = -((IntConstant)op2).value;
                ingraph.addMutualEdges(op1, leftOp, inc_w);
                return;
            }
        }
        if (rightOp instanceof NewArrayExpr) {
            size = ((NewArrayExpr)rightOp).getSize();
            if (size instanceof Local) {
                ingraph.addMutualEdges(size, leftOp, 0);
                return;
            }
            if (size instanceof IntConstant) {
                int inc_w3 = ((IntConstant)size).value;
                ingraph.addMutualEdges(this.zero, leftOp, inc_w3);
                return;
            }
        }
        if (rightOp instanceof NewMultiArrayExpr) {
            size = ((NewMultiArrayExpr)rightOp).getSize(0);
            if (size instanceof Local) {
                ingraph.addMutualEdges(size, leftOp, 0);
            } else if (size instanceof IntConstant) {
                int inc_w4 = ((IntConstant)size).value;
                ingraph.addMutualEdges(this.zero, leftOp, inc_w4);
            }
            if (this.arrayin && this.rectarray && ((NewMultiArrayExpr)rightOp).getSizeCount() > 1) {
                size = ((NewMultiArrayExpr)rightOp).getSize(1);
                if (size instanceof Local) {
                    ingraph.addMutualEdges(size, Array2ndDimensionSymbol.v(leftOp), 0);
                } else if (size instanceof IntConstant) {
                    int inc_w5 = ((IntConstant)size).value;
                    ingraph.addMutualEdges(this.zero, Array2ndDimensionSymbol.v(leftOp), inc_w5);
                }
            }
            return;
        }
        if (rightOp instanceof LengthExpr) {
            base = ((LengthExpr)rightOp).getOp();
            ingraph.addMutualEdges(base, leftOp, 0);
            return;
        }
    }

    private boolean assertBranchStmt(Object in, Unit s, Block current, List succs, List changedSuccs) {
        int weight;
        Object node2;
        Object node1;
        IfStmt ifstmt = (IfStmt)s;
        Value cmpcond = ifstmt.getCondition();
        if (!(cmpcond instanceof ConditionExpr)) {
            return false;
        }
        if (succs.size() != 2) {
            return false;
        }
        Stmt targetUnit = ifstmt.getTarget();
        Block targetBlock = (Block)succs.get(0);
        Block nextBlock = (Block)succs.get(1);
        if (!targetUnit.equals(targetBlock.getHead())) {
            Block swap = targetBlock;
            targetBlock = nextBlock;
            nextBlock = swap;
        }
        Value op1 = ((ConditionExpr)cmpcond).getOp1();
        Value op2 = ((ConditionExpr)cmpcond).getOp2();
        HashSet livelocals = (HashSet)this.ailanalysis.getFlowAfter(s);
        if (!livelocals.contains(op1) && !livelocals.contains(op2)) {
            return false;
        }
        WeightedDirectedSparseGraph ingraph = (WeightedDirectedSparseGraph)in;
        WeightedDirectedSparseGraph targetgraph = ingraph.dup();
        if (cmpcond instanceof EqExpr || cmpcond instanceof NeExpr) {
            node1 = op1;
            node2 = op2;
            weight = 0;
            if (node1 instanceof IntConstant) {
                weight = ((IntConstant)node1).value;
                node1 = this.zero;
            }
            if (node2 instanceof IntConstant) {
                weight = ((IntConstant)node2).value;
                node2 = this.zero;
            }
            if (node1 == node2) {
                return false;
            }
            if (cmpcond instanceof EqExpr) {
                targetgraph.addMutualEdges(node1, node2, weight);
            } else {
                ingraph.addMutualEdges(node1, node2, weight);
            }
        } else if (cmpcond instanceof GtExpr || cmpcond instanceof GeExpr) {
            node1 = op1;
            node2 = op2;
            weight = 0;
            if (node1 instanceof IntConstant) {
                weight += ((IntConstant)node1).value;
                node1 = this.zero;
            }
            if (node2 instanceof IntConstant) {
                weight -= ((IntConstant)node2).value;
                node2 = this.zero;
            }
            if (node1 == node2) {
                return false;
            }
            if (cmpcond instanceof GtExpr) {
                targetgraph.addEdge(node1, node2, weight - 1);
                ingraph.addEdge(node2, node1, -weight);
            } else {
                targetgraph.addEdge(node1, node2, weight);
                ingraph.addEdge(node2, node1, -weight - 1);
            }
        } else if (cmpcond instanceof LtExpr || cmpcond instanceof LeExpr) {
            node1 = op1;
            node2 = op2;
            weight = 0;
            if (node1 instanceof IntConstant) {
                weight -= ((IntConstant)node1).value;
                node1 = this.zero;
            }
            if (node2 instanceof IntConstant) {
                weight += ((IntConstant)node2).value;
                node2 = this.zero;
            }
            if (node1 == node2) {
                return false;
            }
            if (cmpcond instanceof LtExpr) {
                targetgraph.addEdge(node2, node1, weight - 1);
                ingraph.addEdge(node1, node2, -weight);
            } else {
                targetgraph.addEdge(node2, node1, weight);
                ingraph.addEdge(node1, node2, -weight - 1);
            }
        } else {
            return false;
        }
        FlowGraphEdge targetEdge = new FlowGraphEdge(current, targetBlock);
        WeightedDirectedSparseGraph prevtarget = (WeightedDirectedSparseGraph)this.edgeMap.get(targetEdge);
        boolean changed = false;
        targetgraph.makeShortestPathGraph();
        WeightedDirectedSparseGraph tmpgraph = new WeightedDirectedSparseGraph(prevtarget.getVertexes(), true);
        this.copy(targetgraph, tmpgraph);
        if (!tmpgraph.equals(prevtarget)) {
            prevtarget.replaceAllEdges(tmpgraph);
            changed = true;
        }
        if (changed) {
            changedSuccs.add(targetBlock);
        }
        FlowGraphEdge nextEdge = new FlowGraphEdge(current, nextBlock);
        WeightedDirectedSparseGraph prevnext = (WeightedDirectedSparseGraph)this.edgeMap.get(nextEdge);
        changed = false;
        ingraph.makeShortestPathGraph();
        tmpgraph = new WeightedDirectedSparseGraph(prevnext.getVertexes(), true);
        this.copy(ingraph, tmpgraph);
        if (!tmpgraph.equals(prevnext)) {
            prevnext.replaceAllEdges(tmpgraph);
            changed = true;
        }
        if (changed) {
            changedSuccs.add(nextBlock);
        }
        return true;
    }

    private void updateOutEdges(Object in, Block current, List succs, List changedSuccs) {
        WeightedDirectedSparseGraph ingraph = (WeightedDirectedSparseGraph)in;
        ingraph.makeShortestPathGraph();
        for (int i = 0; i < succs.size(); ++i) {
            Object next = succs.get(i);
            FlowGraphEdge nextEdge = new FlowGraphEdge(current, next);
            WeightedDirectedSparseGraph prevs = (WeightedDirectedSparseGraph)this.edgeMap.get(nextEdge);
            boolean changed = false;
            WeightedDirectedSparseGraph tmpgraph = new WeightedDirectedSparseGraph(prevs.getVertexes(), true);
            this.copy(ingraph, tmpgraph);
            if (!tmpgraph.equals(prevs)) {
                prevs.replaceAllEdges(tmpgraph);
                changed = true;
            }
            if (!changed) continue;
            changedSuccs.add(next);
        }
    }

    protected void copy(Object from, Object to) {
        WeightedDirectedSparseGraph fromgraph = (WeightedDirectedSparseGraph)from;
        WeightedDirectedSparseGraph tograph = (WeightedDirectedSparseGraph)to;
        tograph.clear();
        tograph.addBoundedAll(fromgraph);
    }

    protected void widenGraphs(Object current, Object before) {
        WeightedDirectedSparseGraph curgraphs = (WeightedDirectedSparseGraph)current;
        WeightedDirectedSparseGraph pregraphs = (WeightedDirectedSparseGraph)before;
        curgraphs.widenEdges(pregraphs);
        curgraphs.makeShortestPathGraph();
    }

    private void outputGraphs(Object graphs) {
        WeightedDirectedSparseGraph gs = (WeightedDirectedSparseGraph)graphs;
    }
}

