/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.util.Numberer;

public class TopoSorter {
    protected boolean ignoreTypes;
    protected PAG pag;
    protected int nextFinishNumber = 1;
    protected HashSet visited;

    public void sort() {
        Numberer.NumbererIterator it = this.pag.getVarNodeNumberer().iterator();
        while (it.hasNext()) {
            this.dfsVisit((VarNode)it.next());
        }
        this.visited = null;
    }

    public TopoSorter(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.visited = new HashSet();
    }

    protected void dfsVisit(VarNode n) {
        if (this.visited.contains(n)) {
            return;
        }
        this.visited.add(n);
        Node[] succs = this.pag.simpleLookup(n);
        for (int i = 0; i < succs.length; ++i) {
            if (!this.ignoreTypes && !this.pag.getTypeManager().castNeverFails(n.getType(), succs[i].getType())) continue;
            this.dfsVisit((VarNode)succs[i]);
        }
        n.setFinishingNumber(this.nextFinishNumber++);
    }
}

