/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Iterator;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.Numberer;
import soot.util.queue.QueueReader;

public final class PropIter
extends Propagator {
    protected PAG pag;

    public PropIter(PAG pag) {
        this.pag = pag;
    }

    public final void propagate() {
        boolean change;
        OnFlyCallGraph ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        Iterator it = this.pag.allocSources().iterator();
        while (it.hasNext()) {
            this.handleAllocNode((AllocNode)it.next());
        }
        int iteration = 1;
        do {
            change = false;
            TreeSet simpleSources = new TreeSet(this.pag.simpleSources());
            if (this.pag.getOpts().verbose()) {
                G.v().out.println("Iteration " + iteration++);
            }
            Iterator it2 = simpleSources.iterator();
            while (it2.hasNext()) {
                change = this.handleSimples((VarNode)it2.next()) | change;
            }
            if (ofcg != null) {
                Node addedSrc;
                QueueReader addedEdges = this.pag.edgeReader();
                Numberer.NumbererIterator srcIt = this.pag.getVarNodeNumberer().iterator();
                while (srcIt.hasNext()) {
                    VarNode src = (VarNode)srcIt.next();
                    ofcg.updatedNode(src);
                }
                ofcg.build();
                while ((addedSrc = (Node)addedEdges.next()) != null) {
                    Node addedTgt = (Node)addedEdges.next();
                    change = true;
                    if (addedSrc instanceof VarNode) {
                        PointsToSetInternal p2set = ((VarNode)addedSrc).getP2Set();
                        if (p2set == null) continue;
                        p2set.unFlushNew();
                        continue;
                    }
                    if (!(addedSrc instanceof AllocNode)) continue;
                    ((VarNode)addedTgt).makeP2Set().add((AllocNode)addedSrc);
                }
                if (change) {
                    new TopoSorter(this.pag, false).sort();
                }
            }
            it2 = this.pag.loadSources().iterator();
            while (it2.hasNext()) {
                change = this.handleLoads((FieldRefNode)it2.next()) | change;
            }
            it2 = this.pag.storeSources().iterator();
            while (it2.hasNext()) {
                change = this.handleStores((VarNode)it2.next()) | change;
            }
        } while (change);
    }

    protected final boolean handleAllocNode(AllocNode src) {
        boolean ret = false;
        Node[] targets = this.pag.allocLookup(src);
        for (int i = 0; i < targets.length; ++i) {
            ret = targets[i].makeP2Set().add(src) | ret;
        }
        return ret;
    }

    protected final boolean handleSimples(VarNode src) {
        boolean ret = false;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return false;
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (int i = 0; i < simpleTargets.length; ++i) {
            ret = simpleTargets[i].makeP2Set().addAll(srcSet, null) | ret;
        }
        return ret;
    }

    protected final boolean handleStores(VarNode src) {
        boolean ret = false;
        final PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return false;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        for (int i = 0; i < storeTargets.length; ++i) {
            FieldRefNode fr = (FieldRefNode)storeTargets[i];
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                public final void visit(Node n) {
                    AllocDotField nDotF = PropIter.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(srcSet, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        return ret;
    }

    protected final boolean handleLoads(FieldRefNode src) {
        boolean ret = false;
        final Node[] loadTargets = this.pag.loadLookup(src);
        final SparkField f = src.getField();
        ret = src.getBase().getP2Set().forall(new P2SetVisitor(){

            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF == null) {
                    return;
                }
                PointsToSetInternal set = nDotF.getP2Set();
                if (set.isEmpty()) {
                    return;
                }
                for (int i = 0; i < loadTargets.length; ++i) {
                    VarNode target = (VarNode)loadTargets[i];
                    if (!target.makeP2Set().addAll(set, null)) continue;
                    this.returnValue = true;
                }
            }
        }) | ret;
        return ret;
    }
}

