/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import soot.G;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.util.LargeNumberedMap;
import soot.util.Numberer;

public final class PropCycle
extends Propagator {
    private PAG pag;
    private OnFlyCallGraph ofcg;
    private Integer currentIteration;
    private LargeNumberedMap varNodeToIteration;
    private TypeManager typeManager;

    public PropCycle(PAG pag) {
        this.pag = pag;
        this.typeManager = (TypeManager)pag.getTypeManager();
        this.varNodeToIteration = new LargeNumberedMap(pag.getVarNodeNumberer());
    }

    public final void propagate() {
        boolean changed;
        this.ofcg = this.pag.getOnFlyCallGraph();
        boolean verbose = this.pag.getOpts().verbose();
        AbstractCollection bases = new HashSet<VarNode>();
        Numberer.NumbererIterator frnIt = this.pag.getFieldRefNodeNumberer().iterator();
        while (frnIt.hasNext()) {
            FieldRefNode frn = (FieldRefNode)frnIt.next();
            bases.add(frn.getBase());
        }
        bases = new ArrayList(bases);
        int iteration = 0;
        boolean finalIter = false;
        do {
            changed = false;
            this.currentIteration = new Integer(++iteration);
            if (verbose) {
                G.v().out.println("Iteration: " + iteration);
            }
            for (VarNode v : bases) {
                changed = this.computeP2Set((VarNode)v.getReplacement(), new ArrayList()) | changed;
            }
            if (this.ofcg != null) {
                throw new RuntimeException("NYI");
            }
            if (verbose) {
                G.v().out.println("Processing stores");
            }
            for (final VarNode src : this.pag.storeSources()) {
                Node[] targets = this.pag.storeLookup(src);
                for (int i = 0; i < targets.length; ++i) {
                    final FieldRefNode target = (FieldRefNode)targets[i];
                    changed = target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        public final void visit(Node n) {
                            AllocDotField nDotF = PropCycle.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            nDotF.makeP2Set().addAll(src.getP2Set(), null);
                        }
                    }) | changed;
                }
            }
            if (changed || finalIter) continue;
            finalIter = true;
            if (verbose) {
                G.v().out.println("Doing full graph");
            }
            bases = new ArrayList(this.pag.getVarNodeNumberer().size());
            Numberer.NumbererIterator vIt = this.pag.getVarNodeNumberer().iterator();
            while (vIt.hasNext()) {
                VarNode v;
                v = (VarNode)vIt.next();
                bases.add(v);
            }
            changed = true;
        } while (changed);
    }

    private boolean computeP2Set(VarNode v, ArrayList path) {
        ValNode src;
        int i;
        Node[] srcs;
        boolean ret = false;
        if (path.contains(v)) {
            for (Node n : path) {
            }
            return false;
        }
        if (this.currentIteration == this.varNodeToIteration.get(v)) {
            return false;
        }
        this.varNodeToIteration.put(v, this.currentIteration);
        path.add(v);
        if (v.getP2Set().isEmpty()) {
            srcs = this.pag.allocInvLookup(v);
            for (i = 0; i < srcs.length; ++i) {
                ret = v.makeP2Set().add(srcs[i]) | ret;
            }
        }
        srcs = this.pag.simpleInvLookup(v);
        for (i = 0; i < srcs.length; ++i) {
            src = (VarNode)srcs[i];
            ret = this.computeP2Set((VarNode)src, path) | ret;
            ret = v.makeP2Set().addAll(src.getP2Set(), null) | ret;
        }
        srcs = this.pag.loadInvLookup(v);
        for (i = 0; i < srcs.length; ++i) {
            src = (FieldRefNode)srcs[i];
            ret = ((FieldRefNode)src).getBase().getP2Set().forall(new P2SetVisitor((FieldRefNode)src, v){
                final /* synthetic */ FieldRefNode val$src;
                final /* synthetic */ VarNode val$v;
                {
                    this.val$src = fieldRefNode;
                    this.val$v = varNode;
                }

                public final void visit(Node n) {
                    AllocNode an = (AllocNode)n;
                    AllocDotField adf = PropCycle.this.pag.makeAllocDotField(an, this.val$src.getField());
                    this.returnValue = this.val$v.makeP2Set().addAll(adf.getP2Set(), null) | this.returnValue;
                }
            }) | ret;
        }
        path.remove(path.size() - 1);
        return ret;
    }
}

