/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.MultiMap;
import soot.util.queue.QueueReader;

public final class PropAlias
extends Propagator {
    protected final Set varNodeWorkList = new TreeSet();
    protected Set aliasWorkList;
    protected Set fieldRefWorkList = new HashSet();
    protected Set outFieldRefWorkList = new HashSet();
    protected PAG pag;
    protected MultiMap fieldToBase = new HashMultiMap();
    protected MultiMap aliasEdges = new HashMultiMap();
    protected LargeNumberedMap loadSets;
    protected OnFlyCallGraph ofcg;

    public PropAlias(PAG pag) {
        this.pag = pag;
        this.loadSets = new LargeNumberedMap(pag.getFieldRefNodeNumberer());
    }

    public final void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (FieldRefNode fr : this.pag.loadSources()) {
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        for (FieldRefNode fr : this.pag.storeInvSources()) {
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        Iterator it = this.pag.allocSources().iterator();
        while (it.hasNext()) {
            this.handleAllocNode((AllocNode)it.next());
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            this.aliasWorkList = new HashSet();
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src = (VarNode)this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src);
                this.aliasWorkList.add(src);
                this.handleVarNode(src);
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            for (ValNode src : this.aliasWorkList) {
                for (FieldRefNode srcFr : ((VarNode)src).getAllFieldRefs()) {
                    SparkField field = srcFr.getField();
                    for (VarNode dst : this.fieldToBase.get(field)) {
                        if (!src.getP2Set().hasNonEmptyIntersection(dst.getP2Set())) continue;
                        FieldRefNode dstFr = dst.dot(field);
                        this.aliasEdges.put(srcFr, dstFr);
                        this.aliasEdges.put(dstFr, srcFr);
                        this.fieldRefWorkList.add(srcFr);
                        this.fieldRefWorkList.add(dstFr);
                        if (this.makeP2Set(dstFr).addAll(srcFr.getP2Set().getOldSet(), null)) {
                            this.outFieldRefWorkList.add(dstFr);
                        }
                        if (!this.makeP2Set(srcFr).addAll(dstFr.getP2Set().getOldSet(), null)) continue;
                        this.outFieldRefWorkList.add(srcFr);
                    }
                }
            }
            for (ValNode src : this.fieldRefWorkList) {
                for (FieldRefNode dst : this.aliasEdges.get(src)) {
                    if (!this.makeP2Set(dst).addAll(src.getP2Set().getNewSet(), null)) continue;
                    this.outFieldRefWorkList.add(dst);
                }
                src.getP2Set().flushNew();
            }
            this.fieldRefWorkList = new HashSet();
            for (ValNode src : this.outFieldRefWorkList) {
                PointsToSetInternal set = this.getP2Set((FieldRefNode)src).getNewSet();
                if (set.isEmpty()) continue;
                Node[] targets = this.pag.loadLookup((FieldRefNode)src);
                for (int i = 0; i < targets.length; ++i) {
                    VarNode target = (VarNode)targets[i];
                    if (!target.makeP2Set().addAll(set, null)) continue;
                    this.addToWorklist(target);
                }
                this.getP2Set((FieldRefNode)src).flushNew();
            }
            this.outFieldRefWorkList = new HashSet();
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        boolean ret = false;
        Node[] targets = this.pag.allocLookup(src);
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].makeP2Set().add(src)) continue;
            this.addToWorklist((VarNode)targets[i]);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        boolean ret = false;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            Node addedSrc;
            QueueReader addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while ((addedSrc = (Node)addedEdges.next()) != null) {
                VarNode edgeTgt;
                Node edgeSrc;
                Node addedTgt = (Node)addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    if (addedTgt instanceof VarNode) {
                        edgeSrc = (VarNode)addedSrc;
                        edgeTgt = (VarNode)addedTgt;
                        if (edgeTgt.makeP2Set().addAll(edgeSrc.getP2Set(), null)) {
                            this.addToWorklist(edgeTgt);
                        }
                    }
                } else if (addedSrc instanceof AllocNode) {
                    edgeSrc = (AllocNode)addedSrc;
                    edgeTgt = (VarNode)addedTgt;
                    if (edgeTgt.makeP2Set().add(edgeSrc)) {
                        this.addToWorklist(edgeTgt);
                    }
                }
                FieldRefNode frn = null;
                if (addedSrc instanceof FieldRefNode) {
                    frn = (FieldRefNode)addedSrc;
                }
                if (addedTgt instanceof FieldRefNode) {
                    frn = (FieldRefNode)addedTgt;
                }
                if (frn == null) continue;
                VarNode base = frn.getBase();
                if (!this.fieldToBase.put(frn.getField(), base)) continue;
                this.aliasWorkList.add(base);
            }
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (int i = 0; i < simpleTargets.length; ++i) {
            if (!simpleTargets[i].makeP2Set().addAll(newP2Set, null)) continue;
            this.addToWorklist((VarNode)simpleTargets[i]);
            ret = true;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        for (int i = 0; i < storeTargets.length; ++i) {
            FieldRefNode fr = (FieldRefNode)storeTargets[i];
            if (!fr.makeP2Set().addAll(newP2Set, null)) continue;
            this.fieldRefWorkList.add(fr);
            ret = true;
        }
        src.getP2Set().flushNew();
        return ret;
    }

    protected final PointsToSetInternal makeP2Set(FieldRefNode n) {
        PointsToSetInternal ret = (PointsToSetInternal)this.loadSets.get(n);
        if (ret == null) {
            ret = this.pag.getSetFactory().newSet(null, this.pag);
            this.loadSets.put(n, ret);
        }
        return ret;
    }

    protected final PointsToSetInternal getP2Set(FieldRefNode n) {
        PointsToSetInternal ret = (PointsToSetInternal)this.loadSets.get(n);
        if (ret == null) {
            return EmptyPointsToSet.v();
        }
        return ret;
    }

    private boolean addToWorklist(VarNode n) {
        if (n.getReplacement() != n) {
            throw new RuntimeException("Adding bad node " + n + " with rep " + n.getReplacement());
        }
        return this.varNodeWorkList.add(n);
    }
}

