/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Iterator;
import soot.FastHierarchy;
import soot.G;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.Numberer;

public class MergeChecker {
    protected PAG pag;
    protected MultiMap fieldToBase = new HashMultiMap();

    public MergeChecker(PAG pag) {
        this.pag = pag;
    }

    public void check() {
        Iterator it = this.pag.allocSources().iterator();
        while (it.hasNext()) {
            this.handleAllocNode((AllocNode)it.next());
        }
        it = this.pag.simpleSources().iterator();
        while (it.hasNext()) {
            this.handleSimples((VarNode)it.next());
        }
        it = this.pag.loadSources().iterator();
        while (it.hasNext()) {
            this.handleLoads((FieldRefNode)it.next());
        }
        it = this.pag.storeSources().iterator();
        while (it.hasNext()) {
            this.handleStores((VarNode)it.next());
        }
        for (FieldRefNode fr : this.pag.loadSources()) {
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        for (FieldRefNode fr : this.pag.storeInvSources()) {
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        Numberer.NumbererIterator srcIt = this.pag.getVarNodeNumberer().iterator();
        while (srcIt.hasNext()) {
            VarNode src = (VarNode)srcIt.next();
            for (FieldRefNode fr : src.getAllFieldRefs()) {
                for (VarNode dst : this.fieldToBase.get(fr.getField())) {
                    FieldRefNode fr2;
                    if (!src.getP2Set().hasNonEmptyIntersection(dst.getP2Set()) || (fr2 = dst.dot(fr.getField())).getReplacement() == fr.getReplacement()) continue;
                    G.v().out.println("Check failure: " + fr + " should be merged with " + fr2);
                }
            }
        }
    }

    protected void checkAll(final Node container2, PointsToSetInternal nodes, final Node upstream) {
        nodes.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                MergeChecker.this.checkNode(container2, n, upstream);
            }
        });
    }

    protected void checkNode(Node container2, Node n, Node upstream) {
        if (container2.getReplacement() != container2) {
            throw new RuntimeException("container " + container2 + " is illegal");
        }
        if (upstream.getReplacement() != upstream) {
            throw new RuntimeException("upstream " + upstream + " is illegal");
        }
        PointsToSetInternal p2set = container2.getP2Set();
        FastHierarchy fh = this.pag.getTypeManager().getFastHierarchy();
        if (!p2set.contains(n) && (fh == null || container2.getType() == null || fh.canStoreType(n.getType(), container2.getType()))) {
            G.v().out.println("Check failure: " + container2 + " does not have " + n + "; upstream is " + upstream);
        }
    }

    protected void handleAllocNode(AllocNode src) {
        Node[] targets = this.pag.allocLookup(src);
        for (int i = 0; i < targets.length; ++i) {
            this.checkNode(targets[i], src, src);
        }
    }

    protected void handleSimples(VarNode src) {
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (int i = 0; i < simpleTargets.length; ++i) {
            this.checkAll(simpleTargets[i], srcSet, src);
        }
    }

    protected void handleStores(VarNode src) {
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        for (int i = 0; i < storeTargets.length; ++i) {
            FieldRefNode fr = (FieldRefNode)storeTargets[i];
            this.checkAll(fr, srcSet, src);
        }
    }

    protected void handleLoads(FieldRefNode src) {
        Node[] loadTargets = this.pag.loadLookup(src);
        PointsToSetInternal set = src.getP2Set();
        if (set.isEmpty()) {
            return;
        }
        for (int i = 0; i < loadTargets.length; ++i) {
            VarNode target = (VarNode)loadTargets[i];
            this.checkAll(target, set, src);
        }
    }
}

