/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.ArrayList;
import java.util.HashMap;
import soot.G;
import soot.Type;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;

public class EBBCollapser {
    protected int numCollapsed = 0;
    protected PAG pag;

    public void collapse() {
        boolean verbose = this.pag.getOpts().verbose();
        if (verbose) {
            G.v().out.println("Total VarNodes: " + this.pag.getVarNodeNumberer().size() + ". Collapsing EBBs...");
        }
        this.collapseAlloc();
        this.collapseLoad();
        this.collapseSimple();
        if (verbose) {
            G.v().out.println("" + this.numCollapsed + " nodes were collapsed.");
        }
    }

    public EBBCollapser(PAG pag) {
        this.pag = pag;
    }

    protected void collapseAlloc() {
        boolean ofcg = this.pag.getOnFlyCallGraph() != null;
        for (AllocNode n : this.pag.allocSources()) {
            Node[] succs = this.pag.allocLookup(n);
            VarNode firstSucc = null;
            for (int i = 0; i < succs.length; ++i) {
                VarNode succ = (VarNode)succs[i];
                if (this.pag.allocInvLookup(succ).length > 1 || this.pag.loadInvLookup(succ).length > 0 || this.pag.simpleInvLookup(succ).length > 0 || ofcg && succ.isInterProcTarget()) continue;
                if (firstSucc == null) {
                    firstSucc = succ;
                    continue;
                }
                if (!firstSucc.getType().equals(succ.getType())) continue;
                firstSucc.mergeWith(succ);
                ++this.numCollapsed;
            }
        }
    }

    protected void collapseSimple() {
        boolean change;
        boolean ofcg = this.pag.getOnFlyCallGraph() != null;
        TypeManager typeManager = (TypeManager)this.pag.getTypeManager();
        do {
            change = false;
            for (VarNode n : new ArrayList(this.pag.simpleSources())) {
                Type nType = n.getType();
                Node[] succs = this.pag.simpleLookup(n);
                for (int i = 0; i < succs.length; ++i) {
                    VarNode succ = (VarNode)succs[i];
                    Type sType = succ.getType();
                    if (!typeManager.castNeverFails(nType, sType) || this.pag.allocInvLookup(succ).length > 0 || this.pag.loadInvLookup(succ).length > 0 || this.pag.simpleInvLookup(succ).length > 1 || ofcg && (succ.isInterProcTarget() || n.isInterProcSource())) continue;
                    n.mergeWith(succ);
                    change = true;
                    ++this.numCollapsed;
                }
            }
        } while (change);
    }

    protected void collapseLoad() {
        boolean ofcg = this.pag.getOnFlyCallGraph() != null;
        TypeManager typeManager = (TypeManager)this.pag.getTypeManager();
        for (FieldRefNode n : new ArrayList(this.pag.loadSources())) {
            Type nType = n.getType();
            Node[] succs = this.pag.loadLookup(n);
            VarNode firstSucc = null;
            HashMap<Type, VarNode> typeToSucc = new HashMap<Type, VarNode>();
            for (int i = 0; i < succs.length; ++i) {
                VarNode succ = (VarNode)succs[i];
                Type sType = succ.getType();
                if (this.pag.allocInvLookup(succ).length > 0 || this.pag.loadInvLookup(succ).length > 1 || this.pag.simpleInvLookup(succ).length > 0 || ofcg && succ.isInterProcTarget()) continue;
                if (typeManager.castNeverFails(nType, sType)) {
                    if (firstSucc == null) {
                        firstSucc = succ;
                        continue;
                    }
                    firstSucc.mergeWith(succ);
                    ++this.numCollapsed;
                    continue;
                }
                VarNode rep = (VarNode)typeToSucc.get(succ.getType());
                if (rep == null) {
                    typeToSucc.put(succ.getType(), succ);
                    continue;
                }
                rep.mergeWith(succ);
                ++this.numCollapsed;
            }
        }
    }
}

