/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.Local;
import soot.PointsToSet;
import soot.Scene;
import soot.SootField;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.BitPointsToSet;
import soot.jimple.spark.sets.DoublePointsToSet;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.HybridPointsToSet;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.sets.SharedPointsToSet;
import soot.jimple.spark.sets.SortedArraySet;
import soot.options.SparkOptions;

public class PAG
extends AbstractPAG {
    protected static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    protected P2SetFactory setFactory;
    protected boolean somethingMerged = false;

    public PAG(SparkOptions opts) {
        super(opts);
        this.typeManager = new TypeManager(this);
        if (!opts.ignore_types()) {
            this.typeManager.setFastHierarchy(Scene.v().getOrMakeFastHierarchy());
        }
        switch (opts.set_impl()) {
            case 1: {
                this.setFactory = HashPointsToSet.getFactory();
                break;
            }
            case 3: {
                this.setFactory = HybridPointsToSet.getFactory();
                break;
            }
            case 6: {
                this.setFactory = SharedPointsToSet.getFactory();
                break;
            }
            case 4: {
                this.setFactory = SortedArraySet.getFactory();
                break;
            }
            case 2: {
                this.setFactory = BitPointsToSet.getFactory();
                break;
            }
            case 5: {
                P2SetFactory newF;
                P2SetFactory oldF;
                switch (opts.double_set_old()) {
                    case 1: {
                        oldF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        oldF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        oldF = SharedPointsToSet.getFactory();
                        break;
                    }
                    case 4: {
                        oldF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        oldF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                switch (opts.double_set_new()) {
                    case 1: {
                        newF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        newF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        newF = SharedPointsToSet.getFactory();
                        break;
                    }
                    case 4: {
                        newF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        newF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                this.setFactory = DoublePointsToSet.getFactory(newF, oldF);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public PointsToSet reachingObjects(Local l) {
        LocalVarNode n = this.findLocalVarNode(l);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    public PointsToSet reachingObjects(SootField f) {
        if (!f.isStatic()) {
            throw new RuntimeException("The parameter f must be a *static* field.");
        }
        GlobalVarNode n = this.findGlobalVarNode(f);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        if (f.isStatic()) {
            throw new RuntimeException("The parameter f must be an *instance* field.");
        }
        return this.reachingObjectsInternal(s, f);
    }

    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        return this.reachingObjectsInternal(s, ArrayElement.v());
    }

    private PointsToSet reachingObjectsInternal(PointsToSet s, final SparkField f) {
        if (this.getOpts().field_based() || this.getOpts().vta()) {
            GlobalVarNode n = this.findGlobalVarNode(f);
            if (n == null) {
                return EmptyPointsToSet.v();
            }
            return n.getP2Set();
        }
        if (((SparkOptions)this.getOpts()).propagator() == 5) {
            throw new RuntimeException("The alias edge propagator does not compute points-to information for instance fields! Use a different propagator.");
        }
        PointsToSetInternal bases = (PointsToSetInternal)s;
        final PointsToSetInternal ret = this.setFactory.newSet(f instanceof SootField ? ((SootField)f).getType() : null, this);
        bases.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                ret.addAll(((AllocNode)n).dot(f).getP2Set(), null);
            }
        });
        return ret;
    }

    public P2SetFactory getSetFactory() {
        return this.setFactory;
    }

    public void cleanUpMerges() {
        if (this.opts.verbose()) {
            G.v().out.println("Cleaning up graph for merged nodes");
        }
        Map[] maps = new Map[]{this.simple, this.alloc, this.store, this.load, this.simpleInv, this.allocInv, this.storeInv, this.loadInv};
        for (int i = 0; i < maps.length; ++i) {
            Map m = maps[i];
            Iterator it = m.keySet().iterator();
            while (it.hasNext()) {
                this.lookup(m, it.next());
            }
        }
        this.somethingMerged = false;
        if (this.opts.verbose()) {
            G.v().out.println("Done cleaning up graph for merged nodes");
        }
    }

    public boolean doAddSimpleEdge(VarNode from, VarNode to) {
        return this.addToMap(this.simple, from, to) | this.addToMap(this.simpleInv, to, from);
    }

    public boolean doAddStoreEdge(VarNode from, FieldRefNode to) {
        return this.addToMap(this.store, from, to) | this.addToMap(this.storeInv, to, from);
    }

    public boolean doAddLoadEdge(FieldRefNode from, VarNode to) {
        return this.addToMap(this.load, from, to) | this.addToMap(this.loadInv, to, from);
    }

    public boolean doAddAllocEdge(AllocNode from, VarNode to) {
        return this.addToMap(this.alloc, from, to) | this.addToMap(this.allocInv, to, from);
    }

    void mergedWith(Node n1, Node n2) {
        if (n1.equals(n2)) {
            throw new RuntimeException("oops");
        }
        this.somethingMerged = true;
        if (this.ofcg() != null) {
            this.ofcg().mergedWith(n1, n2);
        }
        Map[] maps = new Map[]{this.simple, this.alloc, this.store, this.load, this.simpleInv, this.allocInv, this.storeInv, this.loadInv};
        for (int mapi = 0; mapi < maps.length; ++mapi) {
            Map m = maps[mapi];
            if (!m.keySet().contains(n2)) continue;
            Object[] os = new Object[]{m.get(n1), m.get(n2)};
            int size1 = PAG.getSize(os[0]);
            int size2 = PAG.getSize(os[1]);
            if (size1 == 0) {
                if (os[1] != null) {
                    m.put(n1, os[1]);
                }
            } else if (size2 != 0) {
                Node[] ar;
                if (os[0] instanceof HashSet) {
                    if (os[1] instanceof HashSet) {
                        ((HashSet)os[0]).addAll((HashSet)os[1]);
                    } else {
                        ar = (Node[])os[1];
                        for (int j = 0; j < ar.length; ++j) {
                            ((HashSet)os[0]).add(ar[j]);
                        }
                    }
                } else if (os[1] instanceof HashSet) {
                    ar = (Node[])os[0];
                    for (int j = 0; j < ar.length; ++j) {
                        ((HashSet)os[1]).add(ar[j]);
                    }
                    m.put(n1, os[1]);
                } else if (size1 * size2 < 1000) {
                    Node[] a1 = (Node[])os[0];
                    Node[] a2 = (Node[])os[1];
                    Node[] ret = new Node[size1 + size2];
                    System.arraycopy(a1, 0, ret, 0, a1.length);
                    int j = a1.length;
                    block3: for (int i = 0; i < a2.length; ++i) {
                        Node rep = a2[i];
                        for (int k = 0; k < j; ++k) {
                            if (rep == ret[k]) continue block3;
                        }
                        ret[j++] = rep;
                    }
                    Node[] newArray = new Node[j];
                    System.arraycopy(ret, 0, newArray, 0, j);
                    ret = newArray;
                    m.put(n1, newArray);
                } else {
                    HashSet<Node> s = new HashSet<Node>(size1 + size2);
                    for (int j = 0; j < os.length; ++j) {
                        Object o = os[j];
                        if (o == null) continue;
                        if (o instanceof Set) {
                            s.addAll((Set)o);
                            continue;
                        }
                        Node[] ar2 = (Node[])o;
                        for (int k = 0; k < ar2.length; ++k) {
                            s.add(ar2[k]);
                        }
                    }
                    m.put(n1, s);
                }
            }
            m.remove(n2);
        }
    }

    protected Node[] lookup(Map m, Object key) {
        Object valueList = m.get(key);
        if (valueList == null) {
            return EMPTY_NODE_ARRAY;
        }
        if (valueList instanceof Set) {
            try {
                valueList = ((Set)valueList).toArray(EMPTY_NODE_ARRAY);
                m.put(key, valueList);
            }
            catch (Exception e) {
                Iterator it = ((Set)valueList).iterator();
                while (it.hasNext()) {
                    G.v().out.println("" + it.next());
                }
                throw new RuntimeException("" + valueList + e);
            }
        }
        Node[] ret = (Node[])valueList;
        if (this.somethingMerged) {
            for (int i = 0; i < ret.length; ++i) {
                int j;
                Node reti = ret[i];
                Node rep = reti.getReplacement();
                if (rep == reti && rep != key) continue;
                if (ret.length <= 75) {
                    int j2 = i;
                    while (i < ret.length) {
                        block14: {
                            reti = ret[i];
                            rep = reti.getReplacement();
                            if (rep != key) {
                                for (int k = 0; k < j2; ++k) {
                                    if (rep != ret[k]) {
                                        continue;
                                    }
                                    break block14;
                                }
                                ret[j2++] = rep;
                            }
                        }
                        ++i;
                    }
                    Node[] newArray = new Node[j2];
                    System.arraycopy(ret, 0, newArray, 0, j2);
                    ret = newArray;
                    m.put(key, newArray);
                    break;
                }
                HashSet<Node> s = new HashSet<Node>(ret.length * 2);
                for (j = 0; j < i; ++j) {
                    s.add(ret[j]);
                }
                for (j = i; j < ret.length; ++j) {
                    rep = ret[j].getReplacement();
                    if (rep == key) continue;
                    s.add(rep);
                }
                ret = s.toArray(EMPTY_NODE_ARRAY);
                m.put(key, ret);
                break;
            }
        }
        return ret;
    }

    public Node[] simpleLookup(VarNode key) {
        return this.lookup(this.simple, key);
    }

    public Node[] simpleInvLookup(VarNode key) {
        return this.lookup(this.simpleInv, key);
    }

    public Node[] loadLookup(FieldRefNode key) {
        return this.lookup(this.load, key);
    }

    public Node[] loadInvLookup(VarNode key) {
        return this.lookup(this.loadInv, key);
    }

    public Node[] storeLookup(VarNode key) {
        return this.lookup(this.store, key);
    }

    public Node[] storeInvLookup(FieldRefNode key) {
        return this.lookup(this.storeInv, key);
    }

    public Node[] allocLookup(AllocNode key) {
        return this.lookup(this.alloc, key);
    }

    public Node[] allocInvLookup(VarNode key) {
        return this.lookup(this.allocInv, key);
    }

    public Set simpleSources() {
        return this.simple.keySet();
    }

    public Set allocSources() {
        return this.alloc.keySet();
    }

    public Set storeSources() {
        return this.store.keySet();
    }

    public Set loadSources() {
        return this.load.keySet();
    }

    public Set simpleInvSources() {
        return this.simpleInv.keySet();
    }

    public Set allocInvSources() {
        return this.allocInv.keySet();
    }

    public Set storeInvSources() {
        return this.storeInv.keySet();
    }

    public Set loadInvSources() {
        return this.loadInv.keySet();
    }

    public Iterator simpleSourcesIterator() {
        return this.simple.keySet().iterator();
    }

    public Iterator allocSourcesIterator() {
        return this.alloc.keySet().iterator();
    }

    public Iterator storeSourcesIterator() {
        return this.store.keySet().iterator();
    }

    public Iterator loadSourcesIterator() {
        return this.load.keySet().iterator();
    }

    public Iterator simpleInvSourcesIterator() {
        return this.simpleInv.keySet().iterator();
    }

    public Iterator allocInvSourcesIterator() {
        return this.allocInv.keySet().iterator();
    }

    public Iterator storeInvSourcesIterator() {
        return this.storeInv.keySet().iterator();
    }

    public Iterator loadInvSourcesIterator() {
        return this.loadInv.keySet().iterator();
    }

    private static int getSize(Object set) {
        if (set instanceof Set) {
            return ((Set)set).size();
        }
        if (set == null) {
            return 0;
        }
        return ((Object[])set).length;
    }
}

